/*
 * Decompiled with CFR 0.152.
 */
package com.soystargaze.lumen.utils;

import com.soystargaze.lumen.database.LightRegistry;
import com.soystargaze.lumen.utils.text.TextHandler;
import java.util.ArrayList;
import java.util.concurrent.BlockingQueue;
import java.util.concurrent.Executors;
import java.util.concurrent.LinkedBlockingQueue;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.TimeUnit;
import org.bukkit.Location;

public class BatchProcessor {
    private static final BlockingQueue<BatchEntry> batchQueue = new LinkedBlockingQueue<BatchEntry>();
    private static final int BATCH_SIZE = 1000;
    private static final long BATCH_DELAY_MS = 500L;
    private static final ScheduledExecutorService executor = Executors.newSingleThreadScheduledExecutor();

    public static void addBlockToBatch(Location location, int lightLevel, int operationId) {
        boolean success = batchQueue.offer(new BatchEntry(location, lightLevel, operationId));
        if (!success) {
            TextHandler.get().logTranslated("light_registry.error.add_block_failed", location, operationId);
        }
    }

    private static void processBatch() {
        ArrayList batch = new ArrayList();
        batchQueue.drainTo(batch, 1000);
        if (!batch.isEmpty()) {
            int operationId = ((BatchEntry)batch.getFirst()).operationId();
            ArrayList<Location> locations = new ArrayList<Location>();
            int lightLevel = ((BatchEntry)batch.getFirst()).lightLevel();
            for (BatchEntry entry : batch) {
                locations.add(entry.location());
            }
            LightRegistry.addBlocksAsync(locations, lightLevel, operationId);
            TextHandler.get().logTranslated("light_registry.info.batch_processed", locations.size(), operationId);
        }
    }

    static {
        executor.scheduleAtFixedRate(() -> {
            try {
                BatchProcessor.processBatch();
            }
            catch (Exception e) {
                TextHandler.get().logTranslated("light.error.batch_failed" + e.getMessage(), new Object[0]);
            }
        }, 0L, 500L, TimeUnit.MILLISECONDS);
    }

    private record BatchEntry(Location location, int lightLevel, int operationId) {
    }
}

