/*
 * Decompiled with CFR 0.152.
 */
package com.yourname.ultimatewall;

import java.util.ArrayList;
import java.util.List;
import org.bukkit.Location;
import org.bukkit.Material;
import org.bukkit.block.Block;
import org.bukkit.entity.Player;

public class TemporaryWallData {
    private Player owner;
    private Location center;
    private Material wallMaterial;
    private int corner1X;
    private int corner1Y;
    private int corner1Z;
    private int corner2X;
    private int corner2Y;
    private int corner2Z;
    private List<Block> wallBlocks = new ArrayList<Block>();
    private List<Material> originalMaterials = new ArrayList<Material>();

    public TemporaryWallData(Player owner, Location center, Material wallMaterial, int corner1X, int corner1Y, int corner1Z, int corner2X, int corner2Y, int corner2Z) {
        this.owner = owner;
        this.center = center;
        this.wallMaterial = wallMaterial;
        this.corner1X = corner1X;
        this.corner1Y = corner1Y;
        this.corner1Z = corner1Z;
        this.corner2X = corner2X;
        this.corner2Y = corner2Y;
        this.corner2Z = corner2Z;
    }

    public Player getOwner() {
        return this.owner;
    }

    public Location getCenter() {
        return this.center;
    }

    public void createWall() {
        int minX = Math.min(this.center.getBlockX() + this.corner1X, this.center.getBlockX() + this.corner2X);
        int maxX = Math.max(this.center.getBlockX() + this.corner1X, this.center.getBlockX() + this.corner2X);
        int minY = Math.min(this.center.getBlockY() + this.corner1Y, this.center.getBlockY() + this.corner2Y);
        int maxY = Math.max(this.center.getBlockY() + this.corner1Y, this.center.getBlockY() + this.corner2Y);
        int minZ = Math.min(this.center.getBlockZ() + this.corner1Z, this.center.getBlockZ() + this.corner2Z);
        int maxZ = Math.max(this.center.getBlockZ() + this.corner1Z, this.center.getBlockZ() + this.corner2Z);
        for (int x = minX; x <= maxX; ++x) {
            for (int y = minY; y <= maxY; ++y) {
                for (int z = minZ; z <= maxZ; ++z) {
                    Block block = this.center.getWorld().getBlockAt(x, y, z);
                    if (!block.getType().isSolid() && !block.getType().isAir()) continue;
                    this.originalMaterials.add(block.getType());
                    this.wallBlocks.add(block);
                    block.setType(this.wallMaterial);
                }
            }
        }
    }

    public void removeWall() {
        for (int i = 0; i < this.wallBlocks.size(); ++i) {
            this.wallBlocks.get(i).setType(this.originalMaterials.get(i));
        }
        this.wallBlocks.clear();
        this.originalMaterials.clear();
    }

    public List<Block> getWallBlocks() {
        return this.wallBlocks;
    }

    public boolean shouldProtect(int dx, int dy, int dz) {
        int minX = Math.min(this.corner1X, this.corner2X);
        int maxX = Math.max(this.corner1X, this.corner2X);
        int minY = Math.min(this.corner1Y, this.corner2Y);
        int maxY = Math.max(this.corner1Y, this.corner2Y);
        int minZ = Math.min(this.corner1Z, this.corner2Z);
        int maxZ = Math.max(this.corner1Z, this.corner2Z);
        return dx >= minX && dx <= maxX && dy >= minY && dy <= maxY && dz >= minZ && dz <= maxZ;
    }
}

