/*
 * Decompiled with CFR 0.152.
 */
package com.yourname.ultimatewall;

import com.yourname.ultimatewall.OwnedWallData;
import com.yourname.ultimatewall.RegionData;
import com.yourname.ultimatewall.TemporaryWallData;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import java.util.stream.Collectors;
import org.bukkit.Bukkit;
import org.bukkit.Location;
import org.bukkit.Material;
import org.bukkit.Particle;
import org.bukkit.Sound;
import org.bukkit.World;
import org.bukkit.block.Block;
import org.bukkit.command.Command;
import org.bukkit.command.CommandExecutor;
import org.bukkit.command.CommandSender;
import org.bukkit.command.TabExecutor;
import org.bukkit.configuration.ConfigurationSection;
import org.bukkit.configuration.file.FileConfiguration;
import org.bukkit.entity.Player;
import org.bukkit.event.EventHandler;
import org.bukkit.event.Listener;
import org.bukkit.event.block.BlockBreakEvent;
import org.bukkit.event.block.BlockPlaceEvent;
import org.bukkit.event.player.PlayerMoveEvent;
import org.bukkit.inventory.ItemStack;
import org.bukkit.inventory.meta.ItemMeta;
import org.bukkit.metadata.FixedMetadataValue;
import org.bukkit.metadata.MetadataValue;
import org.bukkit.plugin.Plugin;
import org.bukkit.plugin.java.JavaPlugin;

public class UltimateWallPlugin
extends JavaPlugin
implements Listener,
TabExecutor {
    private final Map<UUID, TemporaryWallData> temporaryWalls = new HashMap<UUID, TemporaryWallData>();
    private final Map<UUID, Integer> temporaryWallRemovalTasks = new HashMap<UUID, Integer>();
    private final Map<Location, OwnedWallData> ownedWalls = new HashMap<Location, OwnedWallData>();
    private final Map<String, RegionData> regions = new HashMap<String, RegionData>();
    private int maxWallsPerPlayer;
    private boolean particlesOnCreate;
    private boolean soundOnCreate;
    private boolean particlesOnDestroy;
    private boolean soundOnDestroy;
    private boolean particlesOnBlock;
    private boolean soundOnBlock;

    public void onEnable() {
        this.saveDefaultConfig();
        this.loadConfigOptions();
        this.loadRegionsFromConfig();
        this.loadOwnedWallsFromConfig();
        this.getServer().getPluginManager().registerEvents((Listener)this, (Plugin)this);
        this.getCommand("wall").setExecutor((CommandExecutor)this);
        this.getCommand("wallgive").setExecutor((CommandExecutor)this);
        this.getCommand("wallremove").setExecutor((CommandExecutor)this);
        this.getCommand("wallregion").setExecutor((CommandExecutor)this);
        this.getCommand("wallflags").setExecutor((CommandExecutor)this);
        this.getCommand("wallreload").setExecutor((CommandExecutor)this);
        this.getCommand("walllist").setExecutor((CommandExecutor)this);
        this.getCommand("wallinfo").setExecutor((CommandExecutor)this);
        this.getLogger().info("UltimateWall enabled.");
    }

    public void onDisable() {
        this.saveRegionsToConfig();
        this.saveOwnedWallsToConfig();
        this.getLogger().info("UltimateWall disabled.");
    }

    private void loadConfigOptions() {
        FileConfiguration config = this.getConfig();
        this.maxWallsPerPlayer = config.getInt("max-walls-per-player", 5);
        this.particlesOnCreate = config.getBoolean("visual-effects.create.particles", true);
        this.soundOnCreate = config.getBoolean("visual-effects.create.sound", true);
        this.particlesOnDestroy = config.getBoolean("visual-effects.destroy.particles", true);
        this.soundOnDestroy = config.getBoolean("visual-effects.destroy.sound", true);
        this.particlesOnBlock = config.getBoolean("visual-effects.block.particles", true);
        this.soundOnBlock = config.getBoolean("visual-effects.block.sound", true);
    }

    private void playEffect(Location location, String effectType) {
        switch (effectType.toLowerCase()) {
            case "create": {
                if (this.particlesOnCreate) {
                    try {
                        location.getWorld().spawnParticle(Particle.valueOf((String)"CLOUD"), location, 50, 1.0, 1.0, 1.0, 0.1);
                    }
                    catch (IllegalArgumentException e) {
                        this.getLogger().warning("Failed to spawn 'CLOUD' particle. It might not be supported in this server version.");
                    }
                }
                if (!this.soundOnCreate) break;
                location.getWorld().playSound(location, Sound.BLOCK_END_PORTAL_FRAME_FILL, 1.0f, 1.0f);
                break;
            }
            case "destroy": {
                if (this.particlesOnDestroy) {
                    try {
                        location.getWorld().spawnParticle(Particle.valueOf((String)"SMOKE_LARGE"), location, 50, 1.0, 1.0, 1.0, 0.1);
                    }
                    catch (IllegalArgumentException e) {
                        this.getLogger().warning("Failed to spawn 'SMOKE_LARGE' particle. It might not be supported in this server version.");
                    }
                }
                if (!this.soundOnDestroy) break;
                location.getWorld().playSound(location, Sound.BLOCK_GLASS_BREAK, 1.0f, 1.0f);
                break;
            }
            case "block": {
                if (this.particlesOnBlock) {
                    try {
                        location.getWorld().spawnParticle(Particle.valueOf((String)"BARRIER"), location, 1);
                    }
                    catch (IllegalArgumentException e) {
                        this.getLogger().warning("Failed to spawn 'BARRIER' particle. It might not be supported in this server version.");
                    }
                }
                if (!this.soundOnBlock) break;
                location.getWorld().playSound(location, Sound.ENTITY_VEX_HURT, 0.5f, 1.5f);
            }
        }
    }

    private long getOwnedWallCount(UUID playerUUID) {
        return this.ownedWalls.values().stream().filter(wall -> wall.getOwnerUUID().equals(playerUUID)).count();
    }

    private void loadRegionsFromConfig() {
        this.regions.clear();
        FileConfiguration config = this.getConfig();
        if (config.isConfigurationSection("regions")) {
            for (String regionName : config.getConfigurationSection("regions").getKeys(false)) {
                String path = "regions." + regionName;
                String worldName = config.getString(path + ".world");
                double minX = config.getDouble(path + ".minX");
                double minY = config.getDouble(path + ".minY");
                double minZ = config.getDouble(path + ".minZ");
                double maxX = config.getDouble(path + ".maxX");
                double maxY = config.getDouble(path + ".maxY");
                double maxZ = config.getDouble(path + ".maxZ");
                World world = Bukkit.getWorld((String)worldName);
                if (world == null) continue;
                Location min = new Location(world, minX, minY, minZ);
                Location max = new Location(world, maxX, maxY, maxZ);
                RegionData region = new RegionData(regionName, min, max);
                region.setAllowBlockBreak(config.getBoolean(path + ".flags.allowBlockBreak", true));
                region.setAllowBlockPlace(config.getBoolean(path + ".flags.allowBlockPlace", true));
                region.setAllowPlayerPass(config.getBoolean(path + ".flags.allowPlayerPass", true));
                region.setAllowEntityPass(config.getBoolean(path + ".flags.allowEntityPass", true));
                this.regions.put(regionName, region);
            }
        }
    }

    private void saveRegionsToConfig() {
        FileConfiguration config = this.getConfig();
        config.set("regions", null);
        for (Map.Entry<String, RegionData> entry : this.regions.entrySet()) {
            String regionName = entry.getKey();
            RegionData region = entry.getValue();
            String path = "regions." + regionName;
            config.set(path + ".world", (Object)region.getMin().getWorld().getName());
            config.set(path + ".minX", (Object)region.getMin().getX());
            config.set(path + ".minY", (Object)region.getMin().getY());
            config.set(path + ".minZ", (Object)region.getMin().getZ());
            config.set(path + ".maxX", (Object)region.getMax().getX());
            config.set(path + ".maxY", (Object)region.getMax().getY());
            config.set(path + ".maxZ", (Object)region.getMax().getZ());
            config.set(path + ".flags.allowBlockBreak", (Object)region.isAllowBlockBreak());
            config.set(path + ".flags.allowBlockPlace", (Object)region.isAllowBlockPlace());
            config.set(path + ".flags.allowPlayerPass", (Object)region.isAllowPlayerPass());
            config.set(path + ".flags.allowEntityPass", (Object)region.isAllowEntityPass());
        }
        this.saveConfig();
    }

    private void loadOwnedWallsFromConfig() {
        this.ownedWalls.clear();
        FileConfiguration config = this.getConfig();
        if (config.isConfigurationSection("ownedWalls")) {
            for (String key : config.getConfigurationSection("ownedWalls").getKeys(false)) {
                ConfigurationSection section = config.getConfigurationSection("ownedWalls." + key);
                OwnedWallData ownedWall = new OwnedWallData(section);
                this.ownedWalls.put(ownedWall.getCenter(), ownedWall);
            }
        }
    }

    private void saveOwnedWallsToConfig() {
        FileConfiguration config = this.getConfig();
        config.set("ownedWalls", null);
        int index = 0;
        for (OwnedWallData ownedWall : this.ownedWalls.values()) {
            ownedWall.saveToConfig(config.createSection("ownedWalls." + index));
            ++index;
        }
        this.saveConfig();
    }

    @EventHandler
    public void onBlockPlace(BlockPlaceEvent event) {
        Player player = event.getPlayer();
        Block block = event.getBlock();
        Location blockLoc = block.getLocation();
        ItemStack itemInHand = event.getItemInHand();
        if (itemInHand != null && itemInHand.getType() == Material.BARRIER && itemInHand.hasItemMeta() && itemInHand.getItemMeta().hasDisplayName() && itemInHand.getItemMeta().getDisplayName().equals("\u00a7rWall Placement Item")) {
            event.setCancelled(true);
            if (this.temporaryWalls.containsKey(player.getUniqueId())) {
                player.sendMessage("\u00a7cYou already have an active temporary wall. Use /wallremove to remove it first.");
                return;
            }
            if (this.maxWallsPerPlayer != -1 && this.getOwnedWallCount(player.getUniqueId()) + this.temporaryWalls.values().stream().filter(w -> w.getOwner().getUniqueId().equals(player.getUniqueId())).count() >= (long)this.maxWallsPerPlayer) {
                player.sendMessage("\u00a7cYou have reached the maximum number of walls you can own.");
                return;
            }
            FileConfiguration config = this.getConfig();
            Material wallMaterial = Material.valueOf((String)config.getString("wall-material"));
            int corner1X = config.getInt("shape-walls.corner1-x");
            int corner1Y = config.getInt("shape-walls.corner1-y");
            int corner1Z = config.getInt("shape-walls.corner1-z");
            int corner2X = config.getInt("shape-walls.corner2-x");
            int corner2Y = config.getInt("shape-walls.corner2-y");
            int corner2Z = config.getInt("shape-walls.corner2-z");
            TemporaryWallData temporaryWall = new TemporaryWallData(player, player.getLocation(), wallMaterial, corner1X, corner1Y, corner1Z, corner2X, corner2Y, corner2Z);
            temporaryWall.createWall();
            this.temporaryWalls.put(player.getUniqueId(), temporaryWall);
            this.playEffect(player.getLocation(), "create");
            player.sendMessage("\u00a7aTemporary wall created by placing item!");
            if (config.getBoolean("wall-timer-enabled")) {
                int wallDuration = config.getInt("wall-duration");
                int taskId = Bukkit.getScheduler().scheduleSyncDelayedTask((Plugin)this, () -> {
                    if (this.temporaryWalls.containsKey(player.getUniqueId())) {
                        this.playEffect(this.temporaryWalls.get(player.getUniqueId()).getCenter(), "destroy");
                        this.temporaryWalls.get(player.getUniqueId()).removeWall();
                        this.temporaryWalls.remove(player.getUniqueId());
                        this.temporaryWallRemovalTasks.remove(player.getUniqueId());
                        player.sendMessage("\u00a7eYour temporary wall has been removed.");
                    }
                }, (long)wallDuration * 20L);
                this.temporaryWallRemovalTasks.put(player.getUniqueId(), taskId);
            }
            itemInHand.setAmount(itemInHand.getAmount() - 1);
            return;
        }
        for (RegionData region : this.regions.values()) {
            if (!region.contains(blockLoc) || region.isAllowBlockPlace() || player.hasPermission("ultimatewall.bypass")) continue;
            player.sendMessage("\u00a7cYou cannot place blocks in this protected region.");
            this.playEffect(blockLoc, "block");
            event.setCancelled(true);
            return;
        }
    }

    @EventHandler
    public void onBlockBreak(BlockBreakEvent event) {
        Player player = event.getPlayer();
        Block block = event.getBlock();
        Location blockLoc = block.getLocation();
        for (TemporaryWallData wall : this.temporaryWalls.values()) {
            if (!wall.getWallBlocks().contains(block) || player.getUniqueId().equals(wall.getOwner().getUniqueId()) || player.hasPermission("ultimatewall.bypass")) continue;
            player.sendMessage("\u00a7cYou cannot break this temporary wall.");
            this.playEffect(blockLoc, "block");
            event.setCancelled(true);
            return;
        }
        for (OwnedWallData ownedWall : this.ownedWalls.values()) {
            if (!ownedWall.getWallBlocks().contains(block) || player.getUniqueId().equals(ownedWall.getOwnerUUID()) || player.hasPermission("ultimatewall.bypass")) continue;
            player.sendMessage("\u00a7cYou cannot break this owned wall.");
            this.playEffect(blockLoc, "block");
            event.setCancelled(true);
            return;
        }
        for (RegionData region : this.regions.values()) {
            if (!region.contains(blockLoc) || region.isAllowBlockBreak() || player.hasPermission("ultimatewall.bypass")) continue;
            player.sendMessage("\u00a7cYou cannot break blocks in this protected region.");
            this.playEffect(blockLoc, "block");
            event.setCancelled(true);
            return;
        }
    }

    @EventHandler
    public void onPlayerMove(PlayerMoveEvent event) {
        if (event.getFrom().getBlock().equals((Object)event.getTo().getBlock())) {
            return;
        }
        Player player = event.getPlayer();
        Location to = event.getTo();
        for (TemporaryWallData wall : this.temporaryWalls.values()) {
            if (!wall.getWallBlocks().stream().anyMatch(block -> block.getLocation().equals((Object)to.getBlock().getLocation())) || player.getUniqueId().equals(wall.getOwner().getUniqueId()) || player.hasPermission("ultimatewall.bypass")) continue;
            event.setCancelled(true);
            player.teleport(event.getFrom());
            if (!player.hasMetadata("wall_warned")) {
                player.sendMessage("\u00a7cYou cannot enter this temporary wall.");
                this.playEffect(to, "block");
                player.setMetadata("wall_warned", (MetadataValue)new FixedMetadataValue((Plugin)this, (Object)true));
            }
            return;
        }
        for (OwnedWallData ownedWall : this.ownedWalls.values()) {
            if (!ownedWall.getWallBlocks().stream().anyMatch(block -> block.getLocation().equals((Object)to.getBlock().getLocation())) || player.getUniqueId().equals(ownedWall.getOwnerUUID()) || player.hasPermission("ultimatewall.bypass")) continue;
            event.setCancelled(true);
            player.teleport(event.getFrom());
            if (!player.hasMetadata("wall_warned")) {
                player.sendMessage("\u00a7cYou cannot enter this owned wall.");
                this.playEffect(to, "block");
                player.setMetadata("wall_warned", (MetadataValue)new FixedMetadataValue((Plugin)this, (Object)true));
            }
            return;
        }
        for (RegionData region : this.regions.values()) {
            if (!region.contains(to) || region.isAllowPlayerPass() || player.hasPermission("ultimatewall.bypass")) continue;
            event.setCancelled(true);
            player.teleport(event.getFrom());
            if (!player.hasMetadata("wall_warned")) {
                player.sendMessage("\u00a7cYou cannot enter this protected region.");
                this.playEffect(to, "block");
                player.setMetadata("wall_warned", (MetadataValue)new FixedMetadataValue((Plugin)this, (Object)true));
            }
            return;
        }
        if (player.hasMetadata("wall_warned")) {
            boolean inProtectedArea = false;
            if (this.temporaryWalls.values().stream().anyMatch(w -> w.getWallBlocks().stream().anyMatch(b -> b.getLocation().equals((Object)to.getBlock().getLocation())))) {
                inProtectedArea = true;
            }
            if (!inProtectedArea && this.ownedWalls.values().stream().anyMatch(w -> w.getWallBlocks().stream().anyMatch(b -> b.getLocation().equals((Object)to.getBlock().getLocation())))) {
                inProtectedArea = true;
            }
            if (!inProtectedArea && this.regions.values().stream().anyMatch(r -> r.contains(to))) {
                inProtectedArea = true;
            }
            if (!inProtectedArea) {
                player.removeMetadata("wall_warned", (Plugin)this);
            }
        }
    }

    public boolean onCommand(CommandSender sender, Command command, String label, String[] args) {
        if (!(sender instanceof Player) && !command.getName().equalsIgnoreCase("walllist")) {
            sender.sendMessage("Only players can use most of these commands.");
            return true;
        }
        Player player = sender instanceof Player ? (Player)sender : null;
        UUID playerUUID = player != null ? player.getUniqueId() : null;
        switch (command.getName().toLowerCase()) {
            case "wall": {
                if (player == null) {
                    return true;
                }
                if (!player.hasPermission("ultimatewall.wall")) {
                    player.sendMessage("\u00a7cYou don\u2019t have permission to use this command.");
                    return true;
                }
                if (this.temporaryWalls.containsKey(playerUUID)) {
                    player.sendMessage("\u00a7cYou already have an active temporary wall. Use /wallremove to remove it first.");
                    return true;
                }
                if (this.maxWallsPerPlayer != -1 && this.getOwnedWallCount(playerUUID) + this.temporaryWalls.values().stream().filter(w -> w.getOwner().getUniqueId().equals(playerUUID)).count() >= (long)this.maxWallsPerPlayer) {
                    player.sendMessage("\u00a7cYou have reached the maximum number of walls you can own.");
                    return true;
                }
                FileConfiguration config = this.getConfig();
                TemporaryWallData temporaryWall = new TemporaryWallData(player, player.getLocation(), Material.valueOf((String)config.getString("wall-material")), config.getInt("shape-walls.corner1-x"), config.getInt("shape-walls.corner1-y"), config.getInt("shape-walls.corner1-z"), config.getInt("shape-walls.corner2-x"), config.getInt("shape-walls.corner2-y"), config.getInt("shape-walls.corner2-z"));
                temporaryWall.createWall();
                this.temporaryWalls.put(playerUUID, temporaryWall);
                this.playEffect(player.getLocation(), "create");
                player.sendMessage("\u00a7aTemporary wall created!");
                if (config.getBoolean("wall-timer-enabled")) {
                    int wallDuration = config.getInt("wall-duration");
                    int taskId = Bukkit.getScheduler().scheduleSyncDelayedTask((Plugin)this, () -> {
                        if (this.temporaryWalls.containsKey(playerUUID)) {
                            this.playEffect(this.temporaryWalls.get(playerUUID).getCenter(), "destroy");
                            this.temporaryWalls.get(playerUUID).removeWall();
                            this.temporaryWalls.remove(playerUUID);
                            this.temporaryWallRemovalTasks.remove(playerUUID);
                            player.sendMessage("\u00a7eYour temporary wall has been removed.");
                        }
                    }, (long)wallDuration * 20L);
                    this.temporaryWallRemovalTasks.put(playerUUID, taskId);
                }
                return true;
            }
            case "wallreload": {
                if (player != null && !player.hasPermission("ultimatewall.admin")) {
                    player.sendMessage("\u00a7cYou don\u2019t have permission to reload the config.");
                    return true;
                }
                this.reloadConfig();
                this.loadConfigOptions();
                this.loadOwnedWallsFromConfig();
                this.loadRegionsFromConfig();
                sender.sendMessage("\u00a7aUltimateWall config, owned walls, and regions reloaded.");
                return true;
            }
            case "wallgive": {
                if (player == null) {
                    return true;
                }
                if (!player.hasPermission("ultimatewall.give")) {
                    player.sendMessage("\u00a7cYou don\u2019t have permission to use this command.");
                    return true;
                }
                ItemStack wallItem = new ItemStack(Material.BARRIER);
                ItemMeta meta = wallItem.getItemMeta();
                meta.setDisplayName("\u00a7rWall Placement Item");
                wallItem.setItemMeta(meta);
                player.getInventory().addItem(new ItemStack[]{wallItem});
                player.sendMessage("\u00a7aYou have received a wall placement item.");
                return true;
            }
            case "wallremove": {
                if (player == null) {
                    return true;
                }
                if (!player.hasPermission("ultimatewall.remove")) {
                    player.sendMessage("\u00a7cYou don\u2019t have permission to use this command.");
                    return true;
                }
                if (this.temporaryWalls.containsKey(playerUUID)) {
                    this.playEffect(this.temporaryWalls.get(playerUUID).getCenter(), "destroy");
                    this.temporaryWalls.get(playerUUID).removeWall();
                    this.temporaryWalls.remove(playerUUID);
                    if (this.temporaryWallRemovalTasks.containsKey(playerUUID)) {
                        Bukkit.getScheduler().cancelTask(this.temporaryWallRemovalTasks.get(playerUUID).intValue());
                        this.temporaryWallRemovalTasks.remove(playerUUID);
                    }
                    player.sendMessage("\u00a7aYour active temporary wall has been removed.");
                    return true;
                }
                player.sendMessage("\u00a7cYou don\u2019t have an active temporary wall to remove.");
                return true;
            }
            case "wallregion": {
                if (player == null) {
                    return true;
                }
                if (!player.hasPermission("ultimatewall.region.define")) {
                    player.sendMessage("\u00a7cYou don\u2019t have permission to define regions.");
                    return true;
                }
                if (args.length < 2 || !args[0].equalsIgnoreCase("define")) {
                    player.sendMessage("\u00a7cUsage: /wallregion define <name>");
                    return true;
                }
                String regionName = args[1];
                if (this.regions.containsKey(regionName)) {
                    player.sendMessage("\u00a7cRegion '" + regionName + "' already exists.");
                    return true;
                }
                FileConfiguration regionConfig = this.getConfig();
                Location min = new Location(player.getWorld(), player.getLocation().getX() + (double)Math.min(regionConfig.getInt("shape-walls.corner1-x"), regionConfig.getInt("shape-walls.corner2-x")), player.getLocation().getY() + (double)Math.min(regionConfig.getInt("shape-walls.corner1-y"), regionConfig.getInt("shape-walls.corner2-y")), player.getLocation().getZ() + (double)Math.min(regionConfig.getInt("shape-walls.corner1-z"), regionConfig.getInt("shape-walls.corner2-z")));
                Location max = new Location(player.getWorld(), player.getLocation().getX() + (double)Math.max(regionConfig.getInt("shape-walls.corner1-x"), regionConfig.getInt("shape-walls.corner2-x")), player.getLocation().getY() + (double)Math.max(regionConfig.getInt("shape-walls.corner1-y"), regionConfig.getInt("shape-walls.corner2-y")), player.getLocation().getZ() + (double)Math.max(regionConfig.getInt("shape-walls.corner1-z"), regionConfig.getInt("shape-walls.corner2-z")));
                this.regions.put(regionName, new RegionData(regionName, min, max));
                this.saveRegionsToConfig();
                player.sendMessage("\u00a7aRegion '" + regionName + "' defined around your location.");
                return true;
            }
            case "wallflags": {
                if (player == null) {
                    return true;
                }
                if (!player.hasPermission("ultimatewall.region.flags")) {
                    player.sendMessage("\u00a7cYou don\u2019t have permission to set region flags.");
                    return true;
                }
                if (args.length < 3) {
                    player.sendMessage("\u00a7cUsage: /wallflags <regionname> <flagname> <true|false>");
                    return true;
                }
                String flagRegionName = args[0];
                String flagName = args[1].toLowerCase();
                boolean value = Boolean.parseBoolean(args[2]);
                if (!this.regions.containsKey(flagRegionName)) {
                    player.sendMessage("\u00a7cRegion '" + flagRegionName + "' not found.");
                    return true;
                }
                RegionData region = this.regions.get(flagRegionName);
                switch (flagName) {
                    case "allowblockbreak": {
                        region.setAllowBlockBreak(value);
                        break;
                    }
                    case "allowblockplace": {
                        region.setAllowBlockPlace(value);
                        break;
                    }
                    case "allowplayerpass": {
                        region.setAllowPlayerPass(value);
                        break;
                    }
                    case "allowentitypass": {
                        region.setAllowEntityPass(value);
                        break;
                    }
                    default: {
                        player.sendMessage("\u00a7cInvalid flag name. Available: allowblockbreak, allowblockplace, allowplayerpass, allowentitypass.");
                        return true;
                    }
                }
                this.saveRegionsToConfig();
                player.sendMessage("\u00a7aFlag '" + flagName + "' for region '" + flagRegionName + "' set to " + value + ".");
                return true;
            }
            case "walllist": {
                if (!sender.hasPermission("ultimatewall.admin")) {
                    sender.sendMessage("\u00a7cYou don\u2019t have permission to use this command.");
                    return true;
                }
                sender.sendMessage("\u00a76--- UltimateWall List ---");
                sender.sendMessage("\u00a7eTemporary Walls (" + this.temporaryWalls.size() + "):");
                this.temporaryWalls.forEach((uuid, wall) -> sender.sendMessage("  \u00a77- Owner: " + Bukkit.getOfflinePlayer((UUID)uuid).getName() + ", Loc: " + this.formatLocation(wall.getCenter())));
                sender.sendMessage("\u00a7eOwned Walls (" + this.ownedWalls.size() + "):");
                this.ownedWalls.forEach((loc, wall) -> sender.sendMessage("  \u00a77- Owner: " + Bukkit.getOfflinePlayer((UUID)wall.getOwnerUUID()).getName() + ", Loc: " + this.formatLocation((Location)loc)));
                sender.sendMessage("\u00a7eRegions (" + this.regions.size() + "):");
                this.regions.forEach((name, reg) -> sender.sendMessage("  \u00a77- Name: " + name + ", From: " + this.formatLocation(reg.getMin()) + ", To: " + this.formatLocation(reg.getMax())));
                return true;
            }
            case "wallinfo": {
                if (player == null) {
                    return true;
                }
                if (!player.hasPermission("ultimatewall.info")) {
                    player.sendMessage("\u00a7cYou don\u2019t have permission to use this command.");
                    return true;
                }
                Location playerLoc = player.getLocation();
                for (TemporaryWallData temporaryWallData : this.temporaryWalls.values()) {
                    if (!temporaryWallData.getWallBlocks().stream().anyMatch(b -> b.getLocation().distanceSquared(playerLoc) < 25.0)) continue;
                    player.sendMessage("\u00a76--- Wall Info ---");
                    player.sendMessage("\u00a7eType: \u00a7fTemporary Wall");
                    player.sendMessage("\u00a7eOwner: \u00a7f" + temporaryWallData.getOwner().getName());
                    player.sendMessage("\u00a7eBlocks: \u00a7f" + temporaryWallData.getWallBlocks().size());
                    return true;
                }
                for (OwnedWallData ownedWallData : this.ownedWalls.values()) {
                    if (!(ownedWallData.getCenter().distanceSquared(playerLoc) < 100.0)) continue;
                    player.sendMessage("\u00a76--- Wall Info ---");
                    player.sendMessage("\u00a7eType: \u00a7fOwned Wall");
                    player.sendMessage("\u00a7eOwner: \u00a7f" + Bukkit.getOfflinePlayer((UUID)ownedWallData.getOwnerUUID()).getName());
                    return true;
                }
                for (RegionData regionData : this.regions.values()) {
                    if (!regionData.contains(playerLoc)) continue;
                    player.sendMessage("\u00a76--- Region Info ---");
                    player.sendMessage("\u00a7eName: \u00a7f" + regionData.getName());
                    player.sendMessage("\u00a7eAllow Block Break: \u00a7f" + regionData.isAllowBlockBreak());
                    player.sendMessage("\u00a7eAllow Block Place: \u00a7f" + regionData.isAllowBlockPlace());
                    player.sendMessage("\u00a7eAllow Player Pass: \u00a7f" + regionData.isAllowPlayerPass());
                    player.sendMessage("\u00a7eAllow Entity Pass: \u00a7f" + regionData.isAllowEntityPass());
                    return true;
                }
                player.sendMessage("\u00a7cYou are not inside or near any protected wall or region.");
                return true;
            }
        }
        return false;
    }

    private String formatLocation(Location loc) {
        if (loc == null) {
            return "N/A";
        }
        return String.format("%s, %d, %d, %d", loc.getWorld().getName(), loc.getBlockX(), loc.getBlockY(), loc.getBlockZ());
    }

    public List<String> onTabComplete(CommandSender sender, Command command, String alias, String[] args) {
        ArrayList<String> completions = new ArrayList<String>();
        if (command.getName().equalsIgnoreCase("wallregion")) {
            if (args.length == 1) {
                completions.add("define");
            }
        } else if (command.getName().equalsIgnoreCase("wallflags")) {
            if (args.length == 1) {
                completions.addAll(this.regions.keySet());
            } else if (args.length == 2) {
                completions.add("allowblockbreak");
                completions.add("allowblockplace");
                completions.add("allowplayerpass");
                completions.add("allowentitypass");
            } else if (args.length == 3) {
                completions.add("true");
                completions.add("false");
            }
        }
        return completions.stream().filter(s -> s.toLowerCase().startsWith(args[args.length - 1].toLowerCase())).collect(Collectors.toList());
    }
}

