/*
 * Decompiled with CFR 0.152.
 */
package com.blocklogic.agritech.block.custom;

import com.blocklogic.agritech.block.entity.AgritechPlanterBlockEntity;
import com.blocklogic.agritech.block.entity.ModBlockEntities;
import com.blocklogic.agritech.screen.custom.AgritechPlanterMenu;
import com.blocklogic.agritech.util.RegistryHelper;
import com.mojang.serialization.MapCodec;
import java.util.HashMap;
import net.minecraft.core.BlockPos;
import net.minecraft.network.chat.Component;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.ItemInteractionResult;
import net.minecraft.world.MenuProvider;
import net.minecraft.world.SimpleMenuProvider;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.BlockItem;
import net.minecraft.world.item.HoeItem;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.BaseEntityBlock;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.RenderShape;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityTicker;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.shapes.CollisionContext;
import net.minecraft.world.phys.shapes.VoxelShape;
import net.neoforged.fml.ModList;
import org.jetbrains.annotations.Nullable;

public class AgritechPlanterBlock
extends BaseEntityBlock {
    public static final VoxelShape SHAPE = Block.box((double)1.0, (double)0.0, (double)1.1, (double)15.0, (double)9.0, (double)15.0);
    public static final MapCodec<AgritechPlanterBlock> CODEC = AgritechPlanterBlock.simpleCodec(AgritechPlanterBlock::new);

    public AgritechPlanterBlock(BlockBehaviour.Properties properties) {
        super(properties);
    }

    protected VoxelShape getShape(BlockState state, BlockGetter level, BlockPos pos, CollisionContext context) {
        return SHAPE;
    }

    protected MapCodec<? extends BaseEntityBlock> codec() {
        return CODEC;
    }

    protected RenderShape getRenderShape(BlockState state) {
        return RenderShape.MODEL;
    }

    @Nullable
    public BlockEntity newBlockEntity(BlockPos blockPos, BlockState blockState) {
        return new AgritechPlanterBlockEntity(blockPos, blockState);
    }

    protected void onRemove(BlockState state, Level level, BlockPos pos, BlockState newState, boolean movedByPiston) {
        BlockEntity blockEntity;
        if (state.getBlock() != newState.getBlock() && (blockEntity = level.getBlockEntity(pos)) instanceof AgritechPlanterBlockEntity) {
            AgritechPlanterBlockEntity agritechPlanterBlock = (AgritechPlanterBlockEntity)blockEntity;
            agritechPlanterBlock.drops();
            level.updateNeighbourForOutputSignal(pos, (Block)this);
        }
        super.onRemove(state, level, pos, newState, movedByPiston);
    }

    protected ItemInteractionResult useItemOn(ItemStack stack, BlockState state, Level level, BlockPos pos, Player player, InteractionHand hand, BlockHitResult hitResult) {
        BlockEntity blockEntity = level.getBlockEntity(pos);
        if (blockEntity instanceof AgritechPlanterBlockEntity) {
            Item soilBlock2;
            ItemStack soilStack;
            AgritechPlanterBlockEntity agritechPlanterBlockEntity = (AgritechPlanterBlockEntity)blockEntity;
            String heldItemId = RegistryHelper.getItemId(stack);
            HashMap<String, String> essenceToFarmland = new HashMap<String, String>();
            essenceToFarmland.put("mysticalagriculture:inferium_essence", "mysticalagriculture:inferium_farmland");
            essenceToFarmland.put("mysticalagriculture:prudentium_essence", "mysticalagriculture:prudentium_farmland");
            essenceToFarmland.put("mysticalagriculture:tertium_essence", "mysticalagriculture:tertium_farmland");
            essenceToFarmland.put("mysticalagriculture:imperium_essence", "mysticalagriculture:imperium_farmland");
            essenceToFarmland.put("mysticalagriculture:supremium_essence", "mysticalagriculture:supremium_farmland");
            essenceToFarmland.put("mysticalagradditions:insanium_essence", "mysticalagradditions:insanium_farmland");
            if (essenceToFarmland.containsKey(heldItemId)) {
                String farmlandId;
                Block resultBlock;
                BlockItem blockItem;
                Block soilBlock2;
                String soilId;
                Item item;
                soilStack = agritechPlanterBlockEntity.inventory.getStackInSlot(1);
                if (!soilStack.isEmpty() && (item = soilStack.getItem()) instanceof BlockItem && (soilId = RegistryHelper.getBlockId(soilBlock2 = (blockItem = (BlockItem)item).getBlock())).equals("minecraft:farmland") && (resultBlock = RegistryHelper.getBlock(farmlandId = (String)essenceToFarmland.get(heldItemId))) != null) {
                    ItemStack maFarmlandStack = new ItemStack((ItemLike)resultBlock);
                    agritechPlanterBlockEntity.inventory.setStackInSlot(1, maFarmlandStack);
                    if (!player.getAbilities().instabuild) {
                        stack.shrink(1);
                    }
                    level.playSound(player, pos, SoundEvents.AMETHYST_BLOCK_CHIME, SoundSource.BLOCKS, 1.0f, 1.0f);
                    return ItemInteractionResult.sidedSuccess((boolean)level.isClientSide());
                }
            } else if (stack.getItem() instanceof HoeItem && !(soilStack = agritechPlanterBlockEntity.inventory.getStackInSlot(1)).isEmpty() && (soilBlock2 = soilStack.getItem()) instanceof BlockItem) {
                Block resultBlock;
                BlockItem blockItem = (BlockItem)soilBlock2;
                soilBlock2 = blockItem.getBlock();
                String soilId = RegistryHelper.getBlockId((Block)soilBlock2);
                HashMap<String, String> tillableBlocks = new HashMap<String, String>();
                tillableBlocks.put("minecraft:dirt", "minecraft:farmland");
                tillableBlocks.put("minecraft:grass_block", "minecraft:farmland");
                tillableBlocks.put("minecraft:mycelium", "minecraft:farmland");
                tillableBlocks.put("minecraft:podzol", "minecraft:farmland");
                tillableBlocks.put("minecraft:coarse_dirt", "minecraft:farmland");
                tillableBlocks.put("minecraft:rooted_dirt", "minecraft:farmland");
                if (ModList.get().isLoaded("farmersdelight")) {
                    tillableBlocks.put("farmersdelight:rich_soil", "farmersdelight:rich_soil_farmland");
                    tillableBlocks.put("farmersdelight:organic_compost", "farmersdelight:rich_soil_farmland");
                }
                if (tillableBlocks.containsKey(soilId) && (resultBlock = RegistryHelper.getBlock((String)tillableBlocks.get(soilId))) != null) {
                    ItemStack farmlandStack = new ItemStack((ItemLike)resultBlock);
                    agritechPlanterBlockEntity.inventory.setStackInSlot(1, farmlandStack);
                    level.playSound(player, pos, SoundEvents.HOE_TILL, SoundSource.BLOCKS, 1.0f, 1.0f);
                    if (!player.getAbilities().instabuild) {
                        stack.hurtAndBreak(1, (LivingEntity)player, LivingEntity.getSlotForHand((InteractionHand)hand));
                    }
                    return ItemInteractionResult.sidedSuccess((boolean)level.isClientSide());
                }
            }
            if (!level.isClientSide()) {
                SimpleMenuProvider menuProvider = new SimpleMenuProvider((containerId, playerInventory, playerEntity) -> new AgritechPlanterMenu(containerId, playerInventory, agritechPlanterBlockEntity), (Component)Component.translatable((String)"container.agritech.planter"));
                player.openMenu((MenuProvider)menuProvider, pos);
            }
            return ItemInteractionResult.sidedSuccess((boolean)level.isClientSide());
        }
        return ItemInteractionResult.SUCCESS;
    }

    public <T extends BlockEntity> BlockEntityTicker<T> getTicker(Level level, BlockState state, BlockEntityType<T> type) {
        return type == ModBlockEntities.AGRITECH_PLANTER_BLOCK_ENTITY.get() ? (lvl, pos, blockState, blockEntity) -> AgritechPlanterBlockEntity.tick(lvl, pos, blockState, (AgritechPlanterBlockEntity)blockEntity) : null;
    }
}

