/*
 * Decompiled with CFR 0.152.
 */
package com.blocklogic.agritech.block.entity.renderer;

import com.blocklogic.agritech.block.entity.AgritechPlanterBlockEntity;
import com.mojang.blaze3d.vertex.PoseStack;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.block.BlockRenderDispatcher;
import net.minecraft.client.renderer.blockentity.BlockEntityRenderer;
import net.minecraft.client.renderer.blockentity.BlockEntityRendererProvider;
import net.minecraft.client.renderer.texture.OverlayTexture;
import net.minecraft.world.item.BlockItem;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.IntegerProperty;
import net.minecraft.world.level.block.state.properties.Property;

public class AgritechPlanterBlockEntityRenderer
implements BlockEntityRenderer<AgritechPlanterBlockEntity> {
    public AgritechPlanterBlockEntityRenderer(BlockEntityRendererProvider.Context context) {
    }

    public void render(AgritechPlanterBlockEntity pBlockEntity, float pPartialTick, PoseStack pPoseStack, MultiBufferSource pBufferSource, int pPackedLight, int pPackedOverlay) {
        ItemStack soilStack;
        Item item;
        if (pBlockEntity.inventory.getSlots() > 1 && !pBlockEntity.inventory.getStackInSlot(1).isEmpty() && (item = (soilStack = pBlockEntity.inventory.getStackInSlot(1)).getItem()) instanceof BlockItem) {
            BlockItem blockItem = (BlockItem)item;
            BlockState soilState = blockItem.getBlock().defaultBlockState();
            pPoseStack.pushPose();
            pPoseStack.translate(0.175, 0.4, 0.175);
            pPoseStack.scale(0.65f, 0.05f, 0.65f);
            BlockRenderDispatcher dispatcher = Minecraft.getInstance().getBlockRenderer();
            dispatcher.renderSingleBlock(soilState, pPoseStack, pBufferSource, pPackedLight, OverlayTexture.NO_OVERLAY);
            pPoseStack.popPose();
        }
        if (pBlockEntity.inventory.getSlots() > 0 && !pBlockEntity.inventory.getStackInSlot(0).isEmpty() && pBlockEntity.inventory.getSlots() > 1 && !pBlockEntity.inventory.getStackInSlot(1).isEmpty()) {
            ItemStack seedStack = pBlockEntity.inventory.getStackInSlot(0);
            int growthStage = pBlockEntity.getGrowthStage();
            if (growthStage > 0) {
                pPoseStack.pushPose();
                pPoseStack.translate(0.1725, 0.45, 0.1725);
                float growthScale = 0.2f + (float)growthStage / 7.0f * 0.5f;
                pPoseStack.scale(0.65f, growthScale, 0.65f);
                BlockState cropState = this.getCropBlockState(seedStack, growthStage);
                if (cropState != null) {
                    BlockRenderDispatcher dispatcher = Minecraft.getInstance().getBlockRenderer();
                    dispatcher.renderSingleBlock(cropState, pPoseStack, pBufferSource, pPackedLight, OverlayTexture.NO_OVERLAY);
                }
                pPoseStack.popPose();
            }
        }
    }

    private BlockState getCropBlockState(ItemStack stack, int age) {
        Item item = stack.getItem();
        if (!(item instanceof BlockItem)) {
            return null;
        }
        BlockItem blockItem = (BlockItem)item;
        Block cropBlock = blockItem.getBlock();
        BlockState state = cropBlock.defaultBlockState();
        if (state.hasProperty((Property)BlockStateProperties.AGE_1)) {
            return (BlockState)state.setValue((Property)BlockStateProperties.AGE_1, (Comparable)Integer.valueOf(Math.min(age, 1)));
        }
        if (state.hasProperty((Property)BlockStateProperties.AGE_2)) {
            return (BlockState)state.setValue((Property)BlockStateProperties.AGE_2, (Comparable)Integer.valueOf(Math.min(age, 2)));
        }
        if (state.hasProperty((Property)BlockStateProperties.AGE_3)) {
            return (BlockState)state.setValue((Property)BlockStateProperties.AGE_3, (Comparable)Integer.valueOf(Math.min(age, 3)));
        }
        if (state.hasProperty((Property)BlockStateProperties.AGE_5)) {
            return (BlockState)state.setValue((Property)BlockStateProperties.AGE_5, (Comparable)Integer.valueOf(Math.min(age, 5)));
        }
        if (state.hasProperty((Property)BlockStateProperties.AGE_7)) {
            return (BlockState)state.setValue((Property)BlockStateProperties.AGE_7, (Comparable)Integer.valueOf(Math.min(age, 7)));
        }
        for (Property property : state.getProperties()) {
            if (!property.getName().equals("age") || !(property instanceof IntegerProperty)) continue;
            IntegerProperty intProp = (IntegerProperty)property;
            int maxAge = intProp.getPossibleValues().stream().max(Integer::compareTo).orElse(0);
            int clampedAge = Math.min(age, maxAge);
            return this.setAgeProperty(state, (Property)intProp, clampedAge);
        }
        return state;
    }

    private <T extends Comparable<T>> BlockState setAgeProperty(BlockState state, Property<T> property, int age) {
        return (BlockState)state.setValue(property, (Comparable)Integer.valueOf(age));
    }
}

