/*
 * Decompiled with CFR 0.152.
 */
package com.blocklogic.agritech.compat.jei;

import com.blocklogic.agritech.block.ModBlocks;
import com.blocklogic.agritech.compat.jei.PlanterRecipe;
import com.blocklogic.agritech.compat.jei.PlanterRecipeCategory;
import com.blocklogic.agritech.config.AgritechCropConfig;
import com.blocklogic.agritech.util.RegistryHelper;
import com.mojang.logging.LogUtils;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import mezz.jei.api.IModPlugin;
import mezz.jei.api.JeiPlugin;
import mezz.jei.api.constants.VanillaTypes;
import mezz.jei.api.ingredients.IIngredientType;
import mezz.jei.api.recipe.RecipeType;
import mezz.jei.api.recipe.category.IRecipeCategory;
import mezz.jei.api.registration.IRecipeCatalystRegistration;
import mezz.jei.api.registration.IRecipeCategoryRegistration;
import mezz.jei.api.registration.IRecipeRegistration;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.block.Block;

@JeiPlugin
public class AgritechJeiPlugin
implements IModPlugin {
    private static final ResourceLocation PLUGIN_ID = ResourceLocation.fromNamespaceAndPath((String)"agritech", (String)"jei_plugin");

    public ResourceLocation getPluginUid() {
        return PLUGIN_ID;
    }

    public void registerCategories(IRecipeCategoryRegistration registration) {
        registration.addRecipeCategories(new IRecipeCategory[]{new PlanterRecipeCategory(registration.getJeiHelpers().getGuiHelper())});
    }

    public void registerRecipes(IRecipeRegistration registration) {
        List<PlanterRecipe> planterRecipes = this.generatePlanterRecipes();
        registration.addRecipes(PlanterRecipeCategory.PLANTER_RECIPE_RECIPE_TYPE, planterRecipes);
        for (PlanterRecipe recipe : planterRecipes) {
            for (ItemStack seed : recipe.getSeedIngredient().getItems()) {
                registration.addIngredientInfo((Object)seed, (IIngredientType)VanillaTypes.ITEM_STACK, new Component[]{Component.translatable((String)"jei.agritech.planter.tooltip")});
            }
        }
    }

    public void registerRecipeCatalysts(IRecipeCatalystRegistration registration) {
        registration.addRecipeCatalyst(new ItemStack((ItemLike)ModBlocks.AGRITECH_PLANTER_BLOCK.get()), new RecipeType[]{PlanterRecipeCategory.PLANTER_RECIPE_RECIPE_TYPE});
        registration.addRecipeCatalyst(new ItemStack((ItemLike)ModBlocks.AGRITECH_HOPPING_PLANTER_BLOCK.get()), new RecipeType[]{PlanterRecipeCategory.PLANTER_RECIPE_RECIPE_TYPE});
    }

    private List<PlanterRecipe> generatePlanterRecipes() {
        ArrayList<PlanterRecipe> recipes = new ArrayList<PlanterRecipe>();
        Map<String, List<String>> seedToSoilMap = AgritechCropConfig.getAllSeedToSoilMappings();
        for (Map.Entry<String, List<String>> entry : seedToSoilMap.entrySet()) {
            String seedId = entry.getKey();
            for (String soilId : entry.getValue()) {
                try {
                    Block soilBlock = RegistryHelper.getBlock(soilId);
                    if (soilBlock == null) {
                        LogUtils.getLogger().error("Invalid soil block in config: {} for seed {}", (Object)soilId, (Object)seedId);
                        continue;
                    }
                    PlanterRecipe recipe = PlanterRecipe.create(seedId, soilId);
                    if (recipe == null || recipe.getOutputs().isEmpty()) continue;
                    recipes.add(recipe);
                }
                catch (Exception e) {
                    LogUtils.getLogger().error("Error creating recipe for seed {} and soil {}: {}", new Object[]{seedId, soilId, e.getMessage(), e});
                }
            }
        }
        LogUtils.getLogger().info("Generated {} planter recipes for JEI", (Object)recipes.size());
        return recipes;
    }
}

