/*
 * Decompiled with CFR 0.152.
 */
package com.blocklogic.agritech.compat.jei;

import com.blocklogic.agritech.config.AgritechCropConfig;
import com.blocklogic.agritech.util.RegistryHelper;
import com.mojang.logging.LogUtils;
import java.util.ArrayList;
import java.util.List;
import mezz.jei.api.recipe.category.extensions.IRecipeCategoryExtension;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.Ingredient;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.block.Block;

public class PlanterRecipe
implements IRecipeCategoryExtension {
    private final Ingredient seedIngredient;
    private final Ingredient soilIngredient;
    private final List<ItemStack> outputs;

    public PlanterRecipe(Ingredient seedIngredient, Ingredient soilIngredient, List<ItemStack> outputs) {
        this.seedIngredient = seedIngredient;
        this.soilIngredient = soilIngredient;
        this.outputs = outputs;
    }

    public Ingredient getSeedIngredient() {
        return this.seedIngredient;
    }

    public Ingredient getSoilIngredient() {
        return this.soilIngredient;
    }

    public List<ItemStack> getOutputs() {
        return this.outputs;
    }

    public static PlanterRecipe create(String seedId, String soilId) {
        Item seedItem = RegistryHelper.getItem(seedId);
        if (seedItem == null) {
            LogUtils.getLogger().error("Failed to create planter recipe: Seed item not found for ID: {}", (Object)seedId);
            throw new IllegalArgumentException("Seed item not found for ID: " + seedId);
        }
        Block soilBlock = RegistryHelper.getBlock(soilId);
        if (soilBlock == null) {
            LogUtils.getLogger().error("Failed to create planter recipe: Soil block not found for ID: {}", (Object)soilId);
            throw new IllegalArgumentException("Soil block not found for ID: " + soilId);
        }
        Ingredient seedIngredient = Ingredient.of((ItemLike[])new ItemLike[]{seedItem});
        Ingredient soilIngredient = Ingredient.of((ItemLike[])new ItemLike[]{soilBlock.asItem()});
        ArrayList<ItemStack> outputs = new ArrayList<ItemStack>();
        List<AgritechCropConfig.DropInfo> drops = AgritechCropConfig.getCropDrops(seedId);
        for (AgritechCropConfig.DropInfo dropInfo : drops) {
            if (!(dropInfo.chance > 0.0f)) continue;
            Item dropItem = RegistryHelper.getItem(dropInfo.item);
            if (dropItem != null) {
                ItemStack outputStack = new ItemStack((ItemLike)dropItem, (dropInfo.minCount + dropInfo.maxCount) / 2);
                outputs.add(outputStack);
                continue;
            }
            LogUtils.getLogger().error("Drop item not found for ID: {} in recipe for seed {}", (Object)dropInfo.item, (Object)seedId);
            throw new IllegalArgumentException("Drop item not found for ID: " + dropInfo.item + " in recipe for seed " + seedId);
        }
        return new PlanterRecipe(seedIngredient, soilIngredient, outputs);
    }
}

