/*
 * Decompiled with CFR 0.152.
 */
package com.blocklogic.agritech.compat.jei;

import com.blocklogic.agritech.block.ModBlocks;
import com.blocklogic.agritech.compat.jei.PlanterRecipe;
import java.util.List;
import mezz.jei.api.constants.VanillaTypes;
import mezz.jei.api.gui.builder.IRecipeLayoutBuilder;
import mezz.jei.api.gui.drawable.IDrawable;
import mezz.jei.api.gui.ingredient.IRecipeSlotsView;
import mezz.jei.api.helpers.IGuiHelper;
import mezz.jei.api.ingredients.IIngredientType;
import mezz.jei.api.recipe.IFocusGroup;
import mezz.jei.api.recipe.RecipeIngredientRole;
import mezz.jei.api.recipe.RecipeType;
import mezz.jei.api.recipe.category.IRecipeCategory;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.ItemLike;

public class PlanterRecipeCategory
implements IRecipeCategory<PlanterRecipe> {
    public static final ResourceLocation UID = ResourceLocation.fromNamespaceAndPath((String)"agritech", (String)"planter");
    public static final ResourceLocation TEXTURE = ResourceLocation.fromNamespaceAndPath((String)"agritech", (String)"textures/gui/jei/planter.png");
    public static final RecipeType<PlanterRecipe> PLANTER_RECIPE_RECIPE_TYPE = new RecipeType(UID, PlanterRecipe.class);
    private final IDrawable background;
    private final IDrawable icon;

    public int getWidth() {
        return 116;
    }

    public int getHeight() {
        return 54;
    }

    public PlanterRecipeCategory(IGuiHelper guiHelper) {
        this.background = guiHelper.createDrawable(TEXTURE, 0, 0, 116, 54);
        if (this.background == null) {
            // empty if block
        }
        this.icon = guiHelper.createDrawableIngredient((IIngredientType)VanillaTypes.ITEM_STACK, (Object)new ItemStack((ItemLike)ModBlocks.AGRITECH_HOPPING_PLANTER_BLOCK.get()));
    }

    public RecipeType<PlanterRecipe> getRecipeType() {
        return PLANTER_RECIPE_RECIPE_TYPE;
    }

    public Component getTitle() {
        return Component.translatable((String)"jei.agritech.planter.tooltip");
    }

    public IDrawable getIcon() {
        return this.icon;
    }

    public void setRecipe(IRecipeLayoutBuilder builder, PlanterRecipe recipe, IFocusGroup focuses) {
        builder.addSlot(RecipeIngredientRole.INPUT, 10, 10).addIngredients((IIngredientType)VanillaTypes.ITEM_STACK, List.of(recipe.getSeedIngredient().getItems()));
        builder.addSlot(RecipeIngredientRole.INPUT, 10, 28).addIngredients(recipe.getSoilIngredient());
        int outputIndex = 0;
        for (ItemStack output : recipe.getOutputs()) {
            int x = 54 + outputIndex % 3 * 18;
            int y = 10 + outputIndex / 3 * 18;
            builder.addSlot(RecipeIngredientRole.OUTPUT, x, y).addItemStack(output);
            ++outputIndex;
        }
    }

    public void draw(PlanterRecipe recipe, IRecipeSlotsView recipeSlotsView, GuiGraphics guiGraphics, double mouseX, double mouseY) {
        super.draw((Object)recipe, recipeSlotsView, guiGraphics, mouseX, mouseY);
        this.background.draw(guiGraphics);
    }
}

