/*
 * Decompiled with CFR 0.152.
 */
package com.Mateitaa1.gravelootz;

import com.Mateitaa1.gravelootz.GravesCommand;
import java.io.File;
import java.io.IOException;
import java.lang.invoke.CallSite;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.UUID;
import java.util.concurrent.TimeUnit;
import org.bukkit.Bukkit;
import org.bukkit.ChatColor;
import org.bukkit.Location;
import org.bukkit.Material;
import org.bukkit.OfflinePlayer;
import org.bukkit.World;
import org.bukkit.block.Block;
import org.bukkit.block.Chest;
import org.bukkit.command.CommandExecutor;
import org.bukkit.configuration.file.FileConfiguration;
import org.bukkit.configuration.file.YamlConfiguration;
import org.bukkit.entity.ArmorStand;
import org.bukkit.entity.Entity;
import org.bukkit.entity.EntityType;
import org.bukkit.entity.Player;
import org.bukkit.event.EventHandler;
import org.bukkit.event.Listener;
import org.bukkit.event.entity.PlayerDeathEvent;
import org.bukkit.event.player.PlayerInteractEvent;
import org.bukkit.event.player.PlayerJoinEvent;
import org.bukkit.event.player.PlayerQuitEvent;
import org.bukkit.inventory.Inventory;
import org.bukkit.inventory.ItemStack;
import org.bukkit.inventory.meta.ItemMeta;
import org.bukkit.plugin.Plugin;
import org.bukkit.plugin.RegisteredServiceProvider;
import org.bukkit.plugin.java.JavaPlugin;

public class GraveLootZ
extends JavaPlugin
implements Listener {
    private Map<Location, UUID> graves = new HashMap<Location, UUID>();
    private Map<Location, Long> graveTimes = new HashMap<Location, Long>();
    private Map<Location, Long> graveOfflineTime = new HashMap<Location, Long>();
    private Map<Location, String> graveMessages = new HashMap<Location, String>();
    private Map<Location, ArmorStand> graveHolograms = new HashMap<Location, ArmorStand>();
    private Map<UUID, List<Location>> playerGraves = new HashMap<UUID, List<Location>>();
    private Set<UUID> onlinePlayers = new HashSet<UUID>();
    private boolean usePermissions;
    private boolean protectGraves;
    private boolean showDeathMessages;
    private boolean showGraveLocations;
    private boolean sendCompassOnDeath;
    private int expirationTime;
    private boolean dropItemsOnExpire;
    private String graveMessage;
    private boolean pauseTimerOffline;
    private boolean enableEconomy;
    private double teleportCost;
    private int publicAccessTime;
    private boolean enableHolograms;
    private Object economy = null;
    private File dataFile;
    private FileConfiguration dataConfig;

    public void onEnable() {
        this.saveDefaultConfig();
        this.loadConfig();
        this.setupDataFile();
        if (this.enableEconomy) {
            this.setupEconomy();
        }
        this.loadGraveData();
        Bukkit.getPluginManager().registerEvents((Listener)this, (Plugin)this);
        this.getCommand("graves").setExecutor((CommandExecutor)new GravesCommand(this));
        Bukkit.getScheduler().runTaskTimer((Plugin)this, this::checkGraves, 1200L, 1200L);
        if (this.enableHolograms) {
            Bukkit.getScheduler().runTaskTimer((Plugin)this, this::updateHolograms, 200L, 200L);
        }
        for (Player player : Bukkit.getOnlinePlayers()) {
            this.onlinePlayers.add(player.getUniqueId());
        }
        this.getLogger().info("GraveLootZ has been enabled!");
        if (this.economy != null) {
            this.getLogger().info("Economy support enabled with Vault!");
        } else if (this.enableEconomy) {
            this.getLogger().warning("Economy enabled in config but Vault not found!");
        }
    }

    public void onDisable() {
        for (ArmorStand hologram : this.graveHolograms.values()) {
            if (hologram == null || hologram.isDead()) continue;
            hologram.remove();
        }
        this.graveHolograms.clear();
        this.saveGraveData();
        this.getLogger().info("GraveLootZ has been disabled!");
    }

    private void setupEconomy() {
        if (!this.enableEconomy) {
            return;
        }
        if (this.getServer().getPluginManager().getPlugin("Vault") == null) {
            this.getLogger().warning("Economy enabled but Vault plugin not found! Economy features disabled.");
            this.enableEconomy = false;
            return;
        }
        try {
            Class<?> economyClass = Class.forName("net.milkbowl.vault.economy.Economy");
            RegisteredServiceProvider rsp = this.getServer().getServicesManager().getRegistration(economyClass);
            if (rsp == null) {
                this.getLogger().warning("Economy enabled but no economy plugin found! Economy features disabled.");
                this.enableEconomy = false;
                return;
            }
            this.economy = rsp.getProvider();
        }
        catch (ClassNotFoundException e) {
            this.getLogger().warning("Economy enabled but Vault classes not found! Economy features disabled.");
            this.enableEconomy = false;
            this.economy = null;
        }
    }

    private void setupDataFile() {
        this.dataFile = new File(this.getDataFolder(), "graves.yml");
        if (!this.dataFile.exists()) {
            try {
                this.dataFile.createNewFile();
            }
            catch (IOException e) {
                this.getLogger().severe("Could not create graves.yml file!");
            }
        }
        this.dataConfig = YamlConfiguration.loadConfiguration((File)this.dataFile);
    }

    private void saveGraveData() {
        try {
            this.dataConfig.set("graves", null);
            for (Map.Entry<Location, UUID> entry : this.graves.entrySet()) {
                Location loc = entry.getKey();
                UUID playerUUID = entry.getValue();
                String path = "graves." + this.locationToString(loc);
                this.dataConfig.set(path + ".owner", (Object)playerUUID.toString());
                this.dataConfig.set(path + ".createTime", (Object)this.graveTimes.get(loc));
                this.dataConfig.set(path + ".offlineTime", (Object)this.graveOfflineTime.getOrDefault(loc, 0L));
                this.dataConfig.set(path + ".message", (Object)this.graveMessages.get(loc));
                this.dataConfig.set(path + ".world", (Object)loc.getWorld().getName());
                this.dataConfig.set(path + ".x", (Object)loc.getBlockX());
                this.dataConfig.set(path + ".y", (Object)loc.getBlockY());
                this.dataConfig.set(path + ".z", (Object)loc.getBlockZ());
            }
            this.dataConfig.save(this.dataFile);
        }
        catch (IOException e) {
            this.getLogger().severe("Could not save grave data: " + e.getMessage());
        }
    }

    private void loadGraveData() {
        if (!this.dataConfig.contains("graves")) {
            return;
        }
        Set graveKeys = this.dataConfig.getConfigurationSection("graves").getKeys(false);
        for (String key : graveKeys) {
            String path = "graves." + key;
            try {
                int z;
                int y;
                int x;
                Location loc;
                String worldName = this.dataConfig.getString(path + ".world");
                World world = Bukkit.getWorld((String)worldName);
                if (world == null || (loc = new Location(world, (double)(x = this.dataConfig.getInt(path + ".x")), (double)(y = this.dataConfig.getInt(path + ".y")), (double)(z = this.dataConfig.getInt(path + ".z")))).getBlock().getType() != Material.CHEST) continue;
                UUID ownerUUID = UUID.fromString(this.dataConfig.getString(path + ".owner"));
                long createTime = this.dataConfig.getLong(path + ".createTime");
                long offlineTime = this.dataConfig.getLong(path + ".offlineTime", 0L);
                String message = this.dataConfig.getString(path + ".message");
                this.graves.put(loc, ownerUUID);
                this.graveTimes.put(loc, createTime);
                this.graveOfflineTime.put(loc, offlineTime);
                this.graveMessages.put(loc, message);
                this.playerGraves.putIfAbsent(ownerUUID, new ArrayList());
                this.playerGraves.get(ownerUUID).add(loc);
            }
            catch (Exception e) {
                this.getLogger().warning("Failed to load grave: " + key + " - " + e.getMessage());
            }
        }
        this.getLogger().info("Loaded " + this.graves.size() + " graves from data file.");
        if (this.enableHolograms) {
            Bukkit.getScheduler().runTaskLater((Plugin)this, () -> {
                int hologramsCreated = 0;
                for (Map.Entry<Location, UUID> entry : this.graves.entrySet()) {
                    Location graveLoc = entry.getKey();
                    UUID ownerUUID = entry.getValue();
                    if (this.graveHolograms.containsKey(graveLoc)) continue;
                    String ownerName = Bukkit.getOfflinePlayer((UUID)ownerUUID).getName();
                    if (ownerName == null) {
                        ownerName = "Unknown";
                    }
                    String message = this.graveMessages.getOrDefault(graveLoc, this.graveMessage.replace("%player%", ownerName));
                    this.createHologram(graveLoc, message, ownerName);
                    ++hologramsCreated;
                }
                if (hologramsCreated > 0) {
                    this.getLogger().info("Created " + hologramsCreated + " holograms for loaded graves.");
                }
            }, 20L);
        }
    }

    private String locationToString(Location loc) {
        return loc.getWorld().getName() + "_" + loc.getBlockX() + "_" + loc.getBlockY() + "_" + loc.getBlockZ();
    }

    private void loadConfig() {
        this.usePermissions = this.getConfig().getBoolean("use-permissions", false);
        this.protectGraves = this.getConfig().getBoolean("protect-graves", true);
        this.showDeathMessages = this.getConfig().getBoolean("show-death-messages", true);
        this.showGraveLocations = this.getConfig().getBoolean("show-grave-locations", true);
        this.sendCompassOnDeath = this.getConfig().getBoolean("send-compass-on-death", true);
        this.expirationTime = this.getConfig().getInt("grave-expiration-time", 30);
        this.dropItemsOnExpire = this.getConfig().getBoolean("drop-items-on-expire", true);
        this.graveMessage = ChatColor.translateAlternateColorCodes((char)'&', (String)this.getConfig().getString("grave-message", "&8[&6%player%'s Grave&8]"));
        this.pauseTimerOffline = this.getConfig().getBoolean("pause-timer-when-offline", true);
        this.enableEconomy = this.getConfig().getBoolean("economy.enabled", false);
        this.teleportCost = this.getConfig().getDouble("economy.teleport-cost", 10.0);
        this.publicAccessTime = this.getConfig().getInt("public-access-time", 60);
        this.enableHolograms = this.getConfig().getBoolean("holograms.enabled", true);
    }

    @EventHandler
    public void onPlayerJoin(PlayerJoinEvent event) {
        this.onlinePlayers.add(event.getPlayer().getUniqueId());
        if (this.pauseTimerOffline) {
            UUID playerUUID = event.getPlayer().getUniqueId();
            long currentTime = System.currentTimeMillis();
            for (Location graveLoc : this.graves.keySet()) {
                long offlineTime;
                if (!this.graves.get(graveLoc).equals(playerUUID) || (offlineTime = this.graveOfflineTime.getOrDefault(graveLoc, 0L).longValue()) <= 0L) continue;
                long pausedDuration = currentTime - offlineTime;
                this.graveTimes.put(graveLoc, this.graveTimes.get(graveLoc) + pausedDuration);
                this.graveOfflineTime.remove(graveLoc);
            }
        }
    }

    @EventHandler
    public void onPlayerQuit(PlayerQuitEvent event) {
        this.onlinePlayers.remove(event.getPlayer().getUniqueId());
        if (this.pauseTimerOffline) {
            UUID playerUUID = event.getPlayer().getUniqueId();
            long currentTime = System.currentTimeMillis();
            for (Location graveLoc : this.graves.keySet()) {
                if (!this.graves.get(graveLoc).equals(playerUUID)) continue;
                this.graveOfflineTime.put(graveLoc, currentTime);
            }
        }
    }

    @EventHandler
    public void onPlayerDeath(PlayerDeathEvent event) {
        Player player = event.getEntity();
        if (this.usePermissions && !player.hasPermission("gravelootz.use")) {
            return;
        }
        List disabledWorlds = this.getConfig().getStringList("disabled-worlds");
        if (disabledWorlds.contains(player.getWorld().getName())) {
            return;
        }
        if (!this.isInventoryEmpty(player)) {
            this.createGrave(player, event);
            event.setKeepInventory(false);
        }
    }

    private boolean isInventoryEmpty(Player player) {
        for (ItemStack item : player.getInventory().getContents()) {
            if (item == null || item.getType() == Material.AIR) continue;
            return false;
        }
        for (ItemStack armor : player.getInventory().getArmorContents()) {
            if (armor == null || armor.getType() == Material.AIR) continue;
            return false;
        }
        ItemStack offhand = player.getInventory().getItemInOffHand();
        return offhand == null || offhand.getType() == Material.AIR;
    }

    private void createGrave(Player player, PlayerDeathEvent event) {
        Location deathLoc = player.getLocation();
        Location graveLoc = this.findSuitableLocation(deathLoc);
        if (graveLoc == null) {
            player.sendMessage(String.valueOf(ChatColor.RED) + "Failed to create a grave! Your items dropped normally.");
            return;
        }
        ArrayList<ItemStack> allItems = new ArrayList<ItemStack>();
        for (ItemStack drop : event.getDrops()) {
            if (drop == null || drop.getType() == Material.AIR) continue;
            allItems.add(drop.clone());
        }
        event.getDrops().clear();
        if (allItems.isEmpty()) {
            return;
        }
        Block primaryBlock = graveLoc.getBlock();
        primaryBlock.setType(Material.CHEST);
        Chest primaryChest = (Chest)primaryBlock.getState();
        Inventory primaryInv = primaryChest.getInventory();
        ArrayList remainingItems = new ArrayList();
        for (ItemStack item : allItems) {
            HashMap leftover = primaryInv.addItem(new ItemStack[]{item});
            if (leftover.isEmpty()) continue;
            remainingItems.addAll(leftover.values());
        }
        Location secondaryLoc = null;
        if (!remainingItems.isEmpty()) {
            secondaryLoc = graveLoc.clone().add(0.0, 1.0, 0.0);
            Block secondaryBlock = secondaryLoc.getBlock();
            if (secondaryBlock.getType() == Material.AIR || secondaryBlock.getType() == Material.GRASS_BLOCK || secondaryBlock.getType() == Material.DIRT || secondaryBlock.getType() == Material.SAND || secondaryBlock.getType() == Material.GRAVEL) {
                secondaryBlock.setType(Material.CHEST);
                Chest secondaryChest = (Chest)secondaryBlock.getState();
                Inventory secondaryInv = secondaryChest.getInventory();
                ArrayList overflowItems = new ArrayList();
                for (ItemStack item : remainingItems) {
                    HashMap leftover = secondaryInv.addItem(new ItemStack[]{item});
                    if (leftover.isEmpty()) continue;
                    overflowItems.addAll(leftover.values());
                }
                if (!overflowItems.isEmpty()) {
                    player.sendMessage(String.valueOf(ChatColor.YELLOW) + "Some items couldn't fit in the graves and were dropped nearby!");
                    for (ItemStack overflow : overflowItems) {
                        graveLoc.getWorld().dropItemNaturally(graveLoc.clone().add(0.0, 2.0, 0.0), overflow);
                    }
                }
            } else {
                player.sendMessage(String.valueOf(ChatColor.YELLOW) + "Could not create second chest. Some items were dropped nearby!");
                for (ItemStack remaining : remainingItems) {
                    graveLoc.getWorld().dropItemNaturally(graveLoc.clone().add(0.0, 1.0, 0.0), remaining);
                }
                secondaryLoc = null;
            }
        }
        String playerName = player.getName();
        UUID playerUUID = player.getUniqueId();
        this.graves.put(graveLoc, playerUUID);
        this.graveTimes.put(graveLoc, System.currentTimeMillis());
        if (secondaryLoc != null) {
            this.graves.put(secondaryLoc, playerUUID);
            this.graveTimes.put(secondaryLoc, System.currentTimeMillis());
        }
        String formattedMessage = this.graveMessage.replace("%player%", playerName);
        this.graveMessages.put(graveLoc, formattedMessage);
        if (secondaryLoc != null) {
            this.graveMessages.put(secondaryLoc, formattedMessage);
        }
        this.playerGraves.putIfAbsent(playerUUID, new ArrayList());
        this.playerGraves.get(playerUUID).add(graveLoc);
        if (this.enableHolograms) {
            Location hologramLoc = secondaryLoc != null ? secondaryLoc : graveLoc;
            String chestInfo = secondaryLoc != null ? " (2 Chests)" : "";
            this.createHologram(hologramLoc, formattedMessage + chestInfo, playerName);
        } else {
            this.removeHologramForLocation(graveLoc);
            if (secondaryLoc != null) {
                this.removeHologramForLocation(secondaryLoc);
            }
        }
        if (this.showDeathMessages) {
            String chestInfo = secondaryLoc != null ? " across 2 chests" : " in a chest";
            player.sendMessage(String.valueOf(ChatColor.GOLD) + "Your items have been stored" + chestInfo + "!");
            player.sendMessage(String.valueOf(ChatColor.GRAY) + "Items stored: " + allItems.size());
            if (this.showGraveLocations) {
                player.sendMessage(String.valueOf(ChatColor.YELLOW) + "Grave location: " + String.valueOf(ChatColor.WHITE) + "X: " + graveLoc.getBlockX() + ", Y: " + graveLoc.getBlockY() + ", Z: " + graveLoc.getBlockZ());
            }
            if (this.expirationTime > 0) {
                String timerMessage = this.pauseTimerOffline ? " (timer pauses when you're offline)" : "";
                player.sendMessage(String.valueOf(ChatColor.YELLOW) + "Your grave will expire in " + String.valueOf(ChatColor.WHITE) + this.expirationTime + String.valueOf(ChatColor.YELLOW) + " minutes." + timerMessage);
            }
        }
        if (this.sendCompassOnDeath) {
            ItemStack compass = new ItemStack(Material.COMPASS);
            ItemMeta meta = compass.getItemMeta();
            meta.setDisplayName(String.valueOf(ChatColor.GOLD) + "Grave Finder");
            ArrayList<CallSite> lore = new ArrayList<CallSite>();
            lore.add((CallSite)((Object)(String.valueOf(ChatColor.GRAY) + "Points to your most recent grave")));
            lore.add((CallSite)((Object)(String.valueOf(ChatColor.YELLOW) + "X: " + graveLoc.getBlockX() + ", Y: " + graveLoc.getBlockY() + ", Z: " + graveLoc.getBlockZ())));
            if (secondaryLoc != null) {
                lore.add((CallSite)((Object)(String.valueOf(ChatColor.AQUA) + "Two-Chest Grave")));
            }
            meta.setLore(lore);
            compass.setItemMeta(meta);
            Bukkit.getScheduler().runTaskLater((Plugin)this, () -> {
                if (player.isOnline()) {
                    player.getInventory().addItem(new ItemStack[]{compass});
                }
            }, 1L);
        }
        this.saveGraveData();
    }

    private Location findSuitableLocation(Location deathLoc) {
        if (this.canPlaceChest(deathLoc)) {
            return deathLoc;
        }
        int radius = 5;
        for (int r = 1; r <= radius; ++r) {
            for (int x = -r; x <= r; ++x) {
                for (int z = -r; z <= r; ++z) {
                    if (Math.abs(x) != r && Math.abs(z) != r) continue;
                    for (int y = -r; y <= r; ++y) {
                        Location checkLoc = deathLoc.clone().add((double)x, (double)y, (double)z);
                        if (!this.canPlaceChest(checkLoc)) continue;
                        return checkLoc;
                    }
                }
            }
        }
        return null;
    }

    private boolean canPlaceChest(Location loc) {
        Block block = loc.getBlock();
        return block.getType() == Material.AIR || block.getType() == Material.GRASS_BLOCK || block.getType() == Material.DIRT || block.getType() == Material.SAND || block.getType() == Material.GRAVEL;
    }

    @EventHandler
    public void onChestInteract(PlayerInteractEvent event) {
        long ageMinutes;
        long currentTime;
        long createTime;
        if (!event.hasBlock() || event.getClickedBlock().getType() != Material.CHEST) {
            return;
        }
        Location chestLoc = event.getClickedBlock().getLocation();
        if (!this.graves.containsKey(chestLoc)) {
            return;
        }
        Player player = event.getPlayer();
        UUID ownerUUID = this.graves.get(chestLoc);
        boolean isPublicAccess = false;
        if (this.publicAccessTime > 0 && this.graveTimes.containsKey(chestLoc)) {
            createTime = this.graveTimes.get(chestLoc);
            currentTime = System.currentTimeMillis();
            ageMinutes = TimeUnit.MILLISECONDS.toMinutes(currentTime - createTime);
            if (ageMinutes >= (long)this.publicAccessTime) {
                isPublicAccess = true;
            }
        }
        if (this.protectGraves && !player.getUniqueId().equals(ownerUUID) && !player.hasPermission("gravelootz.admin") && !isPublicAccess) {
            event.setCancelled(true);
            if (this.publicAccessTime > 0) {
                createTime = this.graveTimes.get(chestLoc);
                currentTime = System.currentTimeMillis();
                ageMinutes = TimeUnit.MILLISECONDS.toMinutes(currentTime - createTime);
                long timeUntilPublic = (long)this.publicAccessTime - ageMinutes;
                if (timeUntilPublic > 0L) {
                    String ownerName = this.getServer().getOfflinePlayer(ownerUUID).getName();
                    player.sendMessage(String.valueOf(ChatColor.RED) + "This grave belongs to " + ownerName + "!");
                    player.sendMessage(String.valueOf(ChatColor.YELLOW) + "It will become public in " + timeUntilPublic + " minutes.");
                } else {
                    player.sendMessage(String.valueOf(ChatColor.RED) + "This grave doesn't belong to you!");
                }
            } else {
                player.sendMessage(String.valueOf(ChatColor.RED) + "This grave doesn't belong to you!");
            }
            return;
        }
        if (isPublicAccess && !player.getUniqueId().equals(ownerUUID)) {
            String ownerName = this.getServer().getOfflinePlayer(ownerUUID).getName();
            player.sendMessage(String.valueOf(ChatColor.AQUA) + "Accessing " + ownerName + "'s public grave.");
        }
        if (player.getUniqueId().equals(ownerUUID)) {
            Bukkit.getScheduler().runTaskLater((Plugin)this, () -> this.checkGraveEmpty(chestLoc, player), 1L);
        }
    }

    private void checkGraves() {
        if (this.expirationTime <= 0) {
            return;
        }
        long currentTime = System.currentTimeMillis();
        ArrayList<Location> expiredGraves = new ArrayList<Location>();
        for (Map.Entry<Location, Long> entry : this.graveTimes.entrySet()) {
            long ageMinutes;
            long effectiveAge;
            Location graveLoc = entry.getKey();
            long createTime = entry.getValue();
            UUID ownerUUID = this.graves.get(graveLoc);
            if (ownerUUID == null) continue;
            if (this.pauseTimerOffline && !this.onlinePlayers.contains(ownerUUID)) {
                effectiveAge = this.graveOfflineTime.getOrDefault(graveLoc, 0L);
            } else {
                long offlineAccumulated = this.graveOfflineTime.getOrDefault(graveLoc, 0L);
                effectiveAge = currentTime - createTime - offlineAccumulated;
                this.graveOfflineTime.put(graveLoc, offlineAccumulated);
            }
            if ((ageMinutes = TimeUnit.MILLISECONDS.toMinutes(effectiveAge)) < (long)this.expirationTime) continue;
            expiredGraves.add(graveLoc);
            Player owner = Bukkit.getPlayer((UUID)ownerUUID);
            if (owner == null || !owner.isOnline()) continue;
            owner.sendMessage(String.valueOf(ChatColor.RED) + "One of your graves has expired!");
        }
        for (Location graveLoc : expiredGraves) {
            this.removeGrave(graveLoc, this.dropItemsOnExpire);
        }
        if (!expiredGraves.isEmpty()) {
            this.saveGraveData();
        }
    }

    private void removeGrave(Location graveLoc, boolean dropItems) {
        Block block = graveLoc.getBlock();
        if (block.getType() == Material.CHEST) {
            Chest chest = (Chest)block.getState();
            Inventory inv = chest.getInventory();
            if (dropItems) {
                for (ItemStack item : inv.getContents()) {
                    if (item == null || item.getType() == Material.AIR) continue;
                    graveLoc.getWorld().dropItemNaturally(graveLoc, item);
                }
            }
            inv.clear();
            block.setType(Material.AIR);
        }
        this.removeHologramForLocation(graveLoc);
        UUID playerUUID = this.graves.get(graveLoc);
        this.graves.remove(graveLoc);
        this.graveTimes.remove(graveLoc);
        this.graveOfflineTime.remove(graveLoc);
        this.graveMessages.remove(graveLoc);
        if (playerUUID != null && this.playerGraves.containsKey(playerUUID)) {
            this.playerGraves.get(playerUUID).remove(graveLoc);
            if (this.playerGraves.get(playerUUID).isEmpty()) {
                this.playerGraves.remove(playerUUID);
            }
        }
    }

    private void createHologram(Location graveLoc, String message, String playerName) {
        if (!this.enableHolograms) {
            return;
        }
        this.removeHologramForLocation(graveLoc);
        Location hologramLoc = graveLoc.clone().add(0.5, 1.5, 0.5);
        ArmorStand hologram = (ArmorStand)graveLoc.getWorld().spawnEntity(hologramLoc, EntityType.ARMOR_STAND);
        hologram.setVisible(false);
        hologram.setGravity(false);
        hologram.setCanPickupItems(false);
        hologram.setCustomNameVisible(true);
        hologram.setCustomName(message);
        hologram.setMarker(true);
        hologram.setInvulnerable(true);
        hologram.setPersistent(false);
        hologram.setBasePlate(false);
        hologram.setArms(false);
        hologram.setCollidable(false);
        this.graveHolograms.put(graveLoc, hologram);
    }

    private void updateHolograms() {
        if (!this.enableHolograms) {
            return;
        }
        long currentTime = System.currentTimeMillis();
        ArrayList<Location> hologramsToRemove = new ArrayList<Location>();
        for (Map.Entry<Location, ArmorStand> entry : this.graveHolograms.entrySet()) {
            long effectiveAge;
            Location graveLoc = entry.getKey();
            ArmorStand hologram = entry.getValue();
            if (hologram == null || hologram.isDead() || !this.graves.containsKey(graveLoc)) {
                hologramsToRemove.add(graveLoc);
                if (hologram == null || hologram.isDead()) continue;
                hologram.remove();
                continue;
            }
            Block block = graveLoc.getBlock();
            if (block.getType() != Material.CHEST) {
                hologramsToRemove.add(graveLoc);
                hologram.remove();
                this.removeGraveDataOnly(graveLoc);
                continue;
            }
            if (!this.graveTimes.containsKey(graveLoc)) continue;
            UUID ownerUUID = this.graves.get(graveLoc);
            String ownerName = this.getServer().getOfflinePlayer(ownerUUID).getName();
            String baseMessage = this.graveMessage.replace("%player%", ownerName);
            Object timeInfo = "";
            long createTime = this.graveTimes.get(graveLoc);
            long offlineAccumulated = this.graveOfflineTime.getOrDefault(graveLoc, 0L);
            boolean isPaused = false;
            if (this.pauseTimerOffline && !this.onlinePlayers.contains(ownerUUID)) {
                effectiveAge = offlineAccumulated;
                isPaused = true;
            } else {
                effectiveAge = currentTime - createTime - offlineAccumulated;
            }
            long ageMinutes = TimeUnit.MILLISECONDS.toMinutes(effectiveAge);
            int expirationTime = this.getConfig().getInt("grave-expiration-time", 30);
            if (expirationTime > 0) {
                long remainingMinutes = (long)expirationTime - ageMinutes;
                if (remainingMinutes > 0L) {
                    timeInfo = String.valueOf(ChatColor.GREEN) + " [" + remainingMinutes + "m]";
                    if (isPaused) {
                        timeInfo = (String)timeInfo + String.valueOf(ChatColor.BLUE) + " (Paused)";
                    }
                } else {
                    timeInfo = String.valueOf(ChatColor.RED) + " [EXPIRED]";
                }
            }
            if (this.publicAccessTime > 0) {
                long timeUntilPublic = (long)this.publicAccessTime - ageMinutes;
                if (timeUntilPublic <= 0L) {
                    timeInfo = (String)timeInfo + String.valueOf(ChatColor.AQUA) + " [PUBLIC]";
                } else if (timeUntilPublic <= 10L) {
                    timeInfo = (String)timeInfo + String.valueOf(ChatColor.YELLOW) + " [" + timeUntilPublic + "m to public]";
                }
            }
            hologram.setCustomName(baseMessage + (String)timeInfo);
        }
        for (Location loc : hologramsToRemove) {
            this.graveHolograms.remove(loc);
        }
    }

    private void removeGraveDataOnly(Location graveLoc) {
        UUID playerUUID = this.graves.get(graveLoc);
        this.graves.remove(graveLoc);
        this.graveTimes.remove(graveLoc);
        this.graveOfflineTime.remove(graveLoc);
        this.graveMessages.remove(graveLoc);
        if (playerUUID != null && this.playerGraves.containsKey(playerUUID)) {
            this.playerGraves.get(playerUUID).remove(graveLoc);
            if (this.playerGraves.get(playerUUID).isEmpty()) {
                this.playerGraves.remove(playerUUID);
            }
        }
    }

    private void checkGraveEmpty(Location chestLoc, Player player) {
        Block block = chestLoc.getBlock();
        if (block.getType() != Material.CHEST) {
            if (this.graves.containsKey(chestLoc)) {
                this.removeHologramForLocation(chestLoc);
                this.removeGraveDataOnly(chestLoc);
                this.saveGraveData();
            }
            return;
        }
        UUID graveOwner = this.graves.get(chestLoc);
        if (graveOwner == null || !graveOwner.equals(player.getUniqueId())) {
            return;
        }
        this.removeHologramForLocation(chestLoc);
        Chest chest = (Chest)block.getState();
        boolean isEmpty = true;
        for (ItemStack item : chest.getInventory().getContents()) {
            if (item == null || item.getType() == Material.AIR) continue;
            isEmpty = false;
            break;
        }
        if (isEmpty) {
            boolean hasOtherChest = false;
            ArrayList<Location> emptyChestsToRemove = new ArrayList<Location>();
            emptyChestsToRemove.add(chestLoc);
            for (Location otherLoc : this.graves.keySet()) {
                Block otherBlock;
                if (otherLoc.equals((Object)chestLoc) || !this.graves.get(otherLoc).equals(graveOwner) || !(chestLoc.distance(otherLoc) <= 2.0) || (otherBlock = otherLoc.getBlock()).getType() != Material.CHEST) continue;
                Chest otherChest = (Chest)otherBlock.getState();
                boolean otherEmpty = true;
                for (ItemStack item : otherChest.getInventory().getContents()) {
                    if (item == null || item.getType() == Material.AIR) continue;
                    otherEmpty = false;
                    break;
                }
                if (!otherEmpty) {
                    hasOtherChest = true;
                    break;
                }
                emptyChestsToRemove.add(otherLoc);
            }
            for (Location emptyLoc : emptyChestsToRemove) {
                this.removeGrave(emptyLoc, false);
            }
            if (!hasOtherChest) {
                player.sendMessage(String.valueOf(ChatColor.GREEN) + "Empty grave collected! The chest(s) have been removed.");
            }
            this.saveGraveData();
        }
    }

    private void removeHologramForLocation(Location loc) {
        ArmorStand hologram = this.graveHolograms.get(loc);
        if (hologram != null && !hologram.isDead()) {
            hologram.remove();
        }
        this.graveHolograms.remove(loc);
    }

    private boolean removeAllHologramsForPlayer(UUID playerUUID, Location nearLocation) {
        boolean removed = false;
        ArrayList<Location> toRemove = new ArrayList<Location>();
        for (Map.Entry<Location, ArmorStand> entry : this.graveHolograms.entrySet()) {
            Location hologramLoc = entry.getKey();
            ArmorStand hologram = entry.getValue();
            if (!this.graves.containsKey(hologramLoc) || !this.graves.get(hologramLoc).equals(playerUUID) || !nearLocation.getWorld().equals((Object)hologramLoc.getWorld()) || !(nearLocation.distance(hologramLoc) <= 5.0)) continue;
            if (hologram != null && !hologram.isDead()) {
                hologram.remove();
                removed = true;
            }
            toRemove.add(hologramLoc);
        }
        for (Location loc : toRemove) {
            this.graveHolograms.remove(loc);
        }
        for (Entity entity : nearLocation.getWorld().getNearbyEntities(nearLocation, 5.0, 5.0, 5.0)) {
            String playerName;
            ArmorStand armorStand;
            if (!(entity instanceof ArmorStand) || (armorStand = (ArmorStand)entity).isVisible() || armorStand.hasGravity() || !armorStand.isMarker() || !armorStand.isCustomNameVisible() || armorStand.getCustomName() == null || (playerName = Bukkit.getOfflinePlayer((UUID)playerUUID).getName()) == null || !armorStand.getCustomName().contains(playerName)) continue;
            armorStand.remove();
            removed = true;
        }
        return removed;
    }

    public void reloadPluginConfig() {
        this.reloadConfig();
        this.loadConfig();
        if (this.enableEconomy && this.economy == null) {
            this.setupEconomy();
        } else if (!this.enableEconomy) {
            this.economy = null;
        }
        this.getLogger().info("GraveLootZ configuration reloaded!");
    }

    public boolean forceRemoveGrave(UUID playerUUID, int graveIndex) {
        List<Location> playerGravesList = this.playerGraves.get(playerUUID);
        if (playerGravesList == null || graveIndex < 0 || graveIndex >= playerGravesList.size()) {
            return false;
        }
        Location graveLoc = playerGravesList.get(graveIndex);
        ArrayList<Location> toRemove = new ArrayList<Location>();
        toRemove.add(graveLoc);
        for (Location otherLoc : this.graves.keySet()) {
            if (otherLoc.equals((Object)graveLoc) || !this.graves.get(otherLoc).equals(playerUUID) || !(graveLoc.distance(otherLoc) <= 2.0)) continue;
            toRemove.add(otherLoc);
        }
        for (Location loc : toRemove) {
            this.removeGrave(loc, false);
        }
        this.saveGraveData();
        return true;
    }

    public boolean hasEconomy() {
        return this.economy != null && this.enableEconomy;
    }

    public Object getEconomy() {
        return this.economy;
    }

    public double getTeleportCost() {
        return this.teleportCost;
    }

    public boolean chargePlayer(Player player, double amount) {
        if (!this.hasEconomy()) {
            return true;
        }
        try {
            Class<?> economyClass = this.economy.getClass();
            Method hasMethod = economyClass.getMethod("has", OfflinePlayer.class, Double.TYPE);
            boolean hasEnough = (Boolean)hasMethod.invoke(this.economy, player, amount);
            if (hasEnough) {
                Method withdrawMethod = economyClass.getMethod("withdrawPlayer", OfflinePlayer.class, Double.TYPE);
                withdrawMethod.invoke(this.economy, player, amount);
                return true;
            }
        }
        catch (Exception e) {
            this.getLogger().warning("Error charging player: " + e.getMessage());
        }
        return false;
    }

    public double getBalance(Player player) {
        if (!this.hasEconomy()) {
            return 0.0;
        }
        try {
            Class<?> economyClass = this.economy.getClass();
            Method getBalanceMethod = economyClass.getMethod("getBalance", OfflinePlayer.class);
            return (Double)getBalanceMethod.invoke(this.economy, player);
        }
        catch (Exception e) {
            this.getLogger().warning("Error getting player balance: " + e.getMessage());
            return 0.0;
        }
    }

    public boolean depositPlayer(Player player, double amount) {
        if (!this.hasEconomy()) {
            return true;
        }
        try {
            Class<?> economyClass = this.economy.getClass();
            Method depositMethod = economyClass.getMethod("depositPlayer", OfflinePlayer.class, Double.TYPE);
            depositMethod.invoke(this.economy, player, amount);
            return true;
        }
        catch (Exception e) {
            this.getLogger().warning("Error depositing to player: " + e.getMessage());
            return false;
        }
    }

    public Map<Location, UUID> getGraves() {
        return this.graves;
    }

    public Map<UUID, List<Location>> getPlayerGraves() {
        return this.playerGraves;
    }

    public Map<Location, String> getGraveMessages() {
        return this.graveMessages;
    }

    public Map<Location, Long> getGraveTimes() {
        return this.graveTimes;
    }

    public boolean isPauseTimerOffline() {
        return this.pauseTimerOffline;
    }

    public Set<UUID> getOnlinePlayers() {
        return this.onlinePlayers;
    }

    public int cleanupGraves() {
        int cleaned = 0;
        ArrayList<Location> invalidGraves = new ArrayList<Location>();
        for (Location graveLoc : this.graves.keySet()) {
            if (graveLoc.getBlock().getType() == Material.CHEST) continue;
            invalidGraves.add(graveLoc);
        }
        ArrayList<Location> orphanedHolograms = new ArrayList<Location>();
        for (Map.Entry<Location, ArmorStand> entry : this.graveHolograms.entrySet()) {
            Location hologramLoc = entry.getKey();
            ArmorStand hologram = entry.getValue();
            if (this.graves.containsKey(hologramLoc) && hologram != null && !hologram.isDead()) continue;
            orphanedHolograms.add(hologramLoc);
            if (hologram == null || hologram.isDead()) continue;
            hologram.remove();
        }
        for (Location graveLoc : invalidGraves) {
            this.removeGrave(graveLoc, false);
            ++cleaned;
        }
        for (Location hologramLoc : orphanedHolograms) {
            this.graveHolograms.remove(hologramLoc);
            ++cleaned;
        }
        for (World world : Bukkit.getWorlds()) {
            for (Entity entity : world.getEntities()) {
                ArmorStand as;
                if (!(entity instanceof ArmorStand) || (as = (ArmorStand)entity).isVisible() || as.hasGravity() || !as.isMarker() || !as.isCustomNameVisible() || as.getCustomName() == null || !as.getCustomName().contains("Grave")) continue;
                boolean isTracked = false;
                for (ArmorStand tracked : this.graveHolograms.values()) {
                    if (tracked == null || !tracked.equals((Object)as)) continue;
                    isTracked = true;
                    break;
                }
                if (isTracked) continue;
                as.remove();
                ++cleaned;
            }
        }
        if (cleaned > 0) {
            this.saveGraveData();
        }
        return cleaned;
    }

    public int getPublicAccessTime() {
        return this.publicAccessTime;
    }

    public int removeAllHolograms() {
        int removed = 0;
        for (ArmorStand hologram : this.graveHolograms.values()) {
            if (hologram == null || hologram.isDead()) continue;
            hologram.remove();
            ++removed;
        }
        this.graveHolograms.clear();
        for (World world : Bukkit.getWorlds()) {
            for (Entity entity : world.getEntities()) {
                ArmorStand armorStand;
                if (!(entity instanceof ArmorStand) || (armorStand = (ArmorStand)entity).isVisible() || armorStand.hasGravity() || !armorStand.isMarker() || !armorStand.isCustomNameVisible() || armorStand.getCustomName() == null || !armorStand.getCustomName().contains("Grave")) continue;
                armorStand.remove();
                ++removed;
            }
        }
        return removed;
    }
}

