/*
 * Decompiled with CFR 0.152.
 */
package com.Mateitaa1.gravelootz;

import com.Mateitaa1.gravelootz.GraveLootZ;
import java.util.ArrayList;
import java.util.List;
import java.util.UUID;
import java.util.concurrent.TimeUnit;
import org.bukkit.ChatColor;
import org.bukkit.Location;
import org.bukkit.command.Command;
import org.bukkit.command.CommandExecutor;
import org.bukkit.command.CommandSender;
import org.bukkit.entity.Player;

public class GravesCommand
implements CommandExecutor {
    private final GraveLootZ plugin;

    public GravesCommand(GraveLootZ plugin) {
        this.plugin = plugin;
    }

    public boolean onCommand(CommandSender sender, Command command, String label, String[] args) {
        if (args.length > 0 && args[0].equalsIgnoreCase("reload")) {
            if (!sender.hasPermission("gravelootz.admin")) {
                sender.sendMessage(String.valueOf(ChatColor.RED) + "You don't have permission to reload the plugin!");
                return true;
            }
            this.plugin.reloadPluginConfig();
            sender.sendMessage(String.valueOf(ChatColor.GREEN) + "GraveLootZ configuration reloaded successfully!");
            return true;
        }
        if (args.length > 0 && args[0].equalsIgnoreCase("cleanholograms")) {
            if (!sender.hasPermission("gravelootz.admin")) {
                sender.sendMessage(String.valueOf(ChatColor.RED) + "You don't have permission to clean holograms!");
                return true;
            }
            int removed = this.plugin.removeAllHolograms();
            sender.sendMessage(String.valueOf(ChatColor.GREEN) + "Removed " + removed + " hologram armor stands from all worlds!");
            sender.sendMessage(String.valueOf(ChatColor.YELLOW) + "This includes both active grave holograms and any leftover ones.");
            return true;
        }
        if (!(sender instanceof Player)) {
            sender.sendMessage(String.valueOf(ChatColor.RED) + "This command can only be used by players!");
            return true;
        }
        Player player = (Player)sender;
        UUID playerUUID = player.getUniqueId();
        if (args.length == 0) {
            List<Location> playerGraves = this.plugin.getPlayerGraves().get(playerUUID);
            if (playerGraves == null || playerGraves.isEmpty()) {
                player.sendMessage(String.valueOf(ChatColor.YELLOW) + "You don't have any active graves.");
                return true;
            }
            player.sendMessage(String.valueOf(ChatColor.GOLD) + "Your graves (" + playerGraves.size() + "):");
            int i = 1;
            for (Location graveLoc : playerGraves) {
                Object timeInfo = "";
                if (this.plugin.getGraveTimes().containsKey(graveLoc)) {
                    boolean isTimerPaused;
                    long createTime = this.plugin.getGraveTimes().get(graveLoc);
                    long currentTime = System.currentTimeMillis();
                    long ageMinutes = TimeUnit.MILLISECONDS.toMinutes(currentTime - createTime);
                    boolean bl = isTimerPaused = this.plugin.isPauseTimerOffline() && !this.plugin.getOnlinePlayers().contains(playerUUID);
                    if (isTimerPaused) {
                        timeInfo = String.valueOf(ChatColor.BLUE) + " [PAUSED]";
                    } else {
                        int expirationTime = this.plugin.getConfig().getInt("grave-expiration-time", 30);
                        if (expirationTime > 0) {
                            long remainingMinutes = (long)expirationTime - ageMinutes;
                            timeInfo = remainingMinutes > 0L ? String.valueOf(ChatColor.GREEN) + " [" + remainingMinutes + "m left]" : String.valueOf(ChatColor.RED) + " [EXPIRED]";
                        }
                    }
                }
                player.sendMessage(String.valueOf(ChatColor.YELLOW) + "[" + i + "] " + String.valueOf(ChatColor.WHITE) + "X: " + graveLoc.getBlockX() + ", Y: " + graveLoc.getBlockY() + ", Z: " + graveLoc.getBlockZ() + String.valueOf(ChatColor.GRAY) + " (in " + graveLoc.getWorld().getName() + ")" + (String)timeInfo);
                ++i;
            }
            Object tpCommand = "/graves tp <number>";
            if (this.plugin.hasEconomy()) {
                tpCommand = (String)tpCommand + " (Cost: $" + this.plugin.getTeleportCost() + ")";
            }
            player.sendMessage(String.valueOf(ChatColor.YELLOW) + "Use " + String.valueOf(ChatColor.WHITE) + (String)tpCommand + String.valueOf(ChatColor.YELLOW) + " to teleport to a grave.");
            return true;
        }
        if (args[0].equalsIgnoreCase("tp") || args[0].equalsIgnoreCase("teleport")) {
            Location graveLoc;
            Location safeLoc;
            double cost;
            int index;
            if (!player.hasPermission("gravelootz.teleport")) {
                player.sendMessage(String.valueOf(ChatColor.RED) + "You don't have permission to teleport to graves!");
                return true;
            }
            if (args.length < 2) {
                Object usage = "Usage: /graves tp <number>";
                if (this.plugin.hasEconomy()) {
                    usage = (String)usage + " (Cost: $" + this.plugin.getTeleportCost() + ")";
                }
                player.sendMessage(String.valueOf(ChatColor.RED) + (String)usage);
                return true;
            }
            List<Location> playerGraves = this.plugin.getPlayerGraves().get(playerUUID);
            if (playerGraves == null || playerGraves.isEmpty()) {
                player.sendMessage(String.valueOf(ChatColor.YELLOW) + "You don't have any active graves.");
                return true;
            }
            try {
                index = Integer.parseInt(args[1]) - 1;
            }
            catch (NumberFormatException e) {
                player.sendMessage(String.valueOf(ChatColor.RED) + "Please enter a valid number!");
                return true;
            }
            if (index < 0 || index >= playerGraves.size()) {
                player.sendMessage(String.valueOf(ChatColor.RED) + "Invalid grave number! You have " + playerGraves.size() + " graves.");
                return true;
            }
            if (this.plugin.hasEconomy() && (cost = this.plugin.getTeleportCost()) > 0.0) {
                double balance = this.plugin.getBalance(player);
                if (balance < cost) {
                    player.sendMessage(String.valueOf(ChatColor.RED) + "You don't have enough money! Cost: $" + cost + ", Your balance: $" + String.format("%.2f", balance));
                    return true;
                }
                if (!this.plugin.chargePlayer(player, cost)) {
                    player.sendMessage(String.valueOf(ChatColor.RED) + "Failed to charge for teleportation!");
                    return true;
                }
                player.sendMessage(String.valueOf(ChatColor.GREEN) + "$" + cost + " has been deducted from your account.");
            }
            if ((safeLoc = this.findSafeLocation(graveLoc = playerGraves.get(index))) != null) {
                player.teleport(safeLoc);
                player.sendMessage(String.valueOf(ChatColor.GREEN) + "Teleported to your grave!");
            } else {
                double cost2;
                if (this.plugin.hasEconomy() && (cost2 = this.plugin.getTeleportCost()) > 0.0) {
                    this.plugin.depositPlayer(player, cost2);
                    player.sendMessage(String.valueOf(ChatColor.YELLOW) + "Teleportation failed. $" + cost2 + " has been refunded.");
                }
                player.sendMessage(String.valueOf(ChatColor.RED) + "Could not find a safe location near your grave!");
            }
            return true;
        }
        if (args[0].equalsIgnoreCase("list")) {
            if (!player.hasPermission("gravelootz.admin")) {
                player.sendMessage(String.valueOf(ChatColor.RED) + "You don't have permission to list all graves!");
                return true;
            }
            if (this.plugin.getGraves().isEmpty()) {
                player.sendMessage(String.valueOf(ChatColor.YELLOW) + "There are no active graves on the server.");
                return true;
            }
            player.sendMessage(String.valueOf(ChatColor.GOLD) + "All graves on the server (" + this.plugin.getGraves().size() + "):");
            int i = 1;
            for (Location graveLoc : this.plugin.getGraves().keySet()) {
                UUID ownerUUID = this.plugin.getGraves().get(graveLoc);
                String ownerName = this.plugin.getServer().getOfflinePlayer(ownerUUID).getName();
                Object timeInfo = "";
                if (this.plugin.getGraveTimes().containsKey(graveLoc)) {
                    int publicAccessTime;
                    long createTime = this.plugin.getGraveTimes().get(graveLoc);
                    long currentTime = System.currentTimeMillis();
                    long ageMinutes = TimeUnit.MILLISECONDS.toMinutes(currentTime - createTime);
                    if (ageMinutes >= (long)(publicAccessTime = this.plugin.getConfig().getInt("public-access-time", 60))) {
                        timeInfo = String.valueOf(ChatColor.AQUA) + " [PUBLIC]";
                    } else {
                        long timeUntilPublic = (long)publicAccessTime - ageMinutes;
                        timeInfo = String.valueOf(ChatColor.YELLOW) + " [" + timeUntilPublic + "m until public]";
                    }
                }
                player.sendMessage(String.valueOf(ChatColor.YELLOW) + "[" + i + "] " + String.valueOf(ChatColor.WHITE) + ownerName + "'s grave X: " + graveLoc.getBlockX() + ", Y: " + graveLoc.getBlockY() + ", Z: " + graveLoc.getBlockZ() + String.valueOf(ChatColor.GRAY) + " (" + graveLoc.getWorld().getName() + ")" + (String)timeInfo);
                ++i;
            }
            return true;
        }
        if (args[0].equalsIgnoreCase("public")) {
            List<Location> publicGraves = this.getPublicGraves();
            if (publicGraves.isEmpty()) {
                player.sendMessage(String.valueOf(ChatColor.YELLOW) + "There are no public graves available.");
                int publicAccessTime = this.plugin.getConfig().getInt("public-access-time", 60);
                player.sendMessage(String.valueOf(ChatColor.GRAY) + "Graves become public after " + publicAccessTime + " minutes.");
                return true;
            }
            player.sendMessage(String.valueOf(ChatColor.GOLD) + "Public graves (" + publicGraves.size() + "):");
            int i = 1;
            for (Location graveLoc : publicGraves) {
                UUID ownerUUID = this.plugin.getGraves().get(graveLoc);
                String ownerName = this.plugin.getServer().getOfflinePlayer(ownerUUID).getName();
                player.sendMessage(String.valueOf(ChatColor.AQUA) + "[" + i + "] " + String.valueOf(ChatColor.WHITE) + ownerName + "'s grave X: " + graveLoc.getBlockX() + ", Y: " + graveLoc.getBlockY() + ", Z: " + graveLoc.getBlockZ() + String.valueOf(ChatColor.GRAY) + " (" + graveLoc.getWorld().getName() + ")");
                ++i;
            }
            player.sendMessage(String.valueOf(ChatColor.GREEN) + "You can access these graves by walking up to them!");
            return true;
        }
        if (args[0].equalsIgnoreCase("info") && args.length > 1) {
            int index;
            List<Location> playerGraves = this.plugin.getPlayerGraves().get(playerUUID);
            if (playerGraves == null || playerGraves.isEmpty()) {
                player.sendMessage(String.valueOf(ChatColor.YELLOW) + "You don't have any active graves.");
                return true;
            }
            try {
                index = Integer.parseInt(args[1]) - 1;
            }
            catch (NumberFormatException e) {
                player.sendMessage(String.valueOf(ChatColor.RED) + "Please enter a valid number!");
                return true;
            }
            if (index < 0 || index >= playerGraves.size()) {
                player.sendMessage(String.valueOf(ChatColor.RED) + "Invalid grave number! You have " + playerGraves.size() + " graves.");
                return true;
            }
            Location graveLoc = playerGraves.get(index);
            this.showGraveInfo(player, graveLoc, index + 1);
            return true;
        }
        if (args[0].equalsIgnoreCase("remove") && args.length > 1) {
            int index;
            List<Location> playerGraves = this.plugin.getPlayerGraves().get(playerUUID);
            if (playerGraves == null || playerGraves.isEmpty()) {
                player.sendMessage(String.valueOf(ChatColor.YELLOW) + "You don't have any active graves.");
                return true;
            }
            try {
                index = Integer.parseInt(args[1]) - 1;
            }
            catch (NumberFormatException e) {
                player.sendMessage(String.valueOf(ChatColor.RED) + "Please enter a valid number!");
                return true;
            }
            if (index < 0 || index >= playerGraves.size()) {
                player.sendMessage(String.valueOf(ChatColor.RED) + "Invalid grave number! You have " + playerGraves.size() + " graves.");
                return true;
            }
            if (this.plugin.forceRemoveGrave(playerUUID, index)) {
                player.sendMessage(String.valueOf(ChatColor.GREEN) + "Grave #" + (index + 1) + " has been removed from your list.");
            } else {
                player.sendMessage(String.valueOf(ChatColor.RED) + "Failed to remove grave. Please try again.");
            }
            return true;
        }
        if (args[0].equalsIgnoreCase("clean")) {
            if (!player.hasPermission("gravelootz.admin")) {
                player.sendMessage(String.valueOf(ChatColor.RED) + "You don't have permission to clean graves!");
                return true;
            }
            int cleaned = this.plugin.cleanupGraves();
            player.sendMessage(String.valueOf(ChatColor.GREEN) + "Cleaned up " + cleaned + " invalid graves and holograms.");
            return true;
        }
        if (args[0].equalsIgnoreCase("help")) {
            this.sendHelpMessage(player);
            return true;
        }
        this.sendHelpMessage(player);
        return true;
    }

    private List<Location> getPublicGraves() {
        ArrayList<Location> publicGraves = new ArrayList<Location>();
        long currentTime = System.currentTimeMillis();
        int publicAccessTime = this.plugin.getConfig().getInt("public-access-time", 60);
        for (Location graveLoc : this.plugin.getGraves().keySet()) {
            long createTime;
            long ageMinutes;
            if (!this.plugin.getGraveTimes().containsKey(graveLoc) || (ageMinutes = TimeUnit.MILLISECONDS.toMinutes(currentTime - (createTime = this.plugin.getGraveTimes().get(graveLoc).longValue()))) < (long)publicAccessTime) continue;
            publicGraves.add(graveLoc);
        }
        return publicGraves;
    }

    private void showGraveInfo(Player player, Location graveLoc, int graveNumber) {
        double cost;
        player.sendMessage(String.valueOf(ChatColor.GOLD) + "==== Grave #" + graveNumber + " Info ====");
        player.sendMessage(String.valueOf(ChatColor.YELLOW) + "Location: " + String.valueOf(ChatColor.WHITE) + "X: " + graveLoc.getBlockX() + ", Y: " + graveLoc.getBlockY() + ", Z: " + graveLoc.getBlockZ());
        player.sendMessage(String.valueOf(ChatColor.YELLOW) + "World: " + String.valueOf(ChatColor.WHITE) + graveLoc.getWorld().getName());
        if (this.plugin.getGraveTimes().containsKey(graveLoc)) {
            int publicAccessTime;
            long createTime = this.plugin.getGraveTimes().get(graveLoc);
            long currentTime = System.currentTimeMillis();
            long ageMinutes = TimeUnit.MILLISECONDS.toMinutes(currentTime - createTime);
            player.sendMessage(String.valueOf(ChatColor.YELLOW) + "Age: " + String.valueOf(ChatColor.WHITE) + ageMinutes + " minutes");
            int expirationTime = this.plugin.getConfig().getInt("grave-expiration-time", 30);
            if (expirationTime > 0) {
                long remainingMinutes = (long)expirationTime - ageMinutes;
                if (remainingMinutes > 0L) {
                    player.sendMessage(String.valueOf(ChatColor.YELLOW) + "Expires in: " + String.valueOf(ChatColor.GREEN) + remainingMinutes + " minutes");
                } else {
                    player.sendMessage(String.valueOf(ChatColor.YELLOW) + "Status: " + String.valueOf(ChatColor.RED) + "EXPIRED");
                }
                if (this.plugin.isPauseTimerOffline()) {
                    boolean isOnline = this.plugin.getOnlinePlayers().contains(player.getUniqueId());
                    if (!isOnline) {
                        player.sendMessage(String.valueOf(ChatColor.BLUE) + "Timer is currently paused (you're offline)");
                    } else {
                        player.sendMessage(String.valueOf(ChatColor.GREEN) + "Timer is running (you're online)");
                    }
                }
            }
            if ((publicAccessTime = this.plugin.getConfig().getInt("public-access-time", 60)) > 0) {
                long timeUntilPublic = (long)publicAccessTime - ageMinutes;
                if (timeUntilPublic > 0L) {
                    player.sendMessage(String.valueOf(ChatColor.YELLOW) + "Public access in: " + String.valueOf(ChatColor.GOLD) + timeUntilPublic + " minutes");
                } else {
                    player.sendMessage(String.valueOf(ChatColor.YELLOW) + "Public access: " + String.valueOf(ChatColor.AQUA) + "AVAILABLE");
                }
            }
        }
        if (this.plugin.hasEconomy() && (cost = this.plugin.getTeleportCost()) > 0.0) {
            player.sendMessage(String.valueOf(ChatColor.YELLOW) + "Teleport cost: " + String.valueOf(ChatColor.WHITE) + "$" + cost);
            double balance = this.plugin.getBalance(player);
            if (balance >= cost) {
                player.sendMessage(String.valueOf(ChatColor.GREEN) + "You can afford to teleport (Balance: $" + String.format("%.2f", balance) + ")");
            } else {
                player.sendMessage(String.valueOf(ChatColor.RED) + "You cannot afford to teleport (Balance: $" + String.format("%.2f", balance) + ")");
            }
        }
    }

    private Location findSafeLocation(Location graveLoc) {
        Location safeLoc = graveLoc.clone().add(0.0, 1.0, 0.0);
        if (!this.isSafeLocation(safeLoc)) {
            for (int x = -1; x <= 1; ++x) {
                for (int z = -1; z <= 1; ++z) {
                    Location testLoc = graveLoc.clone().add((double)x, 1.0, (double)z);
                    if (!this.isSafeLocation(testLoc)) continue;
                    return testLoc;
                }
            }
            return null;
        }
        return safeLoc;
    }

    private boolean isSafeLocation(Location loc) {
        return loc.getBlock().getType().isAir() && loc.clone().add(0.0, 1.0, 0.0).getBlock().getType().isAir();
    }

    private void sendHelpMessage(Player player) {
        int publicAccessTime;
        player.sendMessage(String.valueOf(ChatColor.GOLD) + "==== GraveLootZ Commands ====");
        player.sendMessage(String.valueOf(ChatColor.YELLOW) + "/graves" + String.valueOf(ChatColor.WHITE) + " - List your active graves");
        player.sendMessage(String.valueOf(ChatColor.YELLOW) + "/graves info <number>" + String.valueOf(ChatColor.WHITE) + " - Show detailed grave information");
        player.sendMessage(String.valueOf(ChatColor.YELLOW) + "/graves public" + String.valueOf(ChatColor.WHITE) + " - List graves open to public access");
        player.sendMessage(String.valueOf(ChatColor.YELLOW) + "/graves remove <number>" + String.valueOf(ChatColor.WHITE) + " - Manually remove a grave from your list");
        if (player.hasPermission("gravelootz.teleport")) {
            String tpHelp = "/graves tp <number>" + String.valueOf(ChatColor.WHITE) + " - Teleport to a grave";
            if (this.plugin.hasEconomy() && this.plugin.getTeleportCost() > 0.0) {
                tpHelp = tpHelp + " (Cost: $" + this.plugin.getTeleportCost() + ")";
            }
            player.sendMessage(String.valueOf(ChatColor.YELLOW) + tpHelp);
        }
        if (player.hasPermission("gravelootz.admin")) {
            player.sendMessage(String.valueOf(ChatColor.YELLOW) + "/graves list" + String.valueOf(ChatColor.WHITE) + " - List all graves on server (Admin)");
            player.sendMessage(String.valueOf(ChatColor.YELLOW) + "/graves clean" + String.valueOf(ChatColor.WHITE) + " - Clean up invalid graves (Admin)");
            player.sendMessage(String.valueOf(ChatColor.YELLOW) + "/graves cleanholograms" + String.valueOf(ChatColor.WHITE) + " - Remove all hologram armor stands (Admin)");
            player.sendMessage(String.valueOf(ChatColor.YELLOW) + "/graves reload" + String.valueOf(ChatColor.WHITE) + " - Reload plugin configuration (Admin)");
        }
        player.sendMessage(String.valueOf(ChatColor.YELLOW) + "/graves help" + String.valueOf(ChatColor.WHITE) + " - Show this help message");
        if (this.plugin.hasEconomy()) {
            double balance = this.plugin.getBalance(player);
            player.sendMessage(String.valueOf(ChatColor.GRAY) + "Your balance: $" + String.format("%.2f", balance));
        }
        if ((publicAccessTime = this.plugin.getConfig().getInt("public-access-time", 60)) > 0) {
            player.sendMessage(String.valueOf(ChatColor.GRAY) + "Graves become public after " + publicAccessTime + " minutes");
        }
    }
}

