/*
 * Decompiled with CFR 0.152.
 */
package net.threetag.itfollows.datagen.fabric;

import java.util.concurrent.CompletableFuture;
import net.fabricmc.fabric.api.datagen.v1.FabricDataOutput;
import net.fabricmc.fabric.api.datagen.v1.provider.FabricLanguageProvider;
import net.minecraft.class_1299;
import net.minecraft.class_156;
import net.minecraft.class_1792;
import net.minecraft.class_2248;
import net.minecraft.class_2960;
import net.minecraft.class_7225;
import net.threetag.itfollows.block.IFBlocks;
import net.threetag.itfollows.datagen.fabric.IFAdvancementProvider;
import net.threetag.itfollows.entity.IFEntityTypes;
import net.threetag.itfollows.item.IFItems;
import net.threetag.itfollows.item.IFJukeboxSongs;

public abstract class IFLangProvider
extends FabricLanguageProvider {
    protected IFLangProvider(FabricDataOutput dataOutput, String languageCode, CompletableFuture<class_7225.class_7874> registryLookup) {
        super(dataOutput, languageCode, registryLookup);
    }

    public void addConfigTitle(FabricLanguageProvider.TranslationBuilder builder, String name) {
        builder.add("it_follows.midnightconfig.title", name);
    }

    public void addConfigCategory(FabricLanguageProvider.TranslationBuilder builder, String key, String name) {
        builder.add("it_follows.midnightconfig.category." + key, name);
    }

    public void addConfigEntry(FabricLanguageProvider.TranslationBuilder builder, String key, String name) {
        builder.add("it_follows.midnightconfig." + key, name);
    }

    public static class Saxon
    extends IFLangProvider {
        protected Saxon(FabricDataOutput dataOutput, CompletableFuture<class_7225.class_7874> registryLookup) {
            super(dataOutput, "sxu", registryLookup);
        }

        public void generateTranslations(class_7225.class_7874 provider, FabricLanguageProvider.TranslationBuilder builder) {
            builder.add("commands.it_follows.start_curse.error.already_started", "%s hat den Fluch schoh");
            builder.add("commands.it_follows.start_curse.success", "%s hat nu den Fluch");
            builder.add("commands.it_follows.stop_curse.error.no_active_curse", "%s hat keenen Fluch");
            builder.add("commands.it_follows.stop_curse.success", "%s hat nu keenen Fluch mehr");
            builder.add("commands.it_follows.position", "%s's Entit\u00e4t is bei %s (%s Bl\u00f6gge endfernd)");
            builder.add((class_2248)IFBlocks.OMINOUS_POT.get(), "Unheilvoller Grug");
            builder.add((class_1792)IFItems.OMINOUS_POT.get(), "Unheilvoller Grug");
            builder.add((class_1792)IFItems.MUSIC_DISC_SOLSTICE.get(), "Schallbladde");
            builder.add(class_156.method_646((String)"jukebox_song", (class_2960)IFJukeboxSongs.SOLSTICE.method_29177()), "Disasterpeace - Title");
            builder.add((class_1792)IFItems.SPLASH_POTION_OF_SPREADING.get(), "Wurftrank der Verbreitung");
            builder.add((class_1299)IFEntityTypes.THE_ENTITY.get(), "Das Wesen");
            this.addConfigTitle(builder, "It Follows");
            this.addConfigCategory(builder, "entity", "Entit\u00e4tseinstellungen");
            this.addConfigEntry(builder, "MOVEMENT_SPEED", "Bewejungsjeschwindichgehd");
            this.addConfigEntry(builder, "BLOCK_BREAK_INTERVAL", "Blockbruchintervall");
            builder.add(IFAdvancementProvider.ADVANCEMENT_RECEIVE_CURSE_TITLE, "Es denkt nisch... es f\u00fchlt nisch...");
            builder.add(IFAdvancementProvider.ADVANCEMENT_RECEIVE_CURSE_DESCRIPTION, "Es follgt");
            builder.add(IFAdvancementProvider.ADVANCEMENT_BREAK_CURSE_TITLE, "Coda");
            builder.add(IFAdvancementProvider.ADVANCEMENT_BREAK_CURSE_DESCRIPTION, "Denksch, es hot funkti'niert?...");
            builder.add(IFAdvancementProvider.ADVANCEMENT_PASS_ON_CURSE_TITLE, "Einfach... weidageem");
            builder.add(IFAdvancementProvider.ADVANCEMENT_PASS_ON_CURSE_DESCRIPTION, "Des kann doch nisch schiefgeehn... oddor?");
            builder.add(IFAdvancementProvider.ADVANCEMENT_RETURN_CURSE_TITLE, "Verweilnd");
            builder.add(IFAdvancementProvider.ADVANCEMENT_RETURN_CURSE_DESCRIPTION, "Es is noch nisch f\u00e4ddsch mit dir...");
        }
    }

    public static class German
    extends IFLangProvider {
        protected German(FabricDataOutput dataOutput, CompletableFuture<class_7225.class_7874> registryLookup) {
            super(dataOutput, "de_de", registryLookup);
        }

        public void generateTranslations(class_7225.class_7874 provider, FabricLanguageProvider.TranslationBuilder builder) {
            builder.add("commands.it_follows.start_curse.error.already_started", "%s hat den Fluch bereits");
            builder.add("commands.it_follows.start_curse.success", "%s hat nun den Fluch");
            builder.add("commands.it_follows.stop_curse.error.no_active_curse", "%s hat keinen Fluch");
            builder.add("commands.it_follows.stop_curse.success", "%s hat nun den Fluch nicht mehr");
            builder.add("commands.it_follows.position", "%s's Entit\u00e4t ist bei %s (%s Bl\u00f6cke entfernt)");
            builder.add((class_2248)IFBlocks.OMINOUS_POT.get(), "Unheilvoller Krug");
            builder.add((class_1792)IFItems.OMINOUS_POT.get(), "Unheilvoller Krug");
            builder.add((class_1792)IFItems.MUSIC_DISC_SOLSTICE.get(), "Schallplatte");
            builder.add(class_156.method_646((String)"jukebox_song", (class_2960)IFJukeboxSongs.SOLSTICE.method_29177()), "Disasterpeace - Title");
            builder.add((class_1792)IFItems.SPLASH_POTION_OF_SPREADING.get(), "Wurftrank der Verbreitung");
            builder.add((class_1299)IFEntityTypes.THE_ENTITY.get(), "Das Wesen");
            this.addConfigTitle(builder, "It Follows");
            this.addConfigCategory(builder, "entity", "Entit\u00e4tseinstellungen");
            this.addConfigEntry(builder, "MOVEMENT_SPEED", "Bewegungsgeschwindigkeit");
            this.addConfigEntry(builder, "BLOCK_BREAK_INTERVAL", "Blockbruchintervall");
            builder.add(IFAdvancementProvider.ADVANCEMENT_RECEIVE_CURSE_TITLE, "Es denkt nicht... es f\u00fchlt nicht...");
            builder.add(IFAdvancementProvider.ADVANCEMENT_RECEIVE_CURSE_DESCRIPTION, "Es folgt");
            builder.add(IFAdvancementProvider.ADVANCEMENT_BREAK_CURSE_TITLE, "Coda");
            builder.add(IFAdvancementProvider.ADVANCEMENT_BREAK_CURSE_DESCRIPTION, "Denkst du, es hat funktioniert?...");
            builder.add(IFAdvancementProvider.ADVANCEMENT_PASS_ON_CURSE_TITLE, "Einfach... weitergeben");
            builder.add(IFAdvancementProvider.ADVANCEMENT_PASS_ON_CURSE_DESCRIPTION, "Das kann doch nicht schiefgehen... oder?");
            builder.add(IFAdvancementProvider.ADVANCEMENT_RETURN_CURSE_TITLE, "Verweilend");
            builder.add(IFAdvancementProvider.ADVANCEMENT_RETURN_CURSE_DESCRIPTION, "Es ist noch nicht fertig mit dir...");
        }
    }

    public static class English
    extends IFLangProvider {
        protected English(FabricDataOutput dataOutput, CompletableFuture<class_7225.class_7874> registryLookup) {
            super(dataOutput, "en_us", registryLookup);
        }

        public void generateTranslations(class_7225.class_7874 provider, FabricLanguageProvider.TranslationBuilder builder) {
            builder.add("commands.it_follows.start_curse.error.already_started", "%s already has an active curse");
            builder.add("commands.it_follows.start_curse.success", "%s received the curse");
            builder.add("commands.it_follows.stop_curse.error.no_active_curse", "%s has no curse");
            builder.add("commands.it_follows.stop_curse.success", "%s no longer has the curse");
            builder.add("commands.it_follows.position", "%s's entity is at %s (%s blocks away)");
            builder.add((class_2248)IFBlocks.OMINOUS_POT.get(), "Ominous Pot");
            builder.add((class_1792)IFItems.OMINOUS_POT.get(), "Ominous Pot");
            builder.add((class_1792)IFItems.MUSIC_DISC_SOLSTICE.get(), "Music Disc");
            builder.add(class_156.method_646((String)"jukebox_song", (class_2960)IFJukeboxSongs.SOLSTICE.method_29177()), "Disasterpeace - Title");
            builder.add((class_1792)IFItems.SPLASH_POTION_OF_SPREADING.get(), "Splash Potion of Spreading");
            builder.add((class_1299)IFEntityTypes.THE_ENTITY.get(), "The Entity");
            this.addConfigTitle(builder, "It Follows");
            this.addConfigCategory(builder, "entity", "Entity Settings");
            this.addConfigEntry(builder, "MOVEMENT_SPEED", "Movement Speed");
            this.addConfigEntry(builder, "BLOCK_BREAK_INTERVAL", "Block Break Interval");
            builder.add(IFAdvancementProvider.ADVANCEMENT_RECEIVE_CURSE_TITLE, "It doesn't think... it doesn't feel...");
            builder.add(IFAdvancementProvider.ADVANCEMENT_RECEIVE_CURSE_DESCRIPTION, "It Follows");
            builder.add(IFAdvancementProvider.ADVANCEMENT_BREAK_CURSE_TITLE, "Coda");
            builder.add(IFAdvancementProvider.ADVANCEMENT_BREAK_CURSE_DESCRIPTION, "Do you think it worked?...");
            builder.add(IFAdvancementProvider.ADVANCEMENT_RETURN_CURSE_TITLE, "Lingering");
            builder.add(IFAdvancementProvider.ADVANCEMENT_RETURN_CURSE_DESCRIPTION, "It is not done with you...");
            builder.add(IFAdvancementProvider.ADVANCEMENT_PASS_ON_CURSE_TITLE, "Just... pass it along");
            builder.add(IFAdvancementProvider.ADVANCEMENT_PASS_ON_CURSE_DESCRIPTION, "This can't end poorly... right?");
        }
    }
}

