/*
 * Decompiled with CFR 0.152.
 */
package net.threetag.itfollows.entity;

import java.util.Objects;
import java.util.UUID;
import net.minecraft.class_11368;
import net.minecraft.class_11372;
import net.minecraft.class_1297;
import net.minecraft.class_1657;
import net.minecraft.class_1923;
import net.minecraft.class_1937;
import net.minecraft.class_2135;
import net.minecraft.class_2246;
import net.minecraft.class_2338;
import net.minecraft.class_2382;
import net.minecraft.class_243;
import net.minecraft.class_2596;
import net.minecraft.class_2765;
import net.minecraft.class_3222;
import net.minecraft.class_3414;
import net.minecraft.class_3419;
import net.minecraft.class_4076;
import net.minecraft.class_4844;
import net.minecraft.class_7923;
import net.threetag.itfollows.IFConfig;
import net.threetag.itfollows.advancements.IFCriteriaTriggers;
import net.threetag.itfollows.entity.TheEntity;
import net.threetag.itfollows.sound.IFSoundEvents;

public class CursePlayerHandler {
    public static final int DEFAULT_DISTANCE = 2000;
    public static final int DESPAWN_DISTANCE = 100;
    private final class_3222 player;
    private boolean curseActive = false;
    private TheEntity lastKnownEntity;
    private int lastKnownEntityId = -1;
    private class_243 entityPosition = null;
    private int updateTimer = 0;
    private int isStuckTimer = 0;
    private class_243 isStuckPositionTracker = null;
    private UUID infectedBy = null;

    public CursePlayerHandler(class_3222 player) {
        this.player = player;
    }

    public void read(class_11368 input) {
        this.curseActive = input.method_71433("curse_active", false);
        this.lastKnownEntityId = input.method_71424("last_known_entity_id", -1);
        this.entityPosition = input.method_71426("entity_position", class_243.field_38277).orElse(null);
        this.infectedBy = input.method_71426("infected_by", class_4844.field_25122).orElse(null);
    }

    public void write(class_11372 output) {
        output.method_71472("curse_active", this.curseActive);
        output.method_71465("last_known_entity_id", this.lastKnownEntityId);
        output.method_71477("entity_position", class_243.field_38277, (Object)this.entityPosition);
        output.method_71477("infected_by", class_4844.field_25122, (Object)this.infectedBy);
    }

    public void copyFrom(CursePlayerHandler source) {
        this.curseActive = source.curseActive;
        this.lastKnownEntityId = source.lastKnownEntityId;
        this.entityPosition = source.entityPosition;
        this.infectedBy = source.infectedBy;
        if (this.curseActive) {
            this.spawnNewEntity();
        }
    }

    public void tick() {
        if (this.curseActive) {
            ++this.updateTimer;
            ++this.isStuckTimer;
            if (this.updateTimer >= 20) {
                if (this.lastKnownEntity != null && (this.lastKnownEntity.method_31481() || this.lastKnownEntity.method_19538().method_1022(this.player.method_19538()) > 100.0)) {
                    this.removeEntity(this.lastKnownEntity);
                }
                if (this.lastKnownEntity == null) {
                    this.lastKnownEntityId = -1;
                    if (!this.spawnNewEntity()) {
                        this.simulateEntityMovement();
                    }
                }
                this.updateTimer = 0;
            }
            if (this.isStuckPositionTracker == null && this.lastKnownEntity != null) {
                this.isStuckPositionTracker = this.lastKnownEntity.method_19538();
            }
            if (this.isStuckTimer >= 20 * IFConfig.BLOCK_BREAK_INTERVAL && this.lastKnownEntity != null) {
                double blocksTravelled = this.isStuckPositionTracker.method_1022(this.lastKnownEntity.method_19538());
                this.isStuckPositionTracker = this.lastKnownEntity.method_19538();
                this.isStuckTimer = 0;
                if (blocksTravelled < (double)IFConfig.BLOCK_BREAK_INTERVAL / 2.0) {
                    this.breakBlocksInPath();
                }
            }
        }
    }

    public boolean startCurseFresh() {
        if (!this.curseActive) {
            this.curseActive = true;
            this.infectedBy = null;
            this.setEntityPosition(2000);
            this.spawnNewEntity();
            this.player.field_13987.method_14364((class_2596)new class_2765(class_7923.field_41172.method_47983((Object)((class_3414)IFSoundEvents.ENTITY_APPROACHING.get())), class_3419.field_15251, (class_1297)this.player, 1.0f, 1.0f, this.player.method_59922().method_43055()));
            ((class_2135)IFCriteriaTriggers.RECEIVED_CURSE.get()).method_9141(this.player);
            return true;
        }
        return false;
    }

    public boolean startCurseAtDistanceFresh(int distance) {
        if (!this.curseActive) {
            this.curseActive = true;
            this.infectedBy = null;
            this.setEntityPosition(distance);
            this.spawnNewEntity();
            this.player.field_13987.method_14364((class_2596)new class_2765(class_7923.field_41172.method_47983((Object)((class_3414)IFSoundEvents.ENTITY_APPROACHING.get())), class_3419.field_15251, (class_1297)this.player, 1.0f, 1.0f, this.player.method_59922().method_43055()));
            ((class_2135)IFCriteriaTriggers.RECEIVED_CURSE.get()).method_9141(this.player);
            return true;
        }
        return false;
    }

    public boolean startCurseAtPositionReturned(class_243 entityPosition) {
        if (!this.curseActive) {
            this.curseActive = true;
            this.entityPosition = entityPosition;
            this.spawnNewEntity();
            this.player.field_13987.method_14364((class_2596)new class_2765(class_7923.field_41172.method_47983((Object)((class_3414)IFSoundEvents.ENTITY_APPROACHING.get())), class_3419.field_15251, (class_1297)this.player, 1.0f, 1.0f, this.player.method_59922().method_43055()));
            ((class_2135)IFCriteriaTriggers.RECEIVED_CURSE.get()).method_9141(this.player);
            return true;
        }
        return false;
    }

    public boolean startCurseInfectedBy(class_3222 infectedBy) {
        CursePlayerHandler infectedByHandler = CursePlayerHandler.get(infectedBy);
        if (!this.isCurseActive() && infectedByHandler.isCurseActive()) {
            this.curseActive = true;
            this.infectedBy = infectedBy.method_5667();
            this.entityPosition = infectedByHandler.getEntityPosition();
            this.spawnNewEntity();
            this.player.field_13987.method_14364((class_2596)new class_2765(class_7923.field_41172.method_47983((Object)((class_3414)IFSoundEvents.ENTITY_APPROACHING.get())), class_3419.field_15251, (class_1297)this.player, 1.0f, 1.0f, this.player.method_59922().method_43055()));
            ((class_2135)IFCriteriaTriggers.RECEIVED_CURSE.get()).method_9141(this.player);
            ((class_2135)IFCriteriaTriggers.PASSED_ON_CURSE.get()).method_9141(infectedBy);
            infectedByHandler.stopCurse(false);
            return true;
        }
        return false;
    }

    public void stopCurse(boolean revertToInfectedBy) {
        if (this.curseActive) {
            class_3222 infect;
            if (revertToInfectedBy && this.infectedBy != null && (infect = Objects.requireNonNull(this.player.method_5682()).method_3760().method_14602(this.infectedBy)) != null && CursePlayerHandler.get(infect).startCurseAtPositionReturned(this.getEntityPosition())) {
                ((class_2135)IFCriteriaTriggers.RETURNED_CURSE.get()).method_9141(infect);
            }
            if (this.lastKnownEntity != null) {
                this.lastKnownEntity.method_31472();
            }
            this.entityPosition = null;
            this.curseActive = false;
            this.infectedBy = null;
        }
    }

    private void setEntityPosition(int distance) {
        this.entityPosition = TheEntity.getRandomPos((class_1937)this.player.method_51469(), this.player.method_19538(), distance, this.player.method_59922());
    }

    private boolean spawnNewEntity() {
        if (this.curseActive) {
            if (this.lastKnownEntity != null) {
                this.lastKnownEntity.method_31472();
            }
            if (this.entityPosition == null) {
                this.setEntityPosition(2000);
            }
            if (this.entityPosition.method_1022(this.player.method_19538()) < 100.0 && this.isEntityPosLoaded()) {
                this.lastKnownEntity = new TheEntity((class_1657)this.player);
                this.lastKnownEntity.method_33574(this.entityPosition);
                boolean spawned = this.player.method_51469().method_18768((class_1297)this.lastKnownEntity);
                if (spawned) {
                    this.lastKnownEntityId = this.lastKnownEntity.method_5628();
                }
                return spawned;
            }
        }
        return false;
    }

    private void breakBlocksInPath() {
        if (this.lastKnownEntity != null) {
            int y = this.lastKnownEntity.method_31478();
            int playerY = this.player.method_31478();
            class_243 diffVec = this.player.method_19538().method_1020(this.lastKnownEntity.method_19538()).method_1029();
            class_2382 offset = new class_2382(diffVec.field_1352 < -0.1 ? -1 : (diffVec.field_1352 > 0.1 ? 1 : 0), 0, diffVec.field_1350 < -0.1 ? -1 : (diffVec.field_1350 > 0.1 ? 1 : 0));
            if (Math.abs(offset.method_10263()) == 1 && Math.abs(offset.method_10260()) == 1) {
                offset = new class_2382(offset.method_10263(), 0, 0);
            }
            class_2338 blockPosInFront = this.lastKnownEntity.method_24515().method_10081(offset);
            if (y == playerY) {
                this.destroyBlock((class_1937)this.player.method_51469(), blockPosInFront, (class_1297)this.lastKnownEntity);
                this.destroyBlock((class_1937)this.player.method_51469(), blockPosInFront.method_10084(), (class_1297)this.lastKnownEntity);
                if (this.player.method_51469().method_22347(blockPosInFront.method_10074())) {
                    this.player.method_51469().method_8652(blockPosInFront.method_10074(), class_2246.field_10566.method_9564(), 3);
                }
            } else if (y < playerY) {
                if (this.player.method_31477() == this.lastKnownEntity.method_31477() && this.player.method_31479() == this.lastKnownEntity.method_31479()) {
                    this.lastKnownEntity.method_6043();
                    this.player.method_51469().method_8652(this.lastKnownEntity.method_24515(), class_2246.field_10566.method_9564(), 3);
                    this.destroyBlock((class_1937)this.player.method_51469(), this.lastKnownEntity.method_24515().method_10086(2), (class_1297)this.lastKnownEntity);
                } else {
                    this.destroyBlock((class_1937)this.player.method_51469(), blockPosInFront.method_10084(), (class_1297)this.lastKnownEntity);
                    this.destroyBlock((class_1937)this.player.method_51469(), blockPosInFront.method_10086(2), (class_1297)this.lastKnownEntity);
                    this.destroyBlock((class_1937)this.player.method_51469(), blockPosInFront.method_10086(3), (class_1297)this.lastKnownEntity);
                    if (this.player.method_51469().method_22347(blockPosInFront)) {
                        this.player.method_51469().method_8652(blockPosInFront, class_2246.field_10566.method_9564(), 3);
                    }
                }
            } else {
                if (this.player.method_31477() == this.lastKnownEntity.method_31477() && this.player.method_31479() == this.lastKnownEntity.method_31479()) {
                    this.destroyBlock((class_1937)this.player.method_51469(), this.lastKnownEntity.method_24515().method_10074(), (class_1297)this.lastKnownEntity);
                } else {
                    this.destroyBlock((class_1937)this.player.method_51469(), blockPosInFront.method_10084(), (class_1297)this.lastKnownEntity);
                    this.destroyBlock((class_1937)this.player.method_51469(), blockPosInFront, (class_1297)this.lastKnownEntity);
                    this.destroyBlock((class_1937)this.player.method_51469(), blockPosInFront.method_10074(), (class_1297)this.lastKnownEntity);
                }
                if (this.player.method_51469().method_22347(blockPosInFront.method_10087(2))) {
                    this.player.method_51469().method_8652(blockPosInFront.method_10087(2), class_2246.field_10566.method_9564(), 3);
                }
            }
        }
    }

    private void destroyBlock(class_1937 level, class_2338 pos, class_1297 entity) {
        if (level.method_8320(pos).method_26204() != class_2246.field_9987) {
            level.method_8651(pos, false, entity);
        }
    }

    public boolean isEntityPosLoaded() {
        return this.player.method_51469().method_67505(new class_1923(class_4076.method_42615((double)this.entityPosition.method_10216()), class_4076.method_42615((double)this.entityPosition.method_10215())));
    }

    public void simulateEntityMovement() {
        if (this.lastKnownEntity == null) {
            this.entityPosition = this.entityPosition.method_1019(this.player.method_19538().method_1020(this.entityPosition).method_1029());
        }
    }

    public boolean setLastKnownEntity(TheEntity entity) {
        if (this.lastKnownEntityId == entity.method_5628()) {
            this.lastKnownEntity = entity;
            this.lastKnownEntityId = entity.method_5628();
            this.entityPosition = entity.method_19538();
            return true;
        }
        return false;
    }

    public void removeEntity(TheEntity entity) {
        if (entity.method_5628() == this.lastKnownEntityId) {
            this.lastKnownEntity = null;
            this.lastKnownEntityId = -1;
        }
    }

    public boolean isCurseActive() {
        return this.curseActive;
    }

    public class_243 getEntityPosition() {
        if (this.lastKnownEntity != null) {
            this.entityPosition = this.lastKnownEntity.method_19538();
        }
        return this.entityPosition;
    }

    public double getEntityDistance(class_243 pos) {
        return this.entityPosition != null ? this.entityPosition.method_1022(pos) : -1.0;
    }

    public UUID getInfectedBy() {
        return this.infectedBy;
    }

    public static CursePlayerHandler get(class_3222 player) {
        if (player instanceof Curseable) {
            Curseable curseable = (Curseable)player;
            return curseable.it_follows$getCurseHandler();
        }
        return null;
    }

    public static interface Curseable {
        public CursePlayerHandler it_follows$getCurseHandler();
    }
}

