/*
 * Decompiled with CFR 0.152.
 */
package com.weido.create_bb.data.math;

import com.weido.create_bb.data.math.MathCalculations;
import net.createmod.catnip.math.AngleHelper;
import net.minecraft.util.Mth;

public class RodCalculations {
    public static float[] calculateGear(float wheelAngle, WalschaertsParameters params) {
        float a_main = AngleHelper.rad((double)wheelAngle);
        float a_eccentric = -AngleHelper.rad((double)(wheelAngle + 90.0f));
        MathCalculations.Point eccentricCrank = new MathCalculations.Point(params.eccentricCrankRadius() * Mth.m_14031_((float)a_eccentric), params.eccentricCrankRadius() * Mth.m_14089_((float)a_eccentric));
        MathCalculations.Point mainCrank = new MathCalculations.Point(params.mainCrankRadius() * Mth.m_14031_((float)a_main), params.mainCrankRadius() * Mth.m_14089_((float)a_main));
        MathCalculations.Point mainRodEndPoint = MathCalculations.calculateXIntersection(mainCrank, params.mainRodLength(), 0.0f, false);
        MathCalculations.Point expansionLinkPivot = new MathCalculations.Point(params.expansionLinkX(), params.expansionLinkY());
        MathCalculations.Point expansionLinkEndPoint = MathCalculations.calculateIntersection(eccentricCrank, params.eccentricRod(), expansionLinkPivot, params.expansionLink(), true);
        MathCalculations.Point unionLinkStartPoint = new MathCalculations.Point(-mainRodEndPoint.x(), mainRodEndPoint.y() - params.dropLink());
        MathCalculations.Point radiusRodStartPoint = MathCalculations.calculateConnectPoint(expansionLinkEndPoint, expansionLinkPivot, params.radiusConnect());
        MathCalculations.Point valveInitialPoint = new MathCalculations.Point(params.expansionLinkX(), params.radiusConnect());
        MathCalculations.Point initialValvePoint = MathCalculations.calculateXIntersection(valveInitialPoint, params.radiusRod(), params.valveY(), true);
        float leftBound = initialValvePoint.x() - params.combinationLeverUpper();
        float rightBound = initialValvePoint.x() + params.combinationLeverUpper();
        float bestX = initialValvePoint.x();
        float minDistance = Float.MAX_VALUE;
        for (int i = 0; i < 10; ++i) {
            float rightDistance;
            float leftX = (2.0f * leftBound + rightBound) / 3.0f;
            float rightX = (leftBound + 2.0f * rightBound) / 3.0f;
            float leftDistance = RodCalculations.calculateValvePosition(leftX, params.valveY(), unionLinkStartPoint, params, radiusRodStartPoint);
            if (leftDistance < (rightDistance = RodCalculations.calculateValvePosition(rightX, params.valveY(), unionLinkStartPoint, params, radiusRodStartPoint))) {
                rightBound = rightX;
                if (!(leftDistance < minDistance)) continue;
                minDistance = leftDistance;
                bestX = leftX;
                continue;
            }
            leftBound = leftX;
            if (!(rightDistance < minDistance)) continue;
            minDistance = rightDistance;
            bestX = rightX;
        }
        MathCalculations.Point valveCalculationPoint = new MathCalculations.Point(bestX, params.valveY());
        MathCalculations.Point unionLinkCalculationEnd = MathCalculations.calculateIntersection(unionLinkStartPoint, params.unionLink(), valveCalculationPoint, params.combinationLeverLower(), true);
        MathCalculations.Point radiusRodCalculationEnd = MathCalculations.calculateIntersection(radiusRodStartPoint, params.radiusRod(), valveCalculationPoint, params.combinationLeverUpper(), false);
        return new float[]{mainRodEndPoint.x(), expansionLinkEndPoint.x(), expansionLinkEndPoint.y(), radiusRodStartPoint.x(), radiusRodStartPoint.y(), unionLinkStartPoint.x(), valveCalculationPoint.x(), (float)Math.PI - MathCalculations.calculateAngle(mainRodEndPoint, mainCrank), MathCalculations.calculateAngle(expansionLinkEndPoint, eccentricCrank), 1.5707964f + MathCalculations.calculateAngle(expansionLinkEndPoint, expansionLinkPivot), (float)Math.PI + MathCalculations.calculateAngle(unionLinkStartPoint, unionLinkCalculationEnd), (float)Math.PI + MathCalculations.calculateAngle(radiusRodStartPoint, radiusRodCalculationEnd), -1.5707964f + MathCalculations.calculateAngle(valveCalculationPoint, unionLinkCalculationEnd)};
    }

    private static float calculateValvePosition(float x, float y, MathCalculations.Point unionLinkStartPoint, WalschaertsParameters params, MathCalculations.Point radiusRodStartPoint) {
        MathCalculations.Point valvePos = new MathCalculations.Point(x, y);
        MathCalculations.Point unionLinkEnd = MathCalculations.calculateIntersection(unionLinkStartPoint, params.unionLink(), valvePos, params.combinationLeverLower(), true);
        MathCalculations.Point radiusRodEnd = MathCalculations.calculateIntersection(radiusRodStartPoint, params.radiusRod(), valvePos, params.combinationLeverUpper(), false);
        MathCalculations.Point combinationLeverEnd = MathCalculations.calculateConnectPoint(unionLinkEnd, valvePos, -params.combinationLeverUpper());
        return MathCalculations.calculateDistance(radiusRodEnd, combinationLeverEnd);
    }

    public record WalschaertsParameters(float eccentricRod, float expansionLink, float eccentricCrankRadius, float expansionLinkX, float expansionLinkY, float radiusConnect, float mainCrankRadius, float mainRodLength, float radiusRod, float combinationLever, float combinationLeverUpper, float combinationLeverLower, float unionLink, float dropLink, float valveY, float pistonDistance, float yOffset, float xOffset) {
    }
}

