/*
 * Decompiled with CFR 0.152.
 */
package com.weido.create_bb.data.menu.Entry;

import com.simibubi.create.content.trains.bogey.BogeyStyle;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import net.minecraft.network.chat.Component;
import org.jetbrains.annotations.NotNull;

public record StyleEntry(@NotNull BogeyStyle bogeyStyle, Variant variant, ValveGear valveGear, Type type, int axleCount, Length length) {
    private static final Map<StyleKey, StyleEntry> STYLES = new ConcurrentHashMap<StyleKey, StyleEntry>();

    public static StyleEntry getOrCreate(@NotNull BogeyStyle bogeyStyle, Variant variant, ValveGear valveGear, Type type, int axleCount, Length length) {
        StyleKey key = new StyleKey(bogeyStyle, variant, valveGear, type, axleCount, length);
        return STYLES.computeIfAbsent(key, k -> new StyleEntry(k.bogeyStyle(), k.variant(), k.valveGear(), k.type(), k.axleCount(), k.length()));
    }

    public static enum Variant {
        STANDARD("create_bb.variant.standard"),
        LONG("create_bb.variant.long"),
        SHORT("create_bb.variant.short"),
        TRAILING("create_bb.variant.trailing");

        private final String translationKey;

        private Variant(String translationKey) {
            this.translationKey = translationKey;
        }

        public Component getDisplayText() {
            return Component.m_237115_((String)this.translationKey);
        }
    }

    public static enum ValveGear {
        NONE("create_bb.valve_gear.none"),
        WALSCHAERTS("create_bb.valve_gear.walschaerts"),
        GEARLESS("create_bb.valve_gear.gearless"),
        PISTONLESS("create_bb.valve_gear.pistonless"),
        RODLESS("create_bb.valve_gear.rodless"),
        ROTARY_POPPET("create_bb.valve_gear.rotary_poppet"),
        SCOTCH_YOKE("create_bb.valve_gear.scotch_yoke");

        private final String translationKey;

        private ValveGear(String translationKey) {
            this.translationKey = translationKey;
        }

        public Component getDisplayText() {
            return Component.m_237115_((String)this.translationKey);
        }
    }

    public static enum Type {
        DRIVER("create_bb.type.driver"),
        TRUCK("create_bb.type.truck");

        private final String translationKey;

        private Type(String translationKey) {
            this.translationKey = translationKey;
        }

        public Component getDisplayText() {
            return Component.m_237115_((String)this.translationKey);
        }
    }

    public static enum Length {
        NORMAL("create_bb.length.standard"),
        EXTENDED("create_bb.length.extended"),
        SPACED("create_bb.length.spaced"),
        OFFSET("create_bb.length.offset");

        private final String translationKey;

        private Length(String translationKey) {
            this.translationKey = translationKey;
        }

        public Component getDisplayText() {
            return Component.m_237115_((String)this.translationKey);
        }
    }

    public record StyleKey(BogeyStyle bogeyStyle, Variant variant, ValveGear valveGear, Type type, int axleCount, Length length) {
    }
}

