/*
 * Decompiled with CFR 0.152.
 */
package com.weido.create_bb.registry;

import com.simibubi.create.foundation.networking.SimplePacketBase;
import com.weido.create_bb.data.packets.BogieMenuPacket;
import com.weido.create_bb.data.packets.BogieStylePacket;
import java.util.function.BiConsumer;
import java.util.function.Function;
import java.util.function.Supplier;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.resources.ResourceLocation;
import net.minecraftforge.network.NetworkDirection;
import net.minecraftforge.network.NetworkEvent;
import net.minecraftforge.network.NetworkRegistry;
import net.minecraftforge.network.simple.SimpleChannel;

public enum BogiePackets {
    S_BOGIE_MENU(BogieMenuPacket.class, BogieMenuPacket::new, NetworkDirection.PLAY_TO_CLIENT),
    C_BOGIE_STYLE(BogieStylePacket.class, BogieStylePacket::new, NetworkDirection.PLAY_TO_SERVER);

    public static final ResourceLocation CHANNEL_NAME;
    public static final int NETWORK_VERSION = 1;
    public static final String NETWORK_VERSION_STR;
    private static SimpleChannel channel;
    private PacketType<?> packetType;

    private <T extends SimplePacketBase> BogiePackets(Class<T> type, Function<FriendlyByteBuf, T> factory, NetworkDirection direction) {
        this.packetType = new PacketType<T>(type, factory, direction);
    }

    public static void registerPackets() {
        channel = NetworkRegistry.ChannelBuilder.named((ResourceLocation)CHANNEL_NAME).serverAcceptedVersions(NETWORK_VERSION_STR::equals).clientAcceptedVersions(NETWORK_VERSION_STR::equals).networkProtocolVersion(() -> NETWORK_VERSION_STR).simpleChannel();
        for (BogiePackets packet : BogiePackets.values()) {
            packet.packetType.register();
        }
    }

    public static SimpleChannel getChannel() {
        return channel;
    }

    static {
        CHANNEL_NAME = new ResourceLocation("create_bb", "bogie");
        NETWORK_VERSION_STR = String.valueOf(1);
    }

    private static class PacketType<T extends SimplePacketBase> {
        private static int index = 0;
        private BiConsumer<T, FriendlyByteBuf> encoder = SimplePacketBase::write;
        private Function<FriendlyByteBuf, T> decoder;
        private BiConsumer<T, Supplier<NetworkEvent.Context>> handler;
        private Class<T> type;
        private NetworkDirection direction;

        private PacketType(Class<T> type, Function<FriendlyByteBuf, T> factory, NetworkDirection direction) {
            this.decoder = factory;
            this.handler = (packet, contextSupplier) -> {
                NetworkEvent.Context context = (NetworkEvent.Context)contextSupplier.get();
                if (packet.handle(context)) {
                    context.setPacketHandled(true);
                }
            };
            this.type = type;
            this.direction = direction;
        }

        private void register() {
            BogiePackets.getChannel().messageBuilder(this.type, index++, this.direction).encoder(this.encoder).decoder(this.decoder).consumerNetworkThread(this.handler).add();
        }
    }
}

