/*
 * Decompiled with CFR 0.152.
 */
package dev.atrox.lightnewbie.Command;

import dev.atrox.lightnewbie.Command.DiscordCommand;
import dev.atrox.lightnewbie.Command.HelpCommand;
import dev.atrox.lightnewbie.Command.ReloadCommand;
import dev.atrox.lightnewbie.LightNewbie;
import java.util.HashMap;
import java.util.Map;
import java.util.UUID;
import net.md_5.bungee.api.chat.BaseComponent;
import net.md_5.bungee.api.chat.ClickEvent;
import net.md_5.bungee.api.chat.HoverEvent;
import net.md_5.bungee.api.chat.TextComponent;
import org.bukkit.Bukkit;
import org.bukkit.Sound;
import org.bukkit.command.Command;
import org.bukkit.command.CommandExecutor;
import org.bukkit.command.CommandSender;
import org.bukkit.entity.Player;

public class LightNewbieCommand
implements CommandExecutor {
    private final LightNewbie plugin;
    private final Map<UUID, Long> pendingConfirmations = new HashMap<UUID, Long>();

    public LightNewbieCommand(LightNewbie plugin) {
        this.plugin = plugin;
    }

    public boolean onCommand(CommandSender sender, Command command, String label, String[] args) {
        String subCommand;
        if (args.length == 0) {
            return new HelpCommand(this.plugin).onCommand(sender, command, label, args);
        }
        switch (subCommand = args[0].toLowerCase()) {
            case "enable": {
                return this.handleEnable(sender, args);
            }
            case "disable": {
                return this.handleDisable(sender);
            }
            case "disableplayer": {
                return this.handleDisablePlayer(sender, args);
            }
            case "info": {
                return this.handleInfo(sender, args);
            }
            case "give": {
                return this.handleGive(sender, args);
            }
            case "confirm": {
                return this.handleConfirm(sender);
            }
            case "cancel": {
                return this.handleCancel(sender);
            }
            case "reload": {
                return new ReloadCommand(this.plugin).onCommand(sender, command, label, args);
            }
            case "discord": {
                return new DiscordCommand().onCommand(sender, command, label, args);
            }
            case "help": {
                return new HelpCommand(this.plugin).onCommand(sender, command, label, args);
            }
        }
        sender.sendMessage(this.plugin.getPrefixManager().formatMessage("usage"));
        return true;
    }

    private boolean handleEnable(CommandSender sender, String[] args) {
        if (!sender.hasPermission("lightnewbie.enable")) {
            sender.sendMessage(this.plugin.getPrefixManager().formatMessage("no-permission"));
            return true;
        }
        if (args.length < 2) {
            sender.sendMessage(this.plugin.getPrefixManager().formatMessage("enable-usage"));
            return true;
        }
        Player enablePlayer = Bukkit.getPlayer((String)args[1]);
        if (enablePlayer == null) {
            sender.sendMessage(this.plugin.getPrefixManager().formatMessage("player-not-found"));
            return true;
        }
        long defaultProtectionDuration = this.plugin.getConfig().getLong("default-protection-duration", 3600L);
        this.plugin.giveProtection(enablePlayer.getUniqueId(), defaultProtectionDuration, true);
        sender.sendMessage(this.plugin.getPrefixManager().formatMessage("protection-enabled").replace("{player}", enablePlayer.getName()));
        enablePlayer.sendMessage(this.plugin.getPrefixManager().formatMessage("protection-enabled-self"));
        return true;
    }

    private boolean handleDisable(CommandSender sender) {
        if (!sender.hasPermission("lightnewbie.disable")) {
            sender.sendMessage(this.plugin.getPrefixManager().formatMessage("no-permission"));
            return true;
        }
        if (!(sender instanceof Player)) {
            sender.sendMessage(this.plugin.getPrefixManager().formatMessage("only-players"));
            return true;
        }
        Player player = (Player)sender;
        UUID playerId = player.getUniqueId();
        if (!this.plugin.isProtected(playerId)) {
            player.sendMessage(this.plugin.getPrefixManager().formatMessage("not-protected"));
            return true;
        }
        if (this.plugin.getConfig().getBoolean("disable-confirmation.enabled", true)) {
            this.sendConfirmationRequest(player);
            this.pendingConfirmations.put(playerId, System.currentTimeMillis());
            return true;
        }
        this.plugin.disableProtection(playerId, true);
        player.sendMessage(this.plugin.getPrefixManager().formatMessage("protection-disabled"));
        return true;
    }

    private void sendConfirmationRequest(Player player) {
        if (this.plugin.getConfig().getBoolean("disable-confirmation.sound.enabled", true)) {
            String soundName = this.plugin.getConfig().getString("disable-confirmation.sound.type", "BLOCK_NOTE_BLOCK_PLING");
            try {
                Sound sound = Sound.valueOf((String)soundName);
                player.playSound(player.getLocation(), sound, 1.0f, 1.0f);
            }
            catch (IllegalArgumentException e) {
                this.plugin.getLogger().warning("Invalid sound in config: " + soundName);
                player.playSound(player.getLocation(), Sound.BLOCK_NOTE_BLOCK_PLING, 1.0f, 1.0f);
            }
        }
        String title = this.plugin.getPrefixManager().formatMessage("disable-confirmation.title");
        String subtitle = this.plugin.getPrefixManager().formatMessage("disable-confirmation.subtitle");
        player.sendTitle(title, subtitle, 10, 70, 20);
        String message = this.plugin.getPrefixManager().formatMessage("disable-confirmation.message").replace("{time}", String.valueOf(this.plugin.getConfig().getInt("disable-confirmation.timeout", 15)));
        player.sendMessage(message);
        if (this.plugin.getConfig().getBoolean("disable-confirmation.clickable.enabled", true)) {
            TextComponent confirmComponent = new TextComponent(this.plugin.getPrefixManager().formatMessage("disable-confirmation.clickable.confirm.text"));
            confirmComponent.setClickEvent(new ClickEvent(ClickEvent.Action.RUN_COMMAND, "/lightnewbie confirm"));
            confirmComponent.setHoverEvent(new HoverEvent(HoverEvent.Action.SHOW_TEXT, TextComponent.fromLegacyText((String)this.plugin.getPrefixManager().formatMessage("disable-confirmation.clickable.confirm.hover"))));
            TextComponent cancelComponent = new TextComponent(this.plugin.getPrefixManager().formatMessage("disable-confirmation.clickable.cancel.text"));
            cancelComponent.setClickEvent(new ClickEvent(ClickEvent.Action.RUN_COMMAND, "/lightnewbie cancel"));
            cancelComponent.setHoverEvent(new HoverEvent(HoverEvent.Action.SHOW_TEXT, TextComponent.fromLegacyText((String)this.plugin.getPrefixManager().formatMessage("disable-confirmation.clickable.cancel.hover"))));
            TextComponent messageComponent = new TextComponent(this.plugin.getPrefixManager().formatMessage("disable-confirmation.clickable.prefix"));
            messageComponent.addExtra((BaseComponent)confirmComponent);
            messageComponent.addExtra(this.plugin.getPrefixManager().formatMessage("disable-confirmation.clickable.separator"));
            messageComponent.addExtra((BaseComponent)cancelComponent);
            messageComponent.addExtra(this.plugin.getPrefixManager().formatMessage("disable-confirmation.clickable.suffix"));
            player.spigot().sendMessage((BaseComponent)messageComponent);
        }
    }

    private boolean handleConfirm(CommandSender sender) {
        if (!(sender instanceof Player)) {
            sender.sendMessage(this.plugin.getPrefixManager().formatMessage("only-players"));
            return true;
        }
        Player player = (Player)sender;
        UUID playerId = player.getUniqueId();
        if (!this.pendingConfirmations.containsKey(playerId)) {
            sender.sendMessage(this.plugin.getPrefixManager().formatMessage("disable-confirmation.no-pending"));
            return true;
        }
        long requestTime = this.pendingConfirmations.get(playerId);
        long timeout = (long)this.plugin.getConfig().getInt("disable-confirmation.timeout", 15) * 1000L;
        if (System.currentTimeMillis() - requestTime > timeout) {
            sender.sendMessage(this.plugin.getPrefixManager().formatMessage("disable-confirmation.timeout"));
            this.pendingConfirmations.remove(playerId);
            return true;
        }
        this.pendingConfirmations.remove(playerId);
        this.plugin.disableProtection(playerId, true);
        player.sendMessage(this.plugin.getPrefixManager().formatMessage("protection-disabled"));
        return true;
    }

    private boolean handleCancel(CommandSender sender) {
        if (!(sender instanceof Player)) {
            sender.sendMessage(this.plugin.getPrefixManager().formatMessage("only-players"));
            return true;
        }
        Player player = (Player)sender;
        UUID playerId = player.getUniqueId();
        if (!this.pendingConfirmations.containsKey(playerId)) {
            sender.sendMessage(this.plugin.getPrefixManager().formatMessage("disable-confirmation.no-pending"));
            return true;
        }
        this.pendingConfirmations.remove(playerId);
        player.sendMessage(this.plugin.getPrefixManager().formatMessage("disable-confirmation.cancelled"));
        return true;
    }

    private boolean handleDisablePlayer(CommandSender sender, String[] args) {
        if (!sender.hasPermission("lightnewbie.disableplayer")) {
            sender.sendMessage(this.plugin.getPrefixManager().formatMessage("no-permission"));
            return true;
        }
        if (args.length < 2) {
            sender.sendMessage(this.plugin.getPrefixManager().formatMessage("disableplayer-usage"));
            return true;
        }
        Player disablePlayer = Bukkit.getPlayer((String)args[1]);
        if (disablePlayer == null) {
            sender.sendMessage(this.plugin.getPrefixManager().formatMessage("player-not-found"));
            return true;
        }
        this.plugin.disableProtection(disablePlayer.getUniqueId(), true);
        sender.sendMessage(this.plugin.getPrefixManager().formatMessage("protection-disabled-player").replace("{player}", disablePlayer.getName()));
        disablePlayer.sendMessage(this.plugin.getPrefixManager().formatMessage("protection-disabled"));
        return true;
    }

    private boolean handleInfo(CommandSender sender, String[] args) {
        if (!sender.hasPermission("lightnewbie.info")) {
            sender.sendMessage(this.plugin.getPrefixManager().formatMessage("no-permission"));
            return true;
        }
        if (args.length < 2) {
            sender.sendMessage(this.plugin.getPrefixManager().formatMessage("info-usage"));
            return true;
        }
        Player infoPlayer = Bukkit.getPlayer((String)args[1]);
        if (infoPlayer == null) {
            sender.sendMessage(this.plugin.getPrefixManager().formatMessage("player-not-found"));
            return true;
        }
        UUID infoPlayerId = infoPlayer.getUniqueId();
        if (this.plugin.isProtected(infoPlayerId)) {
            long remainingTime = this.plugin.getRemainingProtection(infoPlayerId);
            sender.sendMessage(this.plugin.getPrefixManager().formatMessage("protection-status").replace("{player}", infoPlayer.getName()).replace("{time}", this.formatTime(remainingTime)));
        } else {
            sender.sendMessage(this.plugin.getPrefixManager().formatMessage("not-protected-player").replace("{player}", infoPlayer.getName()));
        }
        return true;
    }

    private boolean handleGive(CommandSender sender, String[] args) {
        if (!sender.hasPermission("lightnewbie.give")) {
            sender.sendMessage(this.plugin.getPrefixManager().formatMessage("no-permission"));
            return true;
        }
        if (args.length < 2) {
            sender.sendMessage(this.plugin.getPrefixManager().formatMessage("give-usage"));
            return true;
        }
        Player givePlayer = Bukkit.getPlayer((String)args[1]);
        if (givePlayer == null) {
            sender.sendMessage(this.plugin.getPrefixManager().formatMessage("player-not-found"));
            return true;
        }
        long defaultProtectionDuration = this.plugin.getConfig().getLong("default-protection-duration", 3600L);
        this.plugin.giveProtection(givePlayer.getUniqueId(), defaultProtectionDuration, true);
        sender.sendMessage(this.plugin.getPrefixManager().formatMessage("protection-given").replace("{player}", givePlayer.getName()));
        givePlayer.sendMessage(this.plugin.getPrefixManager().formatMessage("protection-given-self"));
        return true;
    }

    private String formatTime(long seconds) {
        long hours = seconds / 3600L;
        long minutes = seconds % 3600L / 60L;
        long remainingSeconds = seconds % 60L;
        String hourText = this.plugin.getConfig().getString("time-format.h", "h");
        String minuteText = this.plugin.getConfig().getString("time-format.m", "m");
        String secondText = this.plugin.getConfig().getString("time-format.s", "s");
        return String.format("%02d%s %02d%s %02d%s", hours, hourText, minutes, minuteText, remainingSeconds, secondText);
    }

    public Map<UUID, Long> getPendingConfirmations() {
        return this.pendingConfirmations;
    }
}

