/*
 * Decompiled with CFR 0.152.
 */
package dev.atrox.lightnewbie.Data;

import dev.atrox.lightnewbie.LightNewbie;
import java.io.File;
import java.io.IOException;
import java.util.UUID;
import org.bukkit.configuration.file.YamlConfiguration;

public class PlayerDataManager {
    private final LightNewbie plugin;
    private final File dataFolder;

    public PlayerDataManager(LightNewbie plugin) {
        this.plugin = plugin;
        this.dataFolder = new File(plugin.getDataFolder(), "playerdata");
        if (!this.dataFolder.exists() && !this.dataFolder.mkdirs()) {
            plugin.getLogger().severe("Could not create player data folder.");
        }
    }

    public void savePlayerData(UUID playerId, long remainingTime, boolean manuallyDisabled) {
        File playerFile = new File(this.dataFolder, playerId.toString() + ".yml");
        YamlConfiguration config = YamlConfiguration.loadConfiguration((File)playerFile);
        config.set("player-uuid", (Object)playerId.toString());
        config.set("protection-remaining-time", (Object)remainingTime);
        config.set("manually-disabled", (Object)manuallyDisabled);
        try {
            config.save(playerFile);
        }
        catch (IOException e) {
            this.plugin.getLogger().severe("Could not save data for player " + playerId + ": " + e.getMessage());
        }
    }

    public ProtectionData loadPlayerData(UUID playerId) {
        File playerFile = new File(this.dataFolder, playerId.toString() + ".yml");
        if (!playerFile.exists()) {
            return new ProtectionData(0L, false);
        }
        YamlConfiguration config = YamlConfiguration.loadConfiguration((File)playerFile);
        long remainingTime = config.getLong("protection-remaining-time", 0L);
        boolean manuallyDisabled = config.getBoolean("manually-disabled", false);
        return new ProtectionData(remainingTime, manuallyDisabled);
    }

    public static class ProtectionData {
        private final long remainingTime;
        private final boolean manuallyDisabled;

        public ProtectionData(long remainingTime, boolean manuallyDisabled) {
            this.remainingTime = remainingTime;
            this.manuallyDisabled = manuallyDisabled;
        }

        public long getRemainingTime() {
            return this.remainingTime;
        }

        public boolean isManuallyDisabled() {
            return this.manuallyDisabled;
        }
    }
}

