/*
 * Decompiled with CFR 0.152.
 */
package dev.atrox.lightnewbie;

import dev.atrox.lightnewbie.Command.LightNewbieCommand;
import dev.atrox.lightnewbie.Command.LightNewbieTabCompleter;
import dev.atrox.lightnewbie.Data.PlayerDataManager;
import dev.atrox.lightnewbie.HexColor;
import dev.atrox.lightnewbie.Metrics;
import dev.atrox.lightnewbie.Newbie.PlayerEventListener;
import dev.atrox.lightnewbie.Newbie.ProtectionReminderTask;
import dev.atrox.lightnewbie.PrefixManager;
import dev.atrox.lightnewbie.UpdateChecker.UpdateChecker;
import java.io.File;
import java.util.HashMap;
import java.util.Map;
import java.util.UUID;
import net.md_5.bungee.api.ChatMessageType;
import net.md_5.bungee.api.chat.BaseComponent;
import net.md_5.bungee.api.chat.TextComponent;
import org.bukkit.Bukkit;
import org.bukkit.command.CommandExecutor;
import org.bukkit.command.TabCompleter;
import org.bukkit.configuration.file.FileConfiguration;
import org.bukkit.configuration.file.YamlConfiguration;
import org.bukkit.entity.Player;
import org.bukkit.event.Listener;
import org.bukkit.plugin.Plugin;
import org.bukkit.plugin.java.JavaPlugin;

public class LightNewbie
extends JavaPlugin {
    private final Map<UUID, Long> protectedPlayers = new HashMap<UUID, Long>();
    private final Map<UUID, Boolean> manuallyDisabledPlayers = new HashMap<UUID, Boolean>();
    private PlayerDataManager playerDataManager;
    private UpdateChecker updateChecker;
    private FileConfiguration messagesConfig;
    private File messagesFile;
    private PrefixManager prefixManager;

    public void onEnable() {
        this.saveDefaultConfig();
        this.loadMessagesConfig();
        this.prefixManager = new PrefixManager(this);
        this.playerDataManager = new PlayerDataManager(this);
        this.getServer().getPluginManager().registerEvents((Listener)new PlayerEventListener(this), (Plugin)this);
        this.getCommand("lightnewbie").setExecutor((CommandExecutor)new LightNewbieCommand(this));
        this.getCommand("lightnewbie").setTabCompleter((TabCompleter)new LightNewbieTabCompleter());
        int pluginId = 23983;
        Metrics metrics = new Metrics((Plugin)this, pluginId);
        for (Player player : this.getServer().getOnlinePlayers()) {
            PlayerDataManager.ProtectionData data = this.playerDataManager.loadPlayerData(player.getUniqueId());
            if (data.getRemainingTime() <= 0L || data.isManuallyDisabled()) continue;
            this.giveProtection(player.getUniqueId(), data.getRemainingTime(), false);
        }
        this.updateChecker = new UpdateChecker(this, 117074);
        this.updateChecker.checkOnStartup();
        Bukkit.getScheduler().scheduleSyncRepeatingTask((Plugin)this, () -> {
            long timeout = (long)this.getConfig().getInt("disable-confirmation.timeout", 15) * 1000L;
            long currentTime = System.currentTimeMillis();
            LightNewbieCommand command = (LightNewbieCommand)this.getCommand("lightnewbie").getExecutor();
            command.getPendingConfirmations().entrySet().removeIf(entry -> {
                if (currentTime - (Long)entry.getValue() > timeout) {
                    Player player = Bukkit.getPlayer((UUID)((UUID)entry.getKey()));
                    if (player != null) {
                        player.sendMessage(HexColor.translateAlternateColorCodes('&', this.prefixManager.formatMessage("disable-confirmation.timeout")));
                    }
                    return true;
                }
                return false;
            });
        }, 20L, 20L);
        this.getLogger().info("LightNewbie plugin has been enabled!");
    }

    public void onDisable() {
        for (UUID playerId : this.protectedPlayers.keySet()) {
            long remainingTime = this.getRemainingProtection(playerId);
            boolean manuallyDisabled = this.wasManuallyDisabled(playerId);
            this.playerDataManager.savePlayerData(playerId, remainingTime, manuallyDisabled);
        }
        this.getLogger().info("LightNewbie plugin has been disabled!");
    }

    public boolean isProtected(UUID playerId) {
        return this.protectedPlayers.containsKey(playerId) && this.protectedPlayers.get(playerId) > System.currentTimeMillis() && !this.wasManuallyDisabled(playerId);
    }

    public long getRemainingProtection(UUID playerId) {
        if (this.protectedPlayers.containsKey(playerId)) {
            long remainingTime = (this.protectedPlayers.get(playerId) - System.currentTimeMillis()) / 1000L;
            return Math.max(remainingTime, 0L);
        }
        return 0L;
    }

    public boolean wasManuallyDisabled(UUID playerId) {
        return this.manuallyDisabledPlayers.getOrDefault(playerId, false);
    }

    public void disableProtection(UUID playerId) {
        this.disableProtection(playerId, false);
    }

    public void disableProtection(UUID playerId, boolean permanent) {
        this.protectedPlayers.remove(playerId);
        if (permanent) {
            this.manuallyDisabledPlayers.put(playerId, true);
        } else {
            this.manuallyDisabledPlayers.remove(playerId);
        }
    }

    public void giveProtection(UUID playerId, long duration) {
        this.giveProtection(playerId, duration, false);
    }

    public void giveProtection(UUID playerId, long duration, boolean force) {
        if (force || !this.wasManuallyDisabled(playerId)) {
            long protectionEndTime = System.currentTimeMillis() + duration * 1000L;
            this.protectedPlayers.put(playerId, protectionEndTime);
            this.manuallyDisabledPlayers.remove(playerId);
            Player player = this.getServer().getPlayer(playerId);
            if (player != null) {
                String message = this.prefixManager.formatMessage("protection-enabled").replace("{time}", String.valueOf(duration));
                this.sendMessage(player, message);
                new ProtectionReminderTask(playerId, this).runTaskTimer((Plugin)this, 0L, 20L);
            }
        }
    }

    public void sendMessage(Player player, String message) {
        boolean useActionBar = this.getConfig().getBoolean("use-action-bar", true);
        if (useActionBar) {
            player.spigot().sendMessage(ChatMessageType.ACTION_BAR, (BaseComponent)new TextComponent(HexColor.translateAlternateColorCodes('&', message)));
        } else {
            player.sendMessage(HexColor.translateAlternateColorCodes('&', message));
        }
    }

    public PlayerDataManager getPlayerDataManager() {
        return this.playerDataManager;
    }

    public FileConfiguration getMessages() {
        return this.messagesConfig;
    }

    public void reloadMessages() {
        this.loadMessagesConfig();
        this.prefixManager.reload();
    }

    private void loadMessagesConfig() {
        this.messagesFile = new File(this.getDataFolder(), "messages.yml");
        if (!this.messagesFile.exists()) {
            this.saveResource("messages.yml", false);
        }
        this.messagesConfig = YamlConfiguration.loadConfiguration((File)this.messagesFile);
    }

    public PrefixManager getPrefixManager() {
        return this.prefixManager;
    }
}

