/*
 * Decompiled with CFR 0.152.
 */
package dev.atrox.lightnewbie.Newbie;

import dev.atrox.lightnewbie.Data.PlayerDataManager;
import dev.atrox.lightnewbie.HexColor;
import dev.atrox.lightnewbie.LightNewbie;
import java.util.HashMap;
import java.util.List;
import java.util.UUID;
import net.md_5.bungee.api.ChatMessageType;
import net.md_5.bungee.api.chat.TextComponent;
import org.bukkit.Sound;
import org.bukkit.World;
import org.bukkit.entity.Animals;
import org.bukkit.entity.Monster;
import org.bukkit.entity.Player;
import org.bukkit.event.EventHandler;
import org.bukkit.event.Listener;
import org.bukkit.event.entity.EntityDamageByEntityEvent;
import org.bukkit.event.entity.EntityDamageEvent;
import org.bukkit.event.entity.EntityPickupItemEvent;
import org.bukkit.event.player.PlayerJoinEvent;
import org.bukkit.event.player.PlayerPortalEvent;
import org.bukkit.event.player.PlayerQuitEvent;
import org.bukkit.event.player.PlayerTeleportEvent;
import org.bukkit.util.Vector;

public class PlayerEventListener
implements Listener {
    private final LightNewbie plugin;
    private final HashMap<UUID, Long> lastPickupMessageTime = new HashMap();
    private final HashMap<UUID, Long> lastProtectionMessageTime = new HashMap();
    private final HashMap<UUID, Long> lastAttackMessageTime = new HashMap();
    private final HashMap<UUID, Long> lastProtectedAttackWarningTime = new HashMap();

    public PlayerEventListener(LightNewbie plugin) {
        this.plugin = plugin;
    }

    @EventHandler
    public void onPlayerJoin(PlayerJoinEvent event) {
        Player player = event.getPlayer();
        UUID playerId = player.getUniqueId();
        PlayerDataManager.ProtectionData data = this.plugin.getPlayerDataManager().loadPlayerData(playerId);
        if (!player.hasPlayedBefore()) {
            long protectionTime = this.parseProtectionDuration(this.plugin.getConfig().getString("protection-duration", "5m"));
            this.plugin.giveProtection(playerId, protectionTime, false);
            this.sendTitleAndSound(player, "protection-give-sound", "give-title", protectionTime);
        } else if (data.getRemainingTime() > 0L && !data.isManuallyDisabled()) {
            this.plugin.giveProtection(playerId, data.getRemainingTime(), false);
            player.sendMessage(HexColor.translateAlternateColorCodes('&', this.plugin.getPrefixManager().formatMessage("protection-restored").replace("{time}", this.formatTime(data.getRemainingTime()))));
        }
    }

    @EventHandler
    public void onPlayerQuit(PlayerQuitEvent event) {
        Player player = event.getPlayer();
        UUID playerId = player.getUniqueId();
        if (this.plugin.isProtected(playerId) || this.plugin.wasManuallyDisabled(playerId)) {
            long remainingTime = this.plugin.getRemainingProtection(playerId);
            boolean manuallyDisabled = this.plugin.wasManuallyDisabled(playerId);
            this.plugin.getPlayerDataManager().savePlayerData(playerId, remainingTime, manuallyDisabled);
        }
    }

    @EventHandler
    public void onEntityDamage(EntityDamageEvent event) {
        if (!(event.getEntity() instanceof Player)) {
            return;
        }
        Player player = (Player)event.getEntity();
        UUID playerId = player.getUniqueId();
        if (this.plugin.isProtected(playerId)) {
            EntityDamageByEntityEvent entityEvent;
            EntityDamageEvent.DamageCause cause = event.getCause();
            boolean shouldCancel = true;
            if (!(cause != EntityDamageEvent.DamageCause.ENTITY_EXPLOSION && cause != EntityDamageEvent.DamageCause.BLOCK_EXPLOSION || this.plugin.getConfig().getBoolean("protection-explosion-damage", false))) {
                shouldCancel = false;
            } else if (cause == EntityDamageEvent.DamageCause.ENTITY_ATTACK && event instanceof EntityDamageByEntityEvent && ((entityEvent = (EntityDamageByEntityEvent)event).getDamager() instanceof Monster || entityEvent.getDamager() instanceof Animals) && !this.plugin.getConfig().getBoolean("protection-mob-damage", false)) {
                shouldCancel = false;
            }
            if (shouldCancel) {
                event.setCancelled(true);
            }
        }
    }

    @EventHandler
    public void onEntityDamageByEntity(EntityDamageByEntityEvent event) {
        Player damaged;
        Player damager;
        UUID damagerId;
        if (event.getDamager() instanceof Player && this.plugin.isProtected(damagerId = (damager = (Player)event.getDamager()).getUniqueId())) {
            event.setCancelled(true);
            this.sendAttackProtectionMessage(damager);
            this.playProtectionHitSound(damager);
            return;
        }
        if (event.getEntity() instanceof Player && this.plugin.isProtected((damaged = (Player)event.getEntity()).getUniqueId())) {
            event.setCancelled(true);
            if (event.getDamager() instanceof Player) {
                Player damager2 = (Player)event.getDamager();
                this.sendProtectedAttackWarning(damager2);
                this.playProtectionHitSound(damager2);
            }
        }
    }

    private void playProtectionHitSound(Player player) {
        if (this.plugin.getConfig().getBoolean("protection-hit-sound.enabled", true)) {
            String soundName = this.plugin.getConfig().getString("protection-hit-sound.sound", "ENTITY_ALLAY_ITEM_GIVEN");
            try {
                Sound sound = Sound.valueOf((String)soundName);
                player.playSound(player.getLocation(), sound, 1.0f, 1.5f);
            }
            catch (IllegalArgumentException e) {
                this.plugin.getLogger().warning("Invalid sound in protection-hit-sound config: " + soundName);
                player.playSound(player.getLocation(), Sound.ENTITY_VILLAGER_NO, 1.0f, 1.0f);
            }
        }
    }

    @EventHandler
    public void onEntityPickupItem(EntityPickupItemEvent event) {
        boolean preventPickup;
        Player player;
        UUID playerId;
        if (event.getEntity() instanceof Player && this.plugin.isProtected(playerId = (player = (Player)event.getEntity()).getUniqueId()) && (preventPickup = this.plugin.getConfig().getBoolean("prevent-item-pickup", true))) {
            event.setCancelled(true);
            this.sendPickupProtectionMessage(player);
        }
    }

    @EventHandler
    public void onPlayerTeleport(PlayerTeleportEvent event) {
        World targetWorld;
        Player player = event.getPlayer();
        if (!this.plugin.isProtected(player.getUniqueId())) {
            return;
        }
        if (!this.plugin.getConfig().getBoolean("restricted-worlds.enabled", true)) {
            return;
        }
        List restrictedWorlds = this.plugin.getConfig().getStringList("restricted-worlds.worlds");
        if (restrictedWorlds.contains((targetWorld = event.getTo().getWorld()).getName())) {
            event.setCancelled(true);
            if (this.plugin.getConfig().getBoolean("protection-restricted-world.enabled", true) && this.plugin.getMessages().getBoolean("protection-restricted-world.messages.enabled", true)) {
                this.sendRestrictedWorldMessage(player);
            }
        }
    }

    @EventHandler
    public void onPlayerPortal(PlayerPortalEvent event) {
        World targetWorld;
        Player player = event.getPlayer();
        if (!this.plugin.isProtected(player.getUniqueId())) {
            return;
        }
        if (!this.plugin.getConfig().getBoolean("restricted-worlds.enabled", true)) {
            return;
        }
        List restrictedWorlds = this.plugin.getConfig().getStringList("restricted-worlds.worlds");
        if (restrictedWorlds.contains((targetWorld = event.getTo().getWorld()).getName())) {
            event.setCancelled(true);
            if (this.plugin.getConfig().getBoolean("protection-restricted-world.enabled", true) && this.plugin.getMessages().getBoolean("protection-restricted-world.messages.enabled", true)) {
                this.sendRestrictedWorldMessage(player);
            }
        }
    }

    private void sendRestrictedWorldMessage(Player player) {
        this.playRestrictedWorldSound(player);
        String title = this.plugin.getPrefixManager().formatMessage("protection-restricted-world.title");
        String subtitle = this.plugin.getPrefixManager().formatMessage("protection-restricted-world.subtitle").replace("{time}", this.formatTime(this.plugin.getRemainingProtection(player.getUniqueId())));
        player.sendTitle(HexColor.translateAlternateColorCodes('&', title), HexColor.translateAlternateColorCodes('&', subtitle), 10, 70, 20);
        String actionbar = this.plugin.getPrefixManager().formatMessage("protection-restricted-world.actionbar");
        player.spigot().sendMessage(ChatMessageType.ACTION_BAR, TextComponent.fromLegacyText((String)HexColor.translateAlternateColorCodes('&', actionbar)));
        String message = this.plugin.getPrefixManager().formatMessage("protection-restricted-world.message").replace("{time}", this.formatTime(this.plugin.getRemainingProtection(player.getUniqueId())));
        player.sendMessage(HexColor.translateAlternateColorCodes('&', message));
    }

    private void playRestrictedWorldSound(Player player) {
        if (this.plugin.getConfig().getBoolean("protection-restricted-world-sound.enabled", true)) {
            String soundName = this.plugin.getConfig().getString("protection-restricted-world-sound.sound", "ENTITY_VILLAGER_NO");
            try {
                Sound sound = Sound.valueOf((String)soundName);
                player.playSound(player.getLocation(), sound, 1.0f, 1.0f);
            }
            catch (IllegalArgumentException e) {
                this.plugin.getLogger().warning("Invalid sound in config: " + soundName);
                player.playSound(player.getLocation(), Sound.ENTITY_VILLAGER_NO, 1.0f, 1.0f);
            }
        }
    }

    private boolean isWithinHitbox(Player source, Player target) {
        Vector sourcePos = source.getLocation().toVector();
        Vector targetPos = target.getLocation().toVector();
        if (Math.abs(sourcePos.getX() - targetPos.getX()) > 0.9) {
            return false;
        }
        if (Math.abs(sourcePos.getZ() - targetPos.getZ()) > 0.9) {
            return false;
        }
        return !(Math.abs(sourcePos.getY() - targetPos.getY()) > 1.8);
    }

    private void sendProtectionMessage(Player player) {
        long lastTime;
        UUID playerId = player.getUniqueId();
        long cooldown = (long)this.plugin.getConfig().getInt("warning-messages-cooldown.damage", 5) * 1000L;
        long currentTime = System.currentTimeMillis();
        if (currentTime - (lastTime = this.lastProtectionMessageTime.getOrDefault(playerId, 0L).longValue()) >= cooldown) {
            this.lastProtectionMessageTime.put(playerId, currentTime);
            String message = this.plugin.getPrefixManager().formatMessage("protection-hit");
            if (message != null && !message.isEmpty()) {
                player.sendMessage(HexColor.translateAlternateColorCodes('&', message));
            }
        }
    }

    private void sendPickupProtectionMessage(Player player) {
        long lastTime;
        UUID playerId = player.getUniqueId();
        long cooldown = (long)this.plugin.getConfig().getInt("warning-messages-cooldown.itempickup", 10) * 1000L;
        long currentTime = System.currentTimeMillis();
        if (currentTime - (lastTime = this.lastPickupMessageTime.getOrDefault(playerId, 0L).longValue()) >= cooldown) {
            this.lastPickupMessageTime.put(playerId, currentTime);
            String message = this.plugin.getPrefixManager().formatMessage("protection-item-pickup");
            if (message != null && !message.isEmpty()) {
                player.sendMessage(HexColor.translateAlternateColorCodes('&', message));
            }
        }
    }

    private void sendAttackProtectionMessage(Player player) {
        long lastTime;
        UUID playerId = player.getUniqueId();
        long cooldown = (long)this.plugin.getConfig().getInt("warning-messages-cooldown.damage", 5) * 1000L;
        long currentTime = System.currentTimeMillis();
        if (currentTime - (lastTime = this.lastAttackMessageTime.getOrDefault(playerId, 0L).longValue()) >= cooldown) {
            this.lastAttackMessageTime.put(playerId, currentTime);
            String message = this.plugin.getPrefixManager().formatMessage("protected-player-attack");
            if (message != null && !message.isEmpty()) {
                player.sendMessage(HexColor.translateAlternateColorCodes('&', message));
            }
        }
    }

    private void sendProtectedAttackWarning(Player player) {
        long lastTime;
        UUID playerId = player.getUniqueId();
        long cooldown = (long)this.plugin.getConfig().getInt("warning-messages-cooldown.attack", 5) * 1000L;
        long currentTime = System.currentTimeMillis();
        if (currentTime - (lastTime = this.lastProtectedAttackWarningTime.getOrDefault(playerId, 0L).longValue()) >= cooldown) {
            this.lastProtectedAttackWarningTime.put(playerId, currentTime);
            String message = this.plugin.getPrefixManager().formatMessage("protected-attack-warning");
            if (message != null && !message.isEmpty()) {
                player.sendMessage(HexColor.translateAlternateColorCodes('&', message));
            }
        }
    }

    private void sendTitleAndSound(Player player, String soundConfigPath, String titleConfigPath, long protectionTime) {
        boolean titleEnabled;
        boolean soundEnabled = this.plugin.getConfig().getBoolean(soundConfigPath + ".enabled", false);
        if (soundEnabled) {
            String soundName = this.plugin.getConfig().getString(soundConfigPath + ".sound", "ENTITY_EXPERIENCE_ORB_PICKUP");
            try {
                Sound sound = Sound.valueOf((String)soundName);
                player.playSound(player.getLocation(), sound, 1.0f, 1.0f);
            }
            catch (IllegalArgumentException e) {
                this.plugin.getLogger().warning("Invalid sound in config: " + soundName);
            }
        }
        if (titleEnabled = this.plugin.getConfig().getBoolean(titleConfigPath + ".enabled", false)) {
            String titleText = this.plugin.getPrefixManager().formatMessage(titleConfigPath + ".text");
            String subtitleText = this.plugin.getPrefixManager().formatMessage(titleConfigPath + ".subtitle");
            int fadeIn = 10;
            int stay = 70;
            int fadeOut = 10;
            player.sendTitle(HexColor.translateAlternateColorCodes('&', titleText), HexColor.translateAlternateColorCodes('&', subtitleText), fadeIn, stay, fadeOut);
        }
    }

    private long parseProtectionDuration(String duration) {
        long totalSeconds = 0L;
        try {
            if (duration.endsWith("s")) {
                totalSeconds = Long.parseLong(duration.replace("s", ""));
            } else if (duration.endsWith("m")) {
                totalSeconds = Long.parseLong(duration.replace("m", "")) * 60L;
            } else if (duration.endsWith("h")) {
                totalSeconds = Long.parseLong(duration.replace("h", "")) * 3600L;
            } else {
                this.plugin.getLogger().warning("Invalid protection duration format: " + duration);
            }
        }
        catch (NumberFormatException e) {
            this.plugin.getLogger().warning("Invalid number in protection duration: " + duration);
        }
        return totalSeconds;
    }

    private String formatTime(long seconds) {
        long hours = seconds / 3600L;
        long minutes = seconds % 3600L / 60L;
        long remainingSeconds = seconds % 60L;
        String hourText = this.plugin.getConfig().getString("time-format.h", "h");
        String minuteText = this.plugin.getConfig().getString("time-format.m", "m");
        String secondText = this.plugin.getConfig().getString("time-format.s", "s");
        return String.format("%02d%s %02d%s %02d%s", hours, hourText, minutes, minuteText, remainingSeconds, secondText);
    }
}

