/*
 * Decompiled with CFR 0.152.
 */
package dev.atrox.lightnewbie.Newbie;

import dev.atrox.lightnewbie.LightNewbie;
import java.util.UUID;
import net.md_5.bungee.api.ChatMessageType;
import net.md_5.bungee.api.chat.TextComponent;
import org.bukkit.entity.Player;
import org.bukkit.scheduler.BukkitRunnable;

public class ProtectionReminderTask
extends BukkitRunnable {
    private final UUID playerId;
    private final LightNewbie plugin;

    public ProtectionReminderTask(UUID playerId, LightNewbie plugin) {
        this.playerId = playerId;
        this.plugin = plugin;
    }

    public void run() {
        Player player = this.plugin.getServer().getPlayer(this.playerId);
        if (player == null || !this.plugin.isProtected(this.playerId)) {
            this.cancel();
            return;
        }
        long remainingTime = this.plugin.getRemainingProtection(this.playerId);
        if (remainingTime <= 0L) {
            this.plugin.disableProtection(this.playerId);
            this.cancel();
            return;
        }
        String actionBarMessage = this.plugin.getPrefixManager().formatMessage("protection-status").replace("{time}", this.formatTime(remainingTime));
        player.spigot().sendMessage(ChatMessageType.ACTION_BAR, TextComponent.fromLegacyText((String)actionBarMessage));
    }

    private String formatTime(long seconds) {
        long hours = seconds / 3600L;
        long minutes = seconds % 3600L / 60L;
        long remainingSeconds = seconds % 60L;
        String hourText = this.plugin.getConfig().getString("time-format.h", "h");
        String minuteText = this.plugin.getConfig().getString("time-format.m", "m");
        String secondText = this.plugin.getConfig().getString("time-format.s", "s");
        return String.format("%02d%s %02d%s %02d%s", hours, hourText, minutes, minuteText, remainingSeconds, secondText);
    }
}

