/*
 * Decompiled with CFR 0.152.
 */
package dev.atrox.lightnewbie;

import dev.atrox.lightnewbie.HexColor;
import dev.atrox.lightnewbie.LightNewbie;
import org.bukkit.configuration.file.FileConfiguration;

public class PrefixManager {
    private final LightNewbie plugin;
    private String prefix;

    public PrefixManager(LightNewbie plugin) {
        this.plugin = plugin;
        this.reload();
    }

    public void reload() {
        FileConfiguration config = this.plugin.getConfig();
        this.prefix = HexColor.translateAlternateColorCodes('&', config.getString("prefix", "&b\u029f\u026a\u0262\u029c\u1d1b\u0274\u1d07\u1d21\u0299\u026a\u1d07\u279c "));
    }

    public String getPrefix() {
        return this.prefix;
    }

    public String applyPrefix(String message) {
        if (message == null || message.isEmpty()) {
            return message;
        }
        return message.replace("%prefix%", this.prefix);
    }

    public String formatMessage(String path) {
        FileConfiguration messages = this.plugin.getMessages();
        String message = messages.getString(path, "");
        return HexColor.translateAlternateColorCodes('&', this.applyPrefix(message));
    }
}

