/*
 * Decompiled with CFR 0.152.
 */
package com.github.synnerz.devonian.utils;

import com.github.synnerz.devonian.Devonian;
import com.github.synnerz.devonian.api.events.EventBus;
import com.github.synnerz.devonian.api.events.GameUnloadEvent;
import com.github.synnerz.devonian.features.Feature;
import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonParser;
import java.io.Closeable;
import java.io.File;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.Reader;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.io.CloseableKt;
import kotlin.io.FilesKt;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.Reflection;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.reflect.KClass;
import net.minecraft.class_310;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000X\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0010\u0002\n\u0002\b\u0005\n\u0002\u0010\u000e\n\u0002\b\u0004\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0010\u0007\n\u0002\b\u0007\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u000b\n\u0002\u0010!\n\u0002\b\u0004\b\u00c6\u0002\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u001b\u0010\u0007\u001a\u00020\u00052\f\u0010\u0006\u001a\b\u0012\u0004\u0012\u00020\u00050\u0004\u00a2\u0006\u0004\b\u0007\u0010\bJ\u001b\u0010\t\u001a\u00020\u00052\f\u0010\u0006\u001a\b\u0012\u0004\u0012\u00020\u00050\u0004\u00a2\u0006\u0004\b\t\u0010\bJ#\u0010\u000e\u001a\u00020\u0000\"\u0004\b\u0000\u0010\n2\u0006\u0010\f\u001a\u00020\u000b2\u0006\u0010\r\u001a\u00028\u0000\u00a2\u0006\u0004\b\u000e\u0010\u000fJ\u001d\u0010\u0011\u001a\u00020\u00002\u0006\u0010\f\u001a\u00020\u000b2\u0006\u0010\r\u001a\u00020\u0010\u00a2\u0006\u0004\b\u0011\u0010\u0012J9\u0010\u0018\u001a\u00020\u00002\u0006\u0010\f\u001a\u00020\u000b2\n\b\u0002\u0010\u0014\u001a\u0004\u0018\u00010\u00132\n\b\u0002\u0010\u0015\u001a\u0004\u0018\u00010\u00132\n\b\u0002\u0010\u0017\u001a\u0004\u0018\u00010\u0016\u00a2\u0006\u0004\b\u0018\u0010\u0019J\"\u0010\u001a\u001a\u0004\u0018\u00018\u0000\"\u0006\b\u0000\u0010\n\u0018\u00012\u0006\u0010\f\u001a\u00020\u000bH\u0086\b\u00a2\u0006\u0004\b\u001a\u0010\u001bJ\u0017\u0010\u001c\u001a\u0004\u0018\u00010\u00102\u0006\u0010\f\u001a\u00020\u000b\u00a2\u0006\u0004\b\u001c\u0010\u001dJ\u0017\u0010\u001f\u001a\u0004\u0018\u00010\u001e2\u0006\u0010\f\u001a\u00020\u000b\u00a2\u0006\u0004\b\u001f\u0010 J\r\u0010!\u001a\u00020\u0005\u00a2\u0006\u0004\b!\u0010\u0003J\r\u0010\"\u001a\u00020\u0005\u00a2\u0006\u0004\b\"\u0010\u0003R\u0017\u0010$\u001a\u00020#8\u0006\u00a2\u0006\f\n\u0004\b$\u0010%\u001a\u0004\b&\u0010'R\u001f\u0010*\u001a\n )*\u0004\u0018\u00010(0(8\u0006\u00a2\u0006\f\n\u0004\b*\u0010+\u001a\u0004\b,\u0010-R\"\u0010.\u001a\u00020\u001e8\u0006@\u0006X\u0086\u000e\u00a2\u0006\u0012\n\u0004\b.\u0010/\u001a\u0004\b0\u00101\"\u0004\b2\u00103R \u00105\u001a\u000e\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u00050\u0004048\u0002X\u0082\u0004\u00a2\u0006\u0006\n\u0004\b5\u00106R \u00107\u001a\u000e\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u00050\u0004048\u0002X\u0082\u0004\u00a2\u0006\u0006\n\u0004\b7\u00106\u00a8\u00068"}, d2={"Lcom/github/synnerz/devonian/utils/JsonUtils;", "", "<init>", "()V", "Lkotlin/Function0;", "", "cb", "afterLoad", "(Lkotlin/jvm/functions/Function0;)V", "preSave", "T", "", "name", "value", "set", "(Ljava/lang/String;Ljava/lang/Object;)Lcom/github/synnerz/devonian/utils/JsonUtils;", "", "setConfig", "(Ljava/lang/String;Z)Lcom/github/synnerz/devonian/utils/JsonUtils;", "", "x", "y", "", "scale", "setHud", "(Ljava/lang/String;Ljava/lang/Integer;Ljava/lang/Integer;Ljava/lang/Float;)Lcom/github/synnerz/devonian/utils/JsonUtils;", "get", "(Ljava/lang/String;)Ljava/lang/Object;", "getConfig", "(Ljava/lang/String;)Ljava/lang/Boolean;", "Lcom/google/gson/JsonObject;", "getHud", "(Ljava/lang/String;)Lcom/google/gson/JsonObject;", "load", "save", "Ljava/io/File;", "configFile", "Ljava/io/File;", "getConfigFile", "()Ljava/io/File;", "Lcom/google/gson/Gson;", "kotlin.jvm.PlatformType", "gson", "Lcom/google/gson/Gson;", "getGson", "()Lcom/google/gson/Gson;", "json", "Lcom/google/gson/JsonObject;", "getJson", "()Lcom/google/gson/JsonObject;", "setJson", "(Lcom/google/gson/JsonObject;)V", "", "afterLoadListeners", "Ljava/util/List;", "preSaveListener", "devonian"})
@SourceDebugExtension(value={"SMAP\nJsonUtils.kt\nKotlin\n*S Kotlin\n*F\n+ 1 JsonUtils.kt\ncom/github/synnerz/devonian/utils/JsonUtils\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 3 fake.kt\nkotlin/jvm/internal/FakeKt\n+ 4 EventBus.kt\ncom/github/synnerz/devonian/api/events/EventBus\n+ 5 Maps.kt\nkotlin/collections/MapsKt__MapsKt\n*L\n1#1,158:1\n1563#2:159\n1634#2,3:160\n1#3:163\n115#4,5:164\n120#4:176\n384#5,7:169\n*S KotlinDebug\n*F\n+ 1 JsonUtils.kt\ncom/github/synnerz/devonian/utils/JsonUtils\n*L\n95#1:159\n95#1:160,3\n28#1:164,5\n28#1:176\n28#1:169,7\n*E\n"})
public final class JsonUtils {
    @NotNull
    public static final JsonUtils INSTANCE;
    @NotNull
    private static final File configFile;
    private static final Gson gson;
    @NotNull
    private static JsonObject json;
    @NotNull
    private static final List<Function0<Unit>> afterLoadListeners;
    @NotNull
    private static final List<Function0<Unit>> preSaveListener;

    private JsonUtils() {
    }

    @NotNull
    public final File getConfigFile() {
        return configFile;
    }

    public final Gson getGson() {
        return gson;
    }

    @NotNull
    public final JsonObject getJson() {
        return json;
    }

    public final void setJson(@NotNull JsonObject jsonObject) {
        Intrinsics.checkNotNullParameter((Object)jsonObject, (String)"<set-?>");
        json = jsonObject;
    }

    public final void afterLoad(@NotNull Function0<Unit> cb) {
        Intrinsics.checkNotNullParameter(cb, (String)"cb");
        afterLoadListeners.add(cb);
    }

    public final void preSave(@NotNull Function0<Unit> cb) {
        Intrinsics.checkNotNullParameter(cb, (String)"cb");
        preSaveListener.add(cb);
    }

    @NotNull
    public final <T> JsonUtils set(@NotNull String name, T value) {
        Intrinsics.checkNotNullParameter((Object)name, (String)"name");
        T t = value;
        if (t instanceof Boolean) {
            json.addProperty(name, (Boolean)value);
        } else if (t instanceof String) {
            json.addProperty(name, (String)value);
        } else if (t instanceof Character) {
            json.addProperty(name, (Character)value);
        } else if (t instanceof Number) {
            json.addProperty(name, (Number)value);
        } else if (t instanceof JsonArray) {
            json.add(name, (JsonElement)value);
        }
        return this;
    }

    @NotNull
    public final JsonUtils setConfig(@NotNull String name, boolean value) {
        Intrinsics.checkNotNullParameter((Object)name, (String)"name");
        if (json.get("config") == null) {
            json.add("config", (JsonElement)new JsonObject());
        }
        json.get("config").getAsJsonObject().addProperty(name, Boolean.valueOf(value));
        return this;
    }

    @NotNull
    public final JsonUtils setHud(@NotNull String name, @Nullable Integer x, @Nullable Integer y, @Nullable Float scale) {
        JsonObject huds;
        Intrinsics.checkNotNullParameter((Object)name, (String)"name");
        if (json.get("huds") == null) {
            json.add("huds", (JsonElement)new JsonObject());
        }
        if ((huds = json.get("huds").getAsJsonObject()).get(name) == null) {
            huds.add(name, (JsonElement)new JsonObject());
        }
        JsonObject currentHud = huds.get(name).getAsJsonObject();
        if (x != null) {
            currentHud.addProperty("x", (Number)x);
        }
        if (y != null) {
            currentHud.addProperty("y", (Number)y);
        }
        if (scale != null) {
            currentHud.addProperty("scale", (Number)scale);
        }
        return this;
    }

    public static /* synthetic */ JsonUtils setHud$default(JsonUtils jsonUtils, String string, Integer n, Integer n2, Float f, int n3, Object object) {
        if ((n3 & 2) != 0) {
            n = null;
        }
        if ((n3 & 4) != 0) {
            n2 = null;
        }
        if ((n3 & 8) != 0) {
            f = null;
        }
        return jsonUtils.setHud(string, n, n2, f);
    }

    /*
     * WARNING - void declaration
     */
    public final /* synthetic */ <T> T get(String name) {
        Object object;
        Intrinsics.checkNotNullParameter((Object)name, (String)"name");
        boolean $i$f$get = false;
        JsonElement jsonElement = this.getJson().get(name);
        if (jsonElement == null) {
            return null;
        }
        JsonElement value = jsonElement;
        Intrinsics.reifiedOperationMarker((int)4, (String)"T");
        KClass kClass = Reflection.getOrCreateKotlinClass(Object.class);
        if (Intrinsics.areEqual((Object)kClass, (Object)Reflection.getOrCreateKotlinClass(String.class))) {
            String string = value.getAsString();
            Intrinsics.reifiedOperationMarker((int)1, (String)"T");
            object = string;
        } else if (Intrinsics.areEqual((Object)kClass, (Object)Reflection.getOrCreateKotlinClass(Integer.TYPE))) {
            Integer n = value.getAsInt();
            Intrinsics.reifiedOperationMarker((int)1, (String)"T");
            object = n;
        } else if (Intrinsics.areEqual((Object)kClass, (Object)Reflection.getOrCreateKotlinClass(Double.TYPE))) {
            Double d = value.getAsDouble();
            Intrinsics.reifiedOperationMarker((int)1, (String)"T");
            object = d;
        } else if (Intrinsics.areEqual((Object)kClass, (Object)Reflection.getOrCreateKotlinClass(Float.TYPE))) {
            Float f = Float.valueOf(value.getAsFloat());
            Intrinsics.reifiedOperationMarker((int)1, (String)"T");
            object = f;
        } else if (Intrinsics.areEqual((Object)kClass, (Object)Reflection.getOrCreateKotlinClass(Long.TYPE))) {
            Long l = value.getAsLong();
            Intrinsics.reifiedOperationMarker((int)1, (String)"T");
            object = l;
        } else if (Intrinsics.areEqual((Object)kClass, (Object)Reflection.getOrCreateKotlinClass(Boolean.TYPE))) {
            Boolean bl = value.getAsBoolean();
            Intrinsics.reifiedOperationMarker((int)1, (String)"T");
            object = bl;
        } else if (Intrinsics.areEqual((Object)kClass, (Object)Reflection.getOrCreateKotlinClass(List.class))) {
            void $this$mapTo$iv$iv;
            JsonArray jsonArray = value.getAsJsonArray();
            Intrinsics.checkNotNullExpressionValue((Object)jsonArray, (String)"getAsJsonArray(...)");
            Iterable $this$map$iv = CollectionsKt.toList((Iterable)((Iterable)jsonArray));
            boolean $i$f$map = false;
            Iterable iterable = $this$map$iv;
            Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
            boolean $i$f$mapTo = false;
            for (Object item$iv$iv : $this$mapTo$iv$iv) {
                void it;
                JsonElement jsonElement2 = (JsonElement)item$iv$iv;
                Collection collection = destination$iv$iv;
                boolean bl = false;
                collection.add(it.getAsString());
            }
            List list = (List)destination$iv$iv;
            Intrinsics.reifiedOperationMarker((int)1, (String)"T");
            object = list;
        } else {
            object = null;
        }
        return (T)object;
    }

    @Nullable
    public final Boolean getConfig(@NotNull String name) {
        Intrinsics.checkNotNullParameter((Object)name, (String)"name");
        JsonElement jsonElement = json.get("config");
        return jsonElement != null && (jsonElement = jsonElement.getAsJsonObject()) != null && (jsonElement = jsonElement.get(name)) != null ? Boolean.valueOf(jsonElement.getAsBoolean()) : null;
    }

    @Nullable
    public final JsonObject getHud(@NotNull String name) {
        Intrinsics.checkNotNullParameter((Object)name, (String)"name");
        JsonElement jsonElement = json.get("huds");
        return jsonElement != null && (jsonElement = jsonElement.getAsJsonObject()) != null && (jsonElement = jsonElement.get(name)) != null ? jsonElement.getAsJsonObject() : null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void load() {
        if (configFile.exists()) {
            Closeable closeable = new FileReader(configFile);
            Throwable throwable = null;
            try {
                FileReader it = (FileReader)closeable;
                boolean bl = false;
                JsonObject savedData = JsonParser.parseReader((Reader)it).getAsJsonObject();
                if (savedData.isEmpty()) {
                    return;
                }
                for (Map.Entry entry : savedData.entrySet()) {
                    Intrinsics.checkNotNull((Object)entry);
                    String k = (String)entry.getKey();
                    JsonElement v = (JsonElement)entry.getValue();
                    if (Intrinsics.areEqual((Object)k, (Object)"config")) {
                        JsonObject savedConfig = v.getAsJsonObject();
                        for (String k2 : savedConfig.keySet()) {
                            Object v0;
                            block14: {
                                Iterable iterable = Devonian.INSTANCE.getFeatures();
                                for (Object t : iterable) {
                                    Feature feat = (Feature)t;
                                    boolean bl2 = false;
                                    if (!Intrinsics.areEqual((Object)feat.getConfigName(), (Object)k2)) continue;
                                    v0 = t;
                                    break block14;
                                }
                                v0 = null;
                            }
                            Feature feat = v0;
                            Intrinsics.checkNotNull((Object)k2);
                            Boolean prev = INSTANCE.getConfig(k2);
                            if (feat == null || prev == null || Intrinsics.areEqual((Object)prev, (Object)savedConfig.get(k2).getAsBoolean())) continue;
                            feat.onToggle(prev == false);
                        }
                    }
                    json.add(k, v);
                }
                for (Function0 function0 : afterLoadListeners) {
                    function0.invoke();
                }
                Unit unit = Unit.INSTANCE;
            }
            catch (Throwable throwable2) {
                throwable = throwable2;
                throw throwable2;
            }
            finally {
                CloseableKt.closeFinally((Closeable)closeable, (Throwable)throwable);
            }
            return;
        }
        json = new JsonObject();
        for (Function0<Unit> cb : afterLoadListeners) {
            cb.invoke();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void save() {
        if (!configFile.getParentFile().exists()) {
            File file = configFile.getParentFile();
            if (file != null) {
                file.mkdirs();
            }
        }
        for (Function0<Unit> cb : preSaveListener) {
            cb.invoke();
        }
        Closeable closeable = new FileWriter(configFile);
        Throwable throwable = null;
        try {
            FileWriter it = (FileWriter)closeable;
            boolean bl = false;
            gson.toJson((JsonElement)json, (Appendable)it);
            Unit unit = Unit.INSTANCE;
        }
        catch (Throwable throwable2) {
            throwable = throwable2;
            throw throwable2;
        }
        finally {
            CloseableKt.closeFinally((Closeable)closeable, (Throwable)throwable);
        }
    }

    private static final Unit _init_$lambda$0(GameUnloadEvent it) {
        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
        INSTANCE.save();
        return Unit.INSTANCE;
    }

    /*
     * WARNING - void declaration
     */
    static {
        Object object;
        void $this$getOrPut$iv$iv$iv;
        void this_$iv$iv;
        void this_$iv;
        INSTANCE = new JsonUtils();
        configFile = FilesKt.resolve((File)new File(class_310.method_1551().field_1697, "config"), (String)"devonianConfig.json");
        gson = new GsonBuilder().setPrettyPrinting().create();
        json = new JsonObject();
        afterLoadListeners = new ArrayList();
        preSaveListener = new ArrayList();
        EventBus eventBus = EventBus.INSTANCE;
        Function1 cb$iv = JsonUtils::_init_$lambda$0;
        boolean $i$f$on = false;
        void var3_3 = this_$iv;
        boolean add$iv$iv = true;
        boolean $i$f$on2 = false;
        Map map = this_$iv$iv.getEvents();
        String key$iv$iv$iv = GameUnloadEvent.class.getName();
        boolean $i$f$getOrPut = false;
        Object value$iv$iv$iv = $this$getOrPut$iv$iv$iv.get(key$iv$iv$iv);
        if (value$iv$iv$iv == null) {
            boolean bl = false;
            List answer$iv$iv$iv = new ArrayList();
            $this$getOrPut$iv$iv$iv.put(key$iv$iv$iv, answer$iv$iv$iv);
            object = answer$iv$iv$iv;
        } else {
            object = value$iv$iv$iv;
        }
        ((List)object).add(cb$iv);
        EventBus.EventListener cfr_ignored_0 = new EventBus.EventListener(cb$iv){
            final /* synthetic */ Function1 $cb;
            {
                this.$cb = $cb;
            }

            /*
             * WARNING - void declaration
             */
            public Boolean remove() {
                void this_$iv;
                EventBus eventBus = EventBus.INSTANCE;
                Function1 cb$iv = this.$cb;
                boolean $i$f$remove = false;
                List<Object> list = this_$iv.getEvents().get(GameUnloadEvent.class.getName());
                return list != null ? Boolean.valueOf(list.remove(cb$iv)) : null;
            }

            /*
             * WARNING - void declaration
             */
            public boolean add() {
                Object object;
                void $this$getOrPut$iv;
                Map map = EventBus.INSTANCE.getEvents();
                String key$iv = GameUnloadEvent.class.getName();
                boolean $i$f$getOrPut = false;
                V value$iv = $this$getOrPut$iv.get(key$iv);
                if (value$iv == null) {
                    boolean bl = false;
                    List answer$iv = new ArrayList<E>();
                    $this$getOrPut$iv.put(key$iv, answer$iv);
                    object = answer$iv;
                } else {
                    object = value$iv;
                }
                return ((List)object).add(this.$cb);
            }
        };
    }
}

