/*
 * Decompiled with CFR 0.152.
 */
package cfd.orangy.journeytracker.client;

import cfd.orangy.journeytracker.client.config.JMTConfig;
import cfd.orangy.journeytracker.client.plugin.JsonFetcher;
import com.mojang.brigadier.arguments.ArgumentType;
import com.mojang.brigadier.arguments.StringArgumentType;
import com.mojang.brigadier.builder.LiteralArgumentBuilder;
import com.mojang.brigadier.context.CommandContext;
import java.awt.Color;
import journeymap.api.v2.client.IClientAPI;
import journeymap.api.v2.common.waypoint.Waypoint;
import journeymap.api.v2.common.waypoint.WaypointFactory;
import journeymap.api.v2.common.waypoint.WaypointGroup;
import me.shedaniel.autoconfig.AutoConfig;
import me.shedaniel.autoconfig.serializer.GsonConfigSerializer;
import net.fabricmc.api.ClientModInitializer;
import net.fabricmc.api.EnvType;
import net.fabricmc.api.Environment;
import net.fabricmc.fabric.api.client.command.v2.ClientCommandManager;
import net.fabricmc.fabric.api.client.command.v2.ClientCommandRegistrationCallback;
import net.fabricmc.fabric.api.client.command.v2.FabricClientCommandSource;
import net.minecraft.class_2338;
import net.minecraft.class_2561;
import net.minecraft.class_437;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Environment(value=EnvType.CLIENT)
public class JourneytrackerClient
implements ClientModInitializer {
    public static IClientAPI gJmApi = null;
    public static final String MOD_ID = "journeytracker";
    public static JMTConfig CONFIG = null;
    public static final Logger LOGGER = LoggerFactory.getLogger((String)"JourneyTracker");

    public void onInitializeClient() {
        LOGGER.info("Initializing Tracker...");
        AutoConfig.register(JMTConfig.class, GsonConfigSerializer::new);
        CONFIG = (JMTConfig)AutoConfig.getConfigHolder(JMTConfig.class).getConfig();
        ClientCommandRegistrationCallback.EVENT.register((dispatcher, registryAccess) -> dispatcher.register((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)ClientCommandManager.literal((String)"jmtracker").executes(context -> {
            ((FabricClientCommandSource)context.getSource()).sendFeedback((class_2561)class_2561.method_43470((String)"\u00a73[\u00a7bJT\u00a73]\u00a7e Usage: \n\u00a73[\u00a7bJT\u00a73]\u00a7e /jmtracker add <player> - adds a player to your tracking list\n\u00a73[\u00a7bJT\u00a73]\u00a7e /jmtracker remove <player> - removes player\n\u00a73[\u00a7bJT\u00a73]\u00a7e /jmtracker url <url?> - prints or changes the url used for tracking\n\u00a73[\u00a7bJT\u00a73]\u00a7e /jmtracker on/off - enables/disables tracking"));
            return 1;
        })).then(((LiteralArgumentBuilder)ClientCommandManager.literal((String)"url").executes(context -> {
            ((FabricClientCommandSource)context.getSource()).getPlayer().method_7353((class_2561)class_2561.method_43470((String)("\u00a73[\u00a7bJT\u00a73]\u00a7a Current URL is: \u00a7d" + JourneytrackerClient.CONFIG.DynMapUrl)), false);
            return 1;
        })).then(ClientCommandManager.argument((String)"url", (ArgumentType)StringArgumentType.string()).executes(context -> {
            JourneytrackerClient.CONFIG.DynMapUrl = StringArgumentType.getString((CommandContext)context, (String)"url");
            ((FabricClientCommandSource)context.getSource()).getPlayer().method_7353((class_2561)class_2561.method_43470((String)("\u00a73[\u00a7bJT\u00a73]\u00a7a Current URL changed to: \u00a7d" + JourneytrackerClient.CONFIG.DynMapUrl)), false);
            return 1;
        })))).then(((LiteralArgumentBuilder)ClientCommandManager.literal((String)"add").executes(context -> {
            ((FabricClientCommandSource)context.getSource()).getPlayer().method_7353((class_2561)class_2561.method_43470((String)"\u00a73[\u00a7bJT\u00a73]\u00a7e Usage: add <player>"), false);
            return 1;
        })).then(ClientCommandManager.argument((String)"playerName", (ArgumentType)StringArgumentType.word()).executes(context -> {
            String playerName = StringArgumentType.getString((CommandContext)context, (String)"playerName");
            if (JourneytrackerClient.CONFIG.trackedPlayers.containsKey(playerName.toLowerCase())) {
                ((FabricClientCommandSource)context.getSource()).getPlayer().method_7353((class_2561)class_2561.method_43470((String)("\u00a73[\u00a7bJT\u00a73]\u00a7c Player \u00a7d" + playerName + "\u00a7c is already tracked.")), false);
                return 0;
            }
            Waypoint wp = WaypointFactory.createClientWaypoint((String)MOD_ID, (class_2338)new class_2338(0, 0, 0), (String)"minecraft:overworld", (boolean)true);
            wp.setName(playerName);
            WaypointGroup group = gJmApi.getWaypointGroupByName(MOD_ID, "Players");
            if (group == null) {
                group = WaypointFactory.createWaypointGroup((String)MOD_ID, (String)"Players");
            }
            wp.setColor(Color.RED.getRGB());
            gJmApi.addWaypoint(MOD_ID, wp);
            group.addWaypoint(wp);
            JourneytrackerClient.CONFIG.trackedPlayers.put(playerName.toLowerCase(), wp.getGuid());
            AutoConfig.getConfigHolder(JMTConfig.class).save();
            ((FabricClientCommandSource)context.getSource()).getPlayer().method_7353((class_2561)class_2561.method_43470((String)("\u00a73[\u00a7bJT\u00a73]\u00a7a Added \u00a7d" + playerName + "\u00a7a to the tracking list.")), false);
            return 1;
        })))).then(((LiteralArgumentBuilder)ClientCommandManager.literal((String)"remove").executes(context -> {
            ((FabricClientCommandSource)context.getSource()).getPlayer().method_7353((class_2561)class_2561.method_43470((String)"\u00a73[\u00a7bJT\u00a73]\u00a7e Usage: remove <player>"), false);
            return 1;
        })).then(ClientCommandManager.argument((String)"playerName", (ArgumentType)StringArgumentType.word()).executes(context -> {
            String playerName = StringArgumentType.getString((CommandContext)context, (String)"playerName");
            if (!JourneytrackerClient.CONFIG.trackedPlayers.containsKey(playerName.toLowerCase())) {
                ((FabricClientCommandSource)context.getSource()).getPlayer().method_7353((class_2561)class_2561.method_43470((String)("\u00a73[\u00a7bJT\u00a73]\u00a7c Player \u00a7d" + playerName + "\u00a7c isn't tracked.")), false);
                return 0;
            }
            JourneytrackerClient.CONFIG.trackedPlayers.remove(playerName.toLowerCase());
            AutoConfig.getConfigHolder(JMTConfig.class).save();
            ((FabricClientCommandSource)context.getSource()).getPlayer().method_7353((class_2561)class_2561.method_43470((String)("\u00a73[\u00a7bJT\u00a73]\u00a7a Removed \u00a7d" + playerName + "\u00a7a to the tracking list.")), false);
            return 1;
        })))).then(ClientCommandManager.literal((String)"list").executes(context -> {
            ((FabricClientCommandSource)context.getSource()).getPlayer().method_7353((class_2561)class_2561.method_43470((String)("\u00a73[\u00a7bJT\u00a73]\u00a7a List of tracked players: \u00a7d" + String.join((CharSequence)"\u00a7a, \u00a7d", JourneytrackerClient.CONFIG.trackedPlayers.keySet()))), false);
            return 1;
        }))).then(ClientCommandManager.literal((String)"on").executes(context -> {
            ((FabricClientCommandSource)context.getSource()).getPlayer().method_7353((class_2561)class_2561.method_43470((String)"\u00a73[\u00a7bJT\u00a73]\u00a7a Tracking enabled. "), false);
            JourneytrackerClient.CONFIG.isOn = false;
            JourneytrackerClient.CONFIG.isOn = true;
            AutoConfig.getConfigHolder(JMTConfig.class).save();
            JsonFetcher thread = new JsonFetcher();
            thread.setName("JMTracker Fetch Thread");
            thread.start();
            return 1;
        }))).then(ClientCommandManager.literal((String)"off").executes(context -> {
            ((FabricClientCommandSource)context.getSource()).getPlayer().method_7353((class_2561)class_2561.method_43470((String)"\u00a73[\u00a7bJT\u00a73]\u00a7a Tracking disabled. "), false);
            JourneytrackerClient.CONFIG.isOn = false;
            AutoConfig.getConfigHolder(JMTConfig.class).save();
            return 1;
        }))).then(ClientCommandManager.literal((String)"config").executes(context -> {
            ((FabricClientCommandSource)context.getSource()).getClient().method_63588(() -> ((FabricClientCommandSource)context.getSource()).getClient().method_29970((class_437)AutoConfig.getConfigScreen(JMTConfig.class, null).get()));
            return 1;
        }))));
        LOGGER.info("Initialized!");
    }
}

