/*
 * Decompiled with CFR 0.152.
 */
package cfd.orangy.journeytracker.client.plugin;

import cfd.orangy.journeytracker.client.JourneytrackerClient;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonParser;
import java.awt.Color;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.net.URL;
import java.nio.charset.Charset;
import journeymap.api.v2.common.waypoint.Waypoint;
import journeymap.api.v2.common.waypoint.WaypointFactory;
import net.fabricmc.api.EnvType;
import net.fabricmc.api.Environment;
import net.minecraft.class_1937;
import net.minecraft.class_2338;
import net.minecraft.class_5321;

@Environment(value=EnvType.CLIENT)
public class JsonFetcher
extends Thread {
    private class_5321<class_1937> getWorld(String worldString) {
        switch (worldString) {
            case "minecraft_the_nether": {
                return class_1937.field_25180;
            }
            case "minecraft_the_end": {
                return class_1937.field_25181;
            }
            case "minecraft_overworld": {
                return class_1937.field_25179;
            }
        }
        return null;
    }

    @Override
    public void run() {
        while (JourneytrackerClient.CONFIG.isOn) {
            try {
                Thread.sleep(JourneytrackerClient.CONFIG.delayMs);
                JsonObject json = JsonFetcher.readJsonFromUrl(JourneytrackerClient.CONFIG.DynMapUrl + "/tiles/players.json");
                json.getAsJsonArray("players").iterator().forEachRemaining(playerObj -> {
                    JsonObject player = (JsonObject)playerObj;
                    if (JourneytrackerClient.CONFIG.trackedPlayers.containsKey(player.get("name").getAsString().toLowerCase())) {
                        Waypoint waypoint = JourneytrackerClient.gJmApi.getWaypoint("journeytracker", JourneytrackerClient.CONFIG.trackedPlayers.get(player.get("name").getAsString().toLowerCase()));
                        if (waypoint != null) {
                            JourneytrackerClient.gJmApi.removeWaypoint("journeytracker", waypoint);
                        }
                        waypoint = WaypointFactory.createClientWaypoint((String)"journeytracker", (class_2338)new class_2338(0, 0, 0), this.getWorld(player.get("world").getAsString()), (boolean)true);
                        waypoint = WaypointFactory.createClientWaypoint((String)"journeytracker", (class_2338)new class_2338(player.get("x").getAsInt(), player.get("y").getAsInt(), player.get("z").getAsInt()), this.getWorld(player.get("world").getAsString()), (boolean)false);
                        waypoint.setName(player.get("name").getAsString());
                        waypoint.setColor(Color.RED.getRGB());
                        JourneytrackerClient.gJmApi.addWaypoint("journeytracker", waypoint);
                        JourneytrackerClient.gJmApi.getWaypointGroupByName("journeytracker", "Players").addWaypoint(waypoint);
                        JourneytrackerClient.CONFIG.trackedPlayers.remove(player.get("name").getAsString().toLowerCase());
                        JourneytrackerClient.CONFIG.trackedPlayers.put(player.get("name").getAsString().toLowerCase(), waypoint.getGuid());
                    }
                });
            }
            catch (IOException e) {
                JourneytrackerClient.LOGGER.error("Something went wrong with fetching players!");
                throw new RuntimeException(e);
            }
            catch (InterruptedException e) {
                JourneytrackerClient.LOGGER.error("Thread Interrupted!");
                throw new RuntimeException(e);
            }
            catch (NullPointerException e) {
                JourneytrackerClient.LOGGER.warn("Null!");
                e.printStackTrace();
            }
        }
    }

    private static String readAll(Reader rd) throws IOException {
        int cp;
        StringBuilder sb = new StringBuilder();
        while ((cp = rd.read()) != -1) {
            sb.append((char)cp);
        }
        return sb.toString();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static JsonObject readJsonFromUrl(String url) throws IOException {
        try (InputStream is = new URL(url).openStream();){
            BufferedReader rd = new BufferedReader(new InputStreamReader(is, Charset.forName("UTF-8")));
            String jsonText = JsonFetcher.readAll(rd);
            JsonElement json = new JsonParser().parse(jsonText);
            JsonObject jsonObject = json.getAsJsonObject();
            return jsonObject;
        }
    }
}

