/*
 * Decompiled with CFR 0.152.
 */
package net.byAqua3.avaritia.block;

import net.byAqua3.avaritia.block.BlockMachine;
import net.byAqua3.avaritia.inventory.MenuNeutronCollector;
import net.byAqua3.avaritia.loader.AvaritiaBlocks;
import net.byAqua3.avaritia.tile.TileNeutronCollector;
import net.minecraft.core.BlockPos;
import net.minecraft.core.NonNullList;
import net.minecraft.network.chat.Component;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.MenuProvider;
import net.minecraft.world.SimpleMenuProvider;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.item.ItemEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.phys.BlockHitResult;

public class BlockNeutronCollector
extends BlockMachine {
    public static final Component TITLE = Component.translatable((String)"avaritia:container.neutron_collector.title");

    public BlockNeutronCollector(BlockBehaviour.Properties properties) {
        super(properties, () -> AvaritiaBlocks.NEUTRON_COLLECTOR_TILE.get());
    }

    public InteractionResult useWithoutItem(BlockState state, Level level, BlockPos pos, Player player, BlockHitResult result) {
        if (level.isClientSide()) {
            return InteractionResult.SUCCESS;
        }
        BlockEntity blockEntity = level.getBlockEntity(pos);
        if (blockEntity instanceof TileNeutronCollector) {
            TileNeutronCollector tile = (TileNeutronCollector)blockEntity;
            SimpleMenuProvider simpleMenuProvider = new SimpleMenuProvider((id, inventory, access) -> new MenuNeutronCollector(id, inventory, tile, tile.dataAccess), TITLE);
            player.openMenu((MenuProvider)simpleMenuProvider, pos);
        }
        return InteractionResult.CONSUME;
    }

    public void onRemove(BlockState state, Level level, BlockPos pos, BlockState newState, boolean movedByPiston) {
        BlockEntity blockEntity;
        if (state.getBlock() != newState.getBlock() && (blockEntity = level.getBlockEntity(pos)) instanceof TileNeutronCollector) {
            TileNeutronCollector tile = (TileNeutronCollector)blockEntity;
            NonNullList itemStacks = tile.result.getItems();
            for (ItemStack itemStack : itemStacks) {
                if (itemStack.isEmpty()) continue;
                ItemEntity itemEntity = new ItemEntity(level, (double)pos.getX(), (double)pos.getY(), (double)pos.getZ(), itemStack);
                itemEntity.setDefaultPickUpDelay();
                level.addFreshEntity((Entity)itemEntity);
            }
        }
        super.onRemove(state, level, pos, newState, movedByPiston);
    }
}

