/*
 * Decompiled with CFR 0.152.
 */
package net.byAqua3.avaritia.compat.jade.component;

import net.byAqua3.avaritia.compat.jade.AvaritiaJadePlugin;
import net.byAqua3.avaritia.compat.jade.element.ElementCompressorProgress;
import net.byAqua3.avaritia.item.ItemJsonSingularity;
import net.byAqua3.avaritia.loader.AvaritiaDataComponents;
import net.byAqua3.avaritia.loader.AvaritiaSingularities;
import net.byAqua3.avaritia.singularity.Singularity;
import net.byAqua3.avaritia.tile.TileNeutroniumCompressor;
import net.byAqua3.avaritia.util.TextComponent;
import net.minecraft.core.component.DataComponentType;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.ItemLike;
import snownee.jade.api.BlockAccessor;
import snownee.jade.api.IBlockComponentProvider;
import snownee.jade.api.IServerDataProvider;
import snownee.jade.api.ITooltip;
import snownee.jade.api.config.IPluginConfig;
import snownee.jade.api.ui.IElement;
import snownee.jade.api.ui.IElementHelper;

public class ComponentProviderCompressor
implements IBlockComponentProvider,
IServerDataProvider<BlockAccessor> {
    public static final ResourceLocation PROGRESS = ResourceLocation.tryBuild((String)"avaritia", (String)"progress");
    public static final ResourceLocation PROGRESS_BASE = ResourceLocation.tryBuild((String)"avaritia", (String)"progress_base");

    public ResourceLocation getUid() {
        return AvaritiaJadePlugin.COMPRESSOR_UID;
    }

    public ItemStack getMatrixItem(int itemId) {
        Item item = (Item)BuiltInRegistries.ITEM.byId(itemId);
        if (item != null) {
            return new ItemStack((ItemLike)item);
        }
        return ItemStack.EMPTY;
    }

    public ItemStack getResultItem(int itemId, int index) {
        Item item = (Item)BuiltInRegistries.ITEM.byId(itemId);
        if (item != null) {
            Singularity singularity;
            ItemStack itemStack = new ItemStack((ItemLike)item);
            if (item instanceof ItemJsonSingularity && index != -1 && (singularity = AvaritiaSingularities.getInstance().getSingularities().get(index)) != null) {
                itemStack.set((DataComponentType)AvaritiaDataComponents.SINGULARITY_ID.get(), (Object)singularity.getId());
            }
            return itemStack;
        }
        return ItemStack.EMPTY;
    }

    public void appendServerData(CompoundTag tag, BlockAccessor blockAccessor) {
        if (blockAccessor.getBlockEntity() != null && blockAccessor.getBlockEntity() instanceof TileNeutroniumCompressor) {
            TileNeutroniumCompressor tile = (TileNeutroniumCompressor)blockAccessor.getBlockEntity();
            tag.putInt("compressionTarget", tile.dataAccess.get(0));
            tag.putInt("consumptionProgress", tile.dataAccess.get(1));
            tag.putInt("compressionProgress", tile.dataAccess.get(2));
            tag.putInt("targetStackId", tile.dataAccess.get(3));
            tag.putInt("targetSingularityId", tile.dataAccess.get(4));
            tag.putInt("matrixStackId", tile.dataAccess.get(5));
        }
    }

    public void appendTooltip(ITooltip tooltip, BlockAccessor blockAccessor, IPluginConfig config) {
        if (blockAccessor.getBlockEntity() != null && blockAccessor.getBlockEntity() instanceof TileNeutroniumCompressor) {
            TileNeutroniumCompressor tile = (TileNeutroniumCompressor)blockAccessor.getBlockEntity();
            IElementHelper helper = IElementHelper.get();
            int compressionTarget = blockAccessor.getServerData().getInt("compressionTarget");
            int consumptionProgress = blockAccessor.getServerData().getInt("consumptionProgress");
            int compressionProgress = blockAccessor.getServerData().getInt("compressionProgress");
            int matrixStackId = blockAccessor.getServerData().getInt("matrixStackId");
            int targetStackId = blockAccessor.getServerData().getInt("targetStackId");
            int targetSingularityId = blockAccessor.getServerData().getInt("targetSingularityId");
            ItemStack matrixItem = this.getMatrixItem(matrixStackId);
            ItemStack resultItem = this.getResultItem(targetStackId, targetSingularityId);
            if (!resultItem.isEmpty()) {
                tooltip.add(helper.item(matrixItem).align(IElement.Align.LEFT));
                tooltip.append(new ElementCompressorProgress((float)compressionProgress / (float)compressionTarget).align(IElement.Align.CENTER));
                tooltip.append(helper.item(resultItem).align(IElement.Align.RIGHT));
                tooltip.add(helper.text((Component)TextComponent.getText(compressionProgress + " / " + compressionTarget)).align(IElement.Align.CENTER));
            }
        }
    }
}

