/*
 * Decompiled with CFR 0.152.
 */
package net.byAqua3.avaritia.compat.rei.display;

import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.MapCodec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import java.util.Collections;
import java.util.List;
import java.util.Optional;
import me.shedaniel.rei.api.common.category.CategoryIdentifier;
import me.shedaniel.rei.api.common.display.Display;
import me.shedaniel.rei.api.common.display.DisplaySerializer;
import me.shedaniel.rei.api.common.entry.EntryIngredient;
import me.shedaniel.rei.api.common.util.EntryIngredients;
import net.byAqua3.avaritia.compat.rei.AvaritiaREIPlugin;
import net.byAqua3.avaritia.recipe.RecipeCompressor;
import net.minecraft.core.HolderLookup;
import net.minecraft.core.NonNullList;
import net.minecraft.core.RegistryAccess;
import net.minecraft.network.codec.ByteBufCodecs;
import net.minecraft.network.codec.StreamCodec;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.Ingredient;
import org.jetbrains.annotations.Nullable;

public class DisplayCompressorRecipe
implements Display {
    private RecipeCompressor recipe;

    public DisplayCompressorRecipe(RecipeCompressor recipe) {
        this.recipe = recipe;
    }

    public CategoryIdentifier<?> getCategoryIdentifier() {
        return AvaritiaREIPlugin.COMPRESSOR;
    }

    public List<EntryIngredient> getInputEntries() {
        return EntryIngredients.ofIngredients((List)this.recipe.placementInfo().ingredients());
    }

    public List<EntryIngredient> getOutputEntries() {
        return Collections.singletonList(EntryIngredients.of((ItemStack)this.recipe.getResultItem((HolderLookup.Provider)RegistryAccess.EMPTY)));
    }

    public RecipeCompressor getRecipe() {
        return this.recipe;
    }

    public int getCost() {
        return this.recipe.getCost();
    }

    public Optional<ResourceLocation> getDisplayLocation() {
        return Optional.of(AvaritiaREIPlugin.COMPRESSOR.getIdentifier());
    }

    @Nullable
    public DisplaySerializer<? extends Display> getSerializer() {
        return null;
    }

    public static class Shapeless
    extends DisplayCompressorRecipe {
        public static final DisplaySerializer<Shapeless> SERIALIZER = DisplaySerializer.of((MapCodec)RecordCodecBuilder.mapCodec(instance -> instance.group((App)Codec.STRING.optionalFieldOf("group", (Object)"").forGetter(recipe -> recipe.group), (App)ItemStack.STRICT_CODEC.fieldOf("result").forGetter(recipe -> recipe.result), (App)Codec.INT.optionalFieldOf("cost", (Object)0).forGetter(recipe -> recipe.cost), (App)Ingredient.CODEC.listOf().fieldOf("ingredients").forGetter(recipe -> recipe.ingredients)).apply((Applicative)instance, Shapeless::new)), (StreamCodec)StreamCodec.composite((StreamCodec)ByteBufCodecs.STRING_UTF8, recipe -> recipe.group, (StreamCodec)ItemStack.STREAM_CODEC, recipe -> recipe.result, (StreamCodec)ByteBufCodecs.INT, recipe -> recipe.cost, (StreamCodec)Ingredient.CONTENTS_STREAM_CODEC.apply(ByteBufCodecs.list()), recipe -> recipe.ingredients, Shapeless::new), (boolean)false);
        public String group;
        public ItemStack result;
        public int cost;
        public NonNullList<Ingredient> ingredients;

        public Shapeless(RecipeCompressor recipe) {
            super(recipe);
            this.group = recipe.group;
            this.result = recipe.result;
            this.cost = recipe.cost;
            this.ingredients = NonNullList.copyOf(recipe.ingredients);
        }

        public Shapeless(String group, ItemStack result, int cost, List<Ingredient> ingredients) {
            super(new RecipeCompressor(group, result, cost, ingredients));
            this.group = group;
            this.result = result;
            this.cost = cost;
            this.ingredients = NonNullList.copyOf(ingredients);
        }

        @Override
        public DisplaySerializer<? extends Display> getSerializer() {
            return SERIALIZER;
        }
    }
}

