/*
 * Decompiled with CFR 0.152.
 */
package net.byAqua3.avaritia.compat.rei.display;

import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.MapCodec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Optional;
import me.shedaniel.rei.api.common.category.CategoryIdentifier;
import me.shedaniel.rei.api.common.display.Display;
import me.shedaniel.rei.api.common.display.DisplaySerializer;
import me.shedaniel.rei.api.common.entry.EntryIngredient;
import me.shedaniel.rei.api.common.util.EntryIngredients;
import net.byAqua3.avaritia.compat.rei.AvaritiaREIPlugin;
import net.byAqua3.avaritia.recipe.RecipeExtremeCrafting;
import net.byAqua3.avaritia.recipe.RecipeExtremeShaped;
import net.byAqua3.avaritia.recipe.RecipeExtremeShapeless;
import net.minecraft.core.HolderLookup;
import net.minecraft.core.NonNullList;
import net.minecraft.core.RegistryAccess;
import net.minecraft.network.RegistryFriendlyByteBuf;
import net.minecraft.network.codec.ByteBufCodecs;
import net.minecraft.network.codec.StreamCodec;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.Ingredient;
import net.minecraft.world.item.crafting.ShapedRecipePattern;
import net.neoforged.neoforge.common.crafting.DataComponentIngredient;
import org.jetbrains.annotations.Nullable;

public class DisplayExtremeRecipe
implements Display {
    private RecipeExtremeCrafting recipe;

    public DisplayExtremeRecipe(RecipeExtremeCrafting recipe) {
        this.recipe = recipe;
    }

    public CategoryIdentifier<?> getCategoryIdentifier() {
        return AvaritiaREIPlugin.EXTREME_CRAFTING;
    }

    public List<EntryIngredient> getInputEntries() {
        if (!this.isShapeless()) {
            ArrayList<EntryIngredient> ingredients = new ArrayList<EntryIngredient>();
            RecipeExtremeShaped recipe = (RecipeExtremeShaped)this.recipe;
            for (Optional optional : recipe.pattern.ingredients()) {
                if (optional.isPresent()) {
                    ingredients.add(EntryIngredients.ofIngredient((Ingredient)((Ingredient)optional.get())));
                    continue;
                }
                ingredients.add(EntryIngredient.empty());
            }
            return ingredients;
        }
        ArrayList<EntryIngredient> ingredients = new ArrayList<EntryIngredient>();
        for (Ingredient ingredient : this.recipe.placementInfo().ingredients()) {
            if (ingredient.getCustomIngredient() != null && ingredient.getCustomIngredient() instanceof DataComponentIngredient) {
                DataComponentIngredient dataComponentIngredient = (DataComponentIngredient)ingredient.getCustomIngredient();
                List<ItemStack> itemStacks = dataComponentIngredient.items().map(holder -> new ItemStack(holder, 1, dataComponentIngredient.components().asPatch())).toList();
                ingredients.add(EntryIngredients.ofItemStacks(itemStacks));
                continue;
            }
            List<ItemStack> itemStacks = ingredient.items().map(holder -> new ItemStack(holder)).toList();
            ingredients.add(EntryIngredients.ofItemStacks(itemStacks));
        }
        return ingredients;
    }

    public List<EntryIngredient> getOutputEntries() {
        return Collections.singletonList(EntryIngredients.of((ItemStack)this.recipe.getResultItem((HolderLookup.Provider)RegistryAccess.EMPTY)));
    }

    public RecipeExtremeCrafting getRecipe() {
        return this.recipe;
    }

    public boolean isShapeless() {
        return this.recipe instanceof RecipeExtremeShapeless;
    }

    public Optional<ResourceLocation> getDisplayLocation() {
        return Optional.of(AvaritiaREIPlugin.EXTREME_CRAFTING.getIdentifier());
    }

    @Nullable
    public DisplaySerializer<? extends Display> getSerializer() {
        return null;
    }

    public static class Shapeless
    extends DisplayExtremeRecipe {
        public static final DisplaySerializer<Shapeless> SERIALIZER = DisplaySerializer.of((MapCodec)RecordCodecBuilder.mapCodec(instance -> instance.group((App)Codec.STRING.optionalFieldOf("group", (Object)"").forGetter(recipe -> recipe.group), (App)ItemStack.STRICT_CODEC.fieldOf("result").forGetter(recipe -> recipe.result), (App)Ingredient.CODEC.listOf().fieldOf("ingredients").forGetter(recipe -> recipe.ingredients), (App)Codec.BOOL.optionalFieldOf("singularities", (Object)false).forGetter(recipe -> recipe.hasSingularities)).apply((Applicative)instance, Shapeless::new)), (StreamCodec)StreamCodec.composite((StreamCodec)ByteBufCodecs.STRING_UTF8, recipe -> recipe.group, (StreamCodec)ItemStack.STREAM_CODEC, recipe -> recipe.result, (StreamCodec)Ingredient.CONTENTS_STREAM_CODEC.apply(ByteBufCodecs.list()), recipe -> recipe.ingredients, (StreamCodec)ByteBufCodecs.BOOL, recipe -> recipe.hasSingularities, Shapeless::new), (boolean)false);
        public String group;
        public ItemStack result;
        public List<Ingredient> ingredients;
        public boolean hasSingularities;

        public Shapeless(RecipeExtremeShapeless recipe) {
            super(recipe);
            this.group = recipe.group;
            this.result = recipe.result;
            this.ingredients = NonNullList.copyOf(recipe.ingredients);
            this.hasSingularities = recipe.hasSingularities;
        }

        public Shapeless(String group, ItemStack result, List<Ingredient> ingredients, boolean hasSingularities) {
            super(new RecipeExtremeShapeless(group, result, ingredients, hasSingularities));
            this.group = group;
            this.result = result;
            this.ingredients = NonNullList.copyOf(ingredients);
            this.hasSingularities = hasSingularities;
        }

        @Override
        public DisplaySerializer<? extends Display> getSerializer() {
            return SERIALIZER;
        }
    }

    public static class Shaped
    extends DisplayExtremeRecipe {
        public static final DisplaySerializer<Shaped> SERIALIZER = DisplaySerializer.of((MapCodec)RecordCodecBuilder.mapCodec(instance -> instance.group((App)Codec.STRING.optionalFieldOf("group", (Object)"").forGetter(recipe -> recipe.group), (App)ShapedRecipePattern.MAP_CODEC.forGetter(recipe -> recipe.pattern), (App)ItemStack.STRICT_CODEC.fieldOf("result").forGetter(recipe -> recipe.result)).apply((Applicative)instance, Shaped::new)), (StreamCodec)StreamCodec.of(Shaped::toNetwork, Shaped::fromNetwork), (boolean)false);
        public final String group;
        public final ShapedRecipePattern pattern;
        public final ItemStack result;

        public Shaped(RecipeExtremeShaped recipe) {
            super(recipe);
            this.group = recipe.group;
            this.pattern = recipe.pattern;
            this.result = recipe.result;
        }

        public Shaped(String group, ShapedRecipePattern pattern, ItemStack result) {
            super(new RecipeExtremeShaped(group, pattern, result));
            this.group = group;
            this.pattern = pattern;
            this.result = result;
        }

        private static Shaped fromNetwork(RegistryFriendlyByteBuf friendlyByteBuf) {
            String group = friendlyByteBuf.readUtf();
            ShapedRecipePattern pattern = (ShapedRecipePattern)ShapedRecipePattern.STREAM_CODEC.decode((Object)friendlyByteBuf);
            ItemStack itemStack = (ItemStack)ItemStack.STREAM_CODEC.decode((Object)friendlyByteBuf);
            return new Shaped(group, pattern, itemStack);
        }

        private static void toNetwork(RegistryFriendlyByteBuf friendlyByteBuf, Shaped recipe) {
            friendlyByteBuf.writeUtf(recipe.group);
            ShapedRecipePattern.STREAM_CODEC.encode((Object)friendlyByteBuf, (Object)recipe.pattern);
            ItemStack.STREAM_CODEC.encode((Object)friendlyByteBuf, (Object)recipe.result);
        }

        @Override
        public DisplaySerializer<? extends Display> getSerializer() {
            return SERIALIZER;
        }
    }
}

