/*
 * Decompiled with CFR 0.152.
 */
package net.byAqua3.avaritia.compat.rei.network;

import io.netty.buffer.ByteBuf;
import io.netty.buffer.ByteBufUtil;
import io.netty.buffer.Unpooled;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import java.util.function.UnaryOperator;
import me.shedaniel.rei.api.client.registry.display.DisplayRegistry;
import me.shedaniel.rei.api.common.display.Display;
import me.shedaniel.rei.impl.client.registry.display.DisplayRegistryImpl;
import net.byAqua3.avaritia.Avaritia;
import net.byAqua3.avaritia.compat.rei.display.DisplayCompressorRecipe;
import net.byAqua3.avaritia.compat.rei.display.DisplayExtremeRecipe;
import net.minecraft.network.RegistryFriendlyByteBuf;
import net.minecraft.network.codec.ByteBufCodecs;
import net.minecraft.network.codec.StreamCodec;
import net.minecraft.network.protocol.common.custom.CustomPacketPayload;
import net.minecraft.resources.ResourceLocation;
import net.neoforged.neoforge.network.handling.IPayloadContext;
import net.neoforged.neoforge.network.handling.IPayloadHandler;

public record PacketDisplaySync(List<Display> displays) implements CustomPacketPayload
{
    public static final CustomPacketPayload.Type<PacketDisplaySync> TYPE = new CustomPacketPayload.Type(ResourceLocation.tryBuild((String)"avaritia", (String)"display_sync"));
    public static final StreamCodec<RegistryFriendlyByteBuf, PacketDisplaySync> STREAM_CODEC = StreamCodec.composite((StreamCodec)new StreamCodec<RegistryFriendlyByteBuf, Display>(){

        public void encode(RegistryFriendlyByteBuf buf, Display display) {
            RegistryFriendlyByteBuf tmpBuf = new RegistryFriendlyByteBuf(Unpooled.buffer(), buf.registryAccess());
            try {
                if (display instanceof DisplayExtremeRecipe.Shaped) {
                    buf.writeInt(0);
                    DisplayExtremeRecipe.Shaped.SERIALIZER.streamCodec().encode((Object)tmpBuf, (Object)((DisplayExtremeRecipe.Shaped)display));
                } else if (display instanceof DisplayExtremeRecipe.Shapeless) {
                    buf.writeInt(1);
                    DisplayExtremeRecipe.Shapeless.SERIALIZER.streamCodec().encode((Object)tmpBuf, (Object)((DisplayExtremeRecipe.Shapeless)display));
                } else if (display instanceof DisplayCompressorRecipe.Shapeless) {
                    buf.writeInt(2);
                    DisplayCompressorRecipe.Shapeless.SERIALIZER.streamCodec().encode((Object)tmpBuf, (Object)((DisplayCompressorRecipe.Shapeless)display));
                } else {
                    buf.writeInt(3);
                    Display.streamCodec().encode((Object)tmpBuf, (Object)display);
                }
            }
            catch (Throwable throwable) {
                tmpBuf.release();
                buf.writeBoolean(false);
                Avaritia.LOGGER.debug("Failed to encode display: %s".formatted(display), throwable);
                return;
            }
            buf.writeBoolean(true);
            RegistryFriendlyByteBuf.writeByteArray((ByteBuf)buf, (byte[])ByteBufUtil.getBytes((ByteBuf)tmpBuf));
            tmpBuf.release();
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public Display decode(RegistryFriendlyByteBuf buf) {
            int index = buf.readInt();
            boolean success = buf.readBoolean();
            if (!success) {
                return null;
            }
            RegistryFriendlyByteBuf tmpBuf = new RegistryFriendlyByteBuf(Unpooled.wrappedBuffer((byte[])RegistryFriendlyByteBuf.readByteArray((ByteBuf)buf)), buf.registryAccess());
            try {
                if (index == 0) {
                    Display display = (Display)DisplayExtremeRecipe.Shaped.SERIALIZER.streamCodec().decode((Object)tmpBuf);
                    return display;
                }
                if (index == 1) {
                    Display display = (Display)DisplayExtremeRecipe.Shapeless.SERIALIZER.streamCodec().decode((Object)tmpBuf);
                    return display;
                }
                if (index == 2) {
                    Display display = (Display)DisplayCompressorRecipe.Shapeless.SERIALIZER.streamCodec().decode((Object)tmpBuf);
                    return display;
                }
                Display display = (Display)Display.streamCodec().decode((Object)tmpBuf);
                return display;
            }
            catch (Throwable throwable) {
                Display display = null;
                return display;
            }
            finally {
                tmpBuf.release();
            }
        }
    }.apply(ByteBufCodecs.collection(ArrayList::new)).map(list -> list.stream().filter(Objects::nonNull).toList(), UnaryOperator.identity()), PacketDisplaySync::displays, PacketDisplaySync::new);

    public CustomPacketPayload.Type<? extends CustomPacketPayload> type() {
        return TYPE;
    }

    public static class Handler
    implements IPayloadHandler<PacketDisplaySync> {
        public void handle(PacketDisplaySync packet, IPayloadContext context) {
            context.enqueueWork(() -> {
                DisplayRegistryImpl registry = (DisplayRegistryImpl)DisplayRegistry.getInstance();
                registry.addJob(() -> {
                    for (Display display : packet.displays) {
                        registry.add(display);
                    }
                });
            });
        }
    }
}

