/*
 * Decompiled with CFR 0.152.
 */
package net.byAqua3.avaritia.event;

import java.util.ArrayList;
import java.util.List;
import net.byAqua3.avaritia.damage.InfinityDamageSource;
import net.byAqua3.avaritia.item.ItemInfinityArmor;
import net.byAqua3.avaritia.item.ItemInfinityAxe;
import net.byAqua3.avaritia.item.ItemInfinityBow;
import net.byAqua3.avaritia.item.ItemInfinityHoe;
import net.byAqua3.avaritia.item.ItemInfinityPickaxe;
import net.byAqua3.avaritia.item.ItemInfinityShovel;
import net.byAqua3.avaritia.item.ItemInfinitySword;
import net.byAqua3.avaritia.item.ItemMatterCluster;
import net.byAqua3.avaritia.item.ItemSkullFireSword;
import net.byAqua3.avaritia.loader.AvaritiaConfigs;
import net.byAqua3.avaritia.loader.AvaritiaDataComponents;
import net.byAqua3.avaritia.loader.AvaritiaItems;
import net.byAqua3.avaritia.loader.AvaritiaSingularities;
import net.byAqua3.avaritia.loader.AvaritiaTriggers;
import net.byAqua3.avaritia.network.PacketSingularitySync;
import net.byAqua3.avaritia.singularity.Singularity;
import net.byAqua3.avaritia.trigger.TriggerAvaritiaRoot;
import net.minecraft.core.BlockPos;
import net.minecraft.core.component.DataComponentType;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.network.protocol.common.custom.CustomPacketPayload;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.server.packs.resources.ResourceManager;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.effect.MobEffects;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.entity.item.ItemEntity;
import net.minecraft.world.entity.monster.AbstractSkeleton;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.phys.Vec3;
import net.neoforged.bus.api.SubscribeEvent;
import net.neoforged.neoforge.event.OnDatapackSyncEvent;
import net.neoforged.neoforge.event.entity.EntityJoinLevelEvent;
import net.neoforged.neoforge.event.entity.living.LivingDamageEvent;
import net.neoforged.neoforge.event.entity.living.LivingDeathEvent;
import net.neoforged.neoforge.event.entity.living.LivingDropsEvent;
import net.neoforged.neoforge.event.entity.living.LivingEntityUseItemEvent;
import net.neoforged.neoforge.event.entity.living.LivingEvent;
import net.neoforged.neoforge.event.entity.living.LivingIncomingDamageEvent;
import net.neoforged.neoforge.event.entity.player.ItemEntityPickupEvent;
import net.neoforged.neoforge.event.entity.player.PlayerEvent;
import net.neoforged.neoforge.event.entity.player.PlayerInteractEvent;
import net.neoforged.neoforge.event.tick.EntityTickEvent;
import net.neoforged.neoforge.network.PacketDistributor;

public class AvaritiaEvent {
    public static boolean ClientFly;
    public static boolean ClientMove;
    public static List<String> FlyPlayer;
    public static List<String> MovePlayer;

    public static boolean isInfinityArmor(Player player) {
        return player.getItemBySlot(EquipmentSlot.HEAD).getItem() == AvaritiaItems.INFINITY_HELMET.get() && player.getItemBySlot(EquipmentSlot.CHEST).getItem() == AvaritiaItems.INFINITY_CHESTPLATE.get() && player.getItemBySlot(EquipmentSlot.LEGS).getItem() == AvaritiaItems.INFINITY_LEGGINGS.get() && player.getItemBySlot(EquipmentSlot.FEET).getItem() == AvaritiaItems.INFINITY_BOOTS.get();
    }

    @SubscribeEvent
    public void onEntityJoinWorld(EntityJoinLevelEvent event) {
        ItemEntity itemEntity;
        ItemStack itemStack;
        Item item;
        Entity entity = event.getEntity();
        if (entity instanceof ItemEntity && ((item = (itemStack = (itemEntity = (ItemEntity)entity).getItem()).getItem()) instanceof ItemInfinitySword || item instanceof ItemInfinityBow || item instanceof ItemInfinityAxe || item instanceof ItemInfinityPickaxe || item instanceof ItemInfinityShovel || item instanceof ItemInfinityHoe || item instanceof ItemInfinityArmor)) {
            itemEntity.setPickUpDelay(8);
        }
    }

    @SubscribeEvent
    public void onLivingTick(EntityTickEvent.Post event) {
        if (event.getEntity() instanceof Player) {
            Player player = (Player)event.getEntity();
            String playerName = player.getDisplayName().getString();
            if (player instanceof ServerPlayer) {
                ServerPlayer serverPlayer = (ServerPlayer)player;
                ((TriggerAvaritiaRoot)((Object)AvaritiaTriggers.ROOT.get())).trigger(serverPlayer);
            }
            if ((ClientFly || FlyPlayer.contains(playerName)) && player.getItemBySlot(EquipmentSlot.CHEST).getItem() != AvaritiaItems.INFINITY_CHESTPLATE.get()) {
                if (!player.isCreative()) {
                    player.getAbilities().mayfly = false;
                    player.getAbilities().flying = false;
                }
                player.getAbilities().setFlyingSpeed(0.05f);
                if (player.level().isClientSide() && ClientFly) {
                    ClientFly = false;
                }
                if (FlyPlayer.contains(playerName)) {
                    FlyPlayer.remove(playerName);
                }
            }
            if ((ClientMove || MovePlayer.contains(playerName)) && player.getItemBySlot(EquipmentSlot.FEET).getItem() != AvaritiaItems.INFINITY_BOOTS.get()) {
                player.getAttribute(Attributes.STEP_HEIGHT).setBaseValue(0.5);
                if (player.level().isClientSide() && ClientMove) {
                    ClientMove = false;
                }
                if (MovePlayer.contains(playerName)) {
                    MovePlayer.remove(playerName);
                }
            }
            if (player.getItemBySlot(EquipmentSlot.CHEST).getItem() == AvaritiaItems.INFINITY_CHESTPLATE.get()) {
                if (player.level().isClientSide()) {
                    ClientFly = true;
                }
                if (!FlyPlayer.contains(playerName)) {
                    FlyPlayer.add(playerName);
                }
            }
            if (player.getItemBySlot(EquipmentSlot.FEET).getItem() == AvaritiaItems.INFINITY_BOOTS.get()) {
                boolean flying = player.getAbilities().flying;
                boolean swimming = player.isInWater();
                if (player.onGround() || flying || swimming) {
                    boolean sneaking = player.isCrouching();
                    float speed = 0.15f * (flying ? 1.1f : 1.0f) * (swimming ? 1.2f : 1.0f) * (sneaking ? 0.1f : 1.0f);
                    if (player.zza > 0.0f) {
                        player.moveRelative(speed, new Vec3(0.0, 0.0, 1.0));
                    } else if (player.zza < 0.0f) {
                        player.moveRelative(-speed * 0.25f, new Vec3(0.0, 0.0, 1.0));
                    }
                    if (player.xxa != 0.0f) {
                        player.moveRelative(speed * 0.5f * Math.signum(player.xxa), new Vec3(1.0, 0.0, 0.0));
                    }
                }
                if (player.level().isClientSide()) {
                    ClientMove = true;
                }
                if (!MovePlayer.contains(playerName)) {
                    MovePlayer.add(playerName);
                }
            }
        }
    }

    @SubscribeEvent
    public void onLivingJump(LivingEvent.LivingJumpEvent event) {
        Player player;
        if (event.getEntity() instanceof Player && (player = (Player)event.getEntity()).getItemBySlot(EquipmentSlot.FEET).getItem() == AvaritiaItems.INFINITY_BOOTS.get()) {
            player.setDeltaMovement(player.getDeltaMovement().x, player.getDeltaMovement().y + 0.4, player.getDeltaMovement().z);
        }
    }

    @SubscribeEvent
    public void onLivingDrops(LivingDropsEvent event) {
        Player player;
        if (event.getEntity() instanceof AbstractSkeleton && event.getSource().getEntity() instanceof Player && (player = (Player)event.getSource().getEntity()).getMainHandItem().getItem() instanceof ItemSkullFireSword) {
            for (ItemEntity itemEntity : event.getDrops()) {
                if (itemEntity.getItem().getItem() != Items.WITHER_SKELETON_SKULL) continue;
                event.getDrops().remove(itemEntity);
            }
            int randomInt = player.getRandom().nextInt(100) + 1;
            if (randomInt <= (Integer)AvaritiaConfigs.dropChange.get()) {
                ItemEntity itemEntity;
                itemEntity = new ItemEntity(event.getEntity().level(), event.getEntity().getX(), event.getEntity().getY(), event.getEntity().getZ(), new ItemStack((ItemLike)Items.WITHER_SKELETON_SKULL));
                itemEntity.setDefaultPickUpDelay();
                event.getDrops().add(itemEntity);
            }
        }
    }

    @SubscribeEvent
    public void onLivingAttack(LivingIncomingDamageEvent event) {
        if (event.getEntity() instanceof Player) {
            DamageSource damageSource = event.getSource();
            Player player = (Player)event.getEntity();
            if (AvaritiaEvent.isInfinityArmor(player) && !(damageSource instanceof InfinityDamageSource)) {
                event.setCanceled(true);
                player.hurtTime = 0;
                player.deathTime = 0;
            }
        }
    }

    @SubscribeEvent
    public void onLivingDamage(LivingDamageEvent.Pre event) {
        if (event.getEntity() instanceof Player) {
            DamageSource damageSource = event.getSource();
            Player player = (Player)event.getEntity();
            if (AvaritiaEvent.isInfinityArmor(player) && !(damageSource instanceof InfinityDamageSource)) {
                event.setNewDamage(0.0f);
                player.hurtTime = 0;
                player.deathTime = 0;
            }
        }
    }

    @SubscribeEvent
    public void onLivingHurt(LivingDamageEvent.Post event) {
        if (event.getEntity() instanceof Player) {
            DamageSource damageSource = event.getSource();
            Player player = (Player)event.getEntity();
            if (AvaritiaEvent.isInfinityArmor(player) && !(damageSource instanceof InfinityDamageSource)) {
                player.hurtTime = 0;
                player.deathTime = 0;
            }
        }
    }

    @SubscribeEvent
    public void onLivingDeath(LivingDeathEvent event) {
        if (event.getEntity() instanceof Player) {
            DamageSource damageSource = event.getSource();
            Player player = (Player)event.getEntity();
            if (AvaritiaEvent.isInfinityArmor(player) && !(damageSource instanceof InfinityDamageSource)) {
                event.setCanceled(true);
                player.hurtTime = 0;
                player.deathTime = 0;
                player.setHealth(Math.max(20.0f, player.getMaxHealth()));
            }
        }
    }

    @SubscribeEvent
    public void onPlayerBreakSpeed(PlayerEvent.BreakSpeed event) {
        Player player = event.getEntity();
        ItemStack itemStack = player.getMainHandItem();
        Item item = itemStack.getItem();
        if (item instanceof ItemInfinityAxe) {
            event.setNewSpeed(event.getNewSpeed() * 5.0f);
        } else if (item instanceof ItemInfinityPickaxe) {
            if (itemStack.has((DataComponentType)AvaritiaDataComponents.HAMMER.get()) && ((Boolean)itemStack.getOrDefault((DataComponentType)AvaritiaDataComponents.HAMMER.get(), (Object)false)).booleanValue()) {
                event.setNewSpeed(10.0f);
            } else {
                event.setNewSpeed(Float.MAX_VALUE);
            }
        } else if (item instanceof ItemInfinityShovel) {
            event.setNewSpeed(event.getNewSpeed() * 5.0f);
        } else if (item instanceof ItemInfinityHoe) {
            event.setNewSpeed(event.getNewSpeed() * 5.0f);
        }
    }

    @SubscribeEvent
    public void onPlayerLeftClick(PlayerInteractEvent.LeftClickBlock event) {
        Level level = event.getLevel();
        Player player = event.getEntity();
        BlockPos blockPos = event.getPos();
        BlockState blockState = level.getBlockState(blockPos);
        Block block = blockState.getBlock();
        ItemStack itemStack = event.getItemStack();
        Item item = itemStack.getItem();
        if ((item instanceof ItemInfinityAxe || item instanceof ItemInfinityShovel) && player.isCreative()) {
            item.mineBlock(itemStack, level, blockState, blockPos, (LivingEntity)player);
        }
        if (item instanceof ItemInfinityPickaxe) {
            List blockDrops;
            if (itemStack.has((DataComponentType)AvaritiaDataComponents.HAMMER.get()) && ((Boolean)itemStack.getOrDefault((DataComponentType)AvaritiaDataComponents.HAMMER.get(), (Object)false)).booleanValue()) {
                if (player.isCreative() || blockState.getDestroySpeed((BlockGetter)level, blockPos) <= -1.0f) {
                    item.mineBlock(itemStack, level, blockState, blockPos, (LivingEntity)player);
                }
            } else if (!level.isClientSide() && !player.isCreative() && (blockDrops = Block.getDrops((BlockState)blockState, (ServerLevel)((ServerLevel)level), (BlockPos)blockPos, null)).isEmpty()) {
                ResourceLocation blockKey = BuiltInRegistries.BLOCK.getKey((Object)block);
                Item blockItem = (Item)BuiltInRegistries.ITEM.getValue(blockKey);
                ItemEntity itemEntity = new ItemEntity(level, (double)blockPos.getX(), (double)blockPos.getY(), (double)blockPos.getZ(), new ItemStack((ItemLike)blockItem));
                itemEntity.setDefaultPickUpDelay();
                level.addFreshEntity((Entity)itemEntity);
                level.destroyBlock(blockPos, false);
            }
        }
    }

    @SubscribeEvent
    public void onLivingEntityUseFinishItem(LivingEntityUseItemEvent.Finish event) {
        LivingEntity livingEntity = event.getEntity();
        ItemStack itemStack = event.getResultStack();
        Item item = itemStack.getItem();
        if (item == AvaritiaItems.ULTIMATE_STEW.get() || item == AvaritiaItems.COSMIC_MEATBALLS.get()) {
            livingEntity.addEffect(new MobEffectInstance(MobEffects.REGENERATION, 6000, 1));
        }
    }

    @SubscribeEvent
    public void onEntityItemPickup(ItemEntityPickupEvent.Post event) {
        Player player = event.getPlayer();
        ItemStack itemStack = event.getOriginalStack();
        Item item = itemStack.getItem();
        if (item instanceof ItemMatterCluster) {
            List<ItemStack> stackItems = ItemMatterCluster.getClusterItems(itemStack);
            for (int i = 0; i < player.getInventory().items.size(); ++i) {
                ItemStack newStack;
                int index;
                List<ItemStack> matterItems;
                ItemStack matterStack = (ItemStack)player.getInventory().items.get(i);
                if (matterStack.isEmpty() || !(matterStack.getItem() instanceof ItemMatterCluster) || ItemMatterCluster.getClusterCount(matterItems = ItemMatterCluster.getClusterItems(matterStack)) >= 4096) continue;
                int count = 4096 - ItemMatterCluster.getClusterCount(matterItems);
                if (count >= ItemMatterCluster.getClusterCount(stackItems)) {
                    ArrayList<ItemStack> newMatterItems = new ArrayList<ItemStack>();
                    newMatterItems.addAll(matterItems);
                    newMatterItems.addAll(stackItems);
                    player.getInventory().items.set(i, (Object)ItemMatterCluster.makeCluster(newMatterItems));
                    for (ItemStack oldMatterStack : player.getInventory().items) {
                        List<ItemStack> oldMatterItems;
                        int oldCount;
                        if (!(oldMatterStack.getItem() instanceof ItemMatterCluster) || (oldCount = ItemMatterCluster.getClusterCount(oldMatterItems = ItemMatterCluster.getClusterItems(oldMatterStack))) != 0) continue;
                        oldMatterStack.setCount(0);
                    }
                    break;
                }
                if (count <= 0) break;
                ArrayList<ItemStack> newStackItems = new ArrayList<ItemStack>();
                ArrayList<ItemStack> newMatterItems = new ArrayList<ItemStack>();
                int size = 0;
                for (index = 0; index < stackItems.size() && (size += (newStack = stackItems.get(index)).getCount()) < count; ++index) {
                }
                int newCount = size - count;
                ItemStack newStack2 = stackItems.get(index);
                ItemStack copyStack = newStack2.copy();
                copyStack.setCount(copyStack.getCount() - newCount);
                newStack2.setCount(newCount);
                newMatterItems.addAll(matterItems);
                newMatterItems.add(copyStack);
                newMatterItems.addAll(stackItems.subList(0, index));
                newStackItems.add(newStack2);
                newStackItems.addAll(stackItems.subList(index + 1, stackItems.size() - 1));
                player.getInventory().items.set(i, (Object)ItemMatterCluster.makeCluster(newMatterItems));
                break;
            }
        }
    }

    @SubscribeEvent
    public void onDatapackSync(OnDatapackSyncEvent event) {
        ServerPlayer player = event.getPlayer();
        if (player == null) {
            ResourceManager resourceManager = event.getPlayerList().getServer().getResourceManager();
            List<Singularity> singularities = AvaritiaSingularities.loadSingularities(resourceManager);
            PacketDistributor.sendToAllPlayers((CustomPacketPayload)new PacketSingularitySync(singularities), (CustomPacketPayload[])new CustomPacketPayload[0]);
        } else {
            ResourceManager resourceManager = player.getServer().getResourceManager();
            List<Singularity> singularities = AvaritiaSingularities.loadSingularities(resourceManager);
            PacketDistributor.sendToPlayer((ServerPlayer)player, (CustomPacketPayload)new PacketSingularitySync(singularities), (CustomPacketPayload[])new CustomPacketPayload[0]);
        }
    }

    static {
        FlyPlayer = new ArrayList<String>();
        MovePlayer = new ArrayList<String>();
    }
}

