/*
 * Decompiled with CFR 0.152.
 */
package net.byAqua3.avaritia.gui;

import com.mojang.blaze3d.systems.RenderSystem;
import net.byAqua3.avaritia.inventory.MenuNeutroniumCompressor;
import net.byAqua3.avaritia.util.TextComponent;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.screens.inventory.AbstractContainerScreen;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.FormattedText;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.inventory.AbstractContainerMenu;

public class GuiNeutroniumCompressor
extends AbstractContainerScreen<MenuNeutroniumCompressor> {
    public static final ResourceLocation BACKGROUND_LOCATION = ResourceLocation.tryBuild((String)"avaritia", (String)"textures/gui/compressor.png");
    public static final ResourceLocation DARK_BACKGROUND_LOCATION = ResourceLocation.tryBuild((String)"avaritia", (String)"textures/gui/compressor_dark.png");

    public GuiNeutroniumCompressor(MenuNeutroniumCompressor menu, Inventory inventory, Component title) {
        super((AbstractContainerMenu)menu, inventory, title);
    }

    public boolean isMouseHover(float x, float y, float width, float height, int mouseX, int mouseY) {
        return (float)mouseX >= x && (float)mouseY >= y && (float)mouseX <= x + width && (float)mouseY <= y + height;
    }

    public void render(GuiGraphics guiGraphics, int mouseX, int mouseY, float partialTicks) {
        float progress;
        this.renderBackground(guiGraphics, mouseX, mouseY, partialTicks);
        super.render(guiGraphics, mouseX, mouseY, partialTicks);
        if (((MenuNeutroniumCompressor)this.menu).getConsumptionProgress() > 0) {
            progress = 22.0f * ((float)((MenuNeutroniumCompressor)this.menu).getConsumptionProgress() / (float)((MenuNeutroniumCompressor)this.menu).getCompressionProgress());
            guiGraphics.blit(RenderType::guiTextured, BACKGROUND_LOCATION, this.getGuiLeft() + 62, this.getGuiTop() + 35, 176.0f, 0.0f, (int)progress, 16, 256, 256);
        }
        if (((MenuNeutroniumCompressor)this.menu).getCompressionProgress() > 0) {
            progress = 16.0f * ((float)((MenuNeutroniumCompressor)this.menu).getCompressionProgress() / (float)((MenuNeutroniumCompressor)this.menu).getCompressionTarget());
            guiGraphics.blit(RenderType::guiTextured, BACKGROUND_LOCATION, this.getGuiLeft() + 90, this.getGuiTop() + 35 + (16 - (int)progress), 176.0f, 32.0f - (float)((int)progress), 16, (int)progress, 256, 256);
            if (this.isMouseHover((float)this.getGuiLeft() + 90.0f, (float)this.getGuiTop() + 35.0f, 16.0f, 16.0f, mouseX, mouseY)) {
                String text = String.format("%.2f%%", Float.valueOf(100.0f * (float)((MenuNeutroniumCompressor)this.menu).getCompressionProgress() / (float)((MenuNeutroniumCompressor)this.menu).getCompressionTarget()));
                guiGraphics.renderTooltip(this.font, (Component)TextComponent.getText(text), mouseX, mouseY);
            }
        }
        this.renderTooltip(guiGraphics, mouseX, mouseY);
    }

    protected void renderBg(GuiGraphics guiGraphics, float partialTicks, int mouseX, int mouseY) {
        RenderSystem.setShaderColor((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        guiGraphics.blit(RenderType::guiTextured, BACKGROUND_LOCATION, this.getGuiLeft(), this.getGuiTop(), 0.0f, 0.0f, this.imageWidth, this.imageHeight, 256, 256);
    }

    protected void renderLabels(GuiGraphics guiGraphics, int mouseX, int mouseY) {
        guiGraphics.drawString(this.font, this.title, this.imageWidth / 2 - this.font.width((FormattedText)this.title) / 2, this.titleLabelY, 0x404040, false);
        if (((MenuNeutroniumCompressor)this.menu).getCompressionProgress() > 0) {
            String text = ((MenuNeutroniumCompressor)this.menu).getCompressionProgress() + " / " + ((MenuNeutroniumCompressor)this.menu).getCompressionTarget();
            guiGraphics.drawString(this.font, text, (float)(this.imageWidth / 2 - this.font.width(text) / 2), 60.0f, 0x404040, false);
        }
        guiGraphics.drawString(this.font, this.playerInventoryTitle, this.inventoryLabelX, this.inventoryLabelY, 0x404040, false);
    }
}

