/*
 * Decompiled with CFR 0.152.
 */
package net.byAqua3.avaritia.inventory;

import java.util.Optional;
import net.byAqua3.avaritia.inventory.slot.SlotInfinity;
import net.byAqua3.avaritia.loader.AvaritiaBlocks;
import net.byAqua3.avaritia.loader.AvaritiaDataComponents;
import net.byAqua3.avaritia.loader.AvaritiaMenus;
import net.byAqua3.avaritia.tile.TileInfinityChest;
import net.minecraft.core.BlockPos;
import net.minecraft.core.component.DataComponentType;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.world.Container;
import net.minecraft.world.entity.SlotAccess;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.flag.FeatureFlagSet;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.inventory.ClickAction;
import net.minecraft.world.inventory.ClickType;
import net.minecraft.world.inventory.MenuType;
import net.minecraft.world.inventory.Slot;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.block.Block;
import net.neoforged.neoforge.common.CommonHooks;

public class MenuInfinityChest
extends AbstractContainerMenu {
    private final TileInfinityChest tile;

    public MenuInfinityChest(int id, Inventory inventory, FriendlyByteBuf friendlyByteBuf) {
        this(id, inventory, (TileInfinityChest)inventory.player.level().getBlockEntity(friendlyByteBuf.readBlockPos()));
    }

    public MenuInfinityChest(int id, Inventory inventory, TileInfinityChest tile) {
        super((MenuType)AvaritiaMenus.INFINITY_CHEST.get(), id);
        int i;
        int y;
        this.tile = tile;
        for (y = 0; y < 12; ++y) {
            for (i = 0; i < 25; ++i) {
                this.addSlot(new SlotInfinity((Container)tile.chest, i + y * 25, 8 + i * 18, 18 + y * 18));
            }
        }
        for (y = 0; y < 3; ++y) {
            for (i = 0; i < 9; ++i) {
                this.addSlot(new Slot((Container)inventory, i + y * 9 + 9, 152 + i * 18, 248 + y * 18));
            }
        }
        for (int x = 0; x < 9; ++x) {
            this.addSlot(new Slot((Container)inventory, x, 152 + x * 18, 306));
        }
    }

    public TileInfinityChest getTile() {
        return this.tile;
    }

    private boolean tryItemClickBehaviourOverride(Player player, ClickAction clickAction, Slot slot, ItemStack clickedItem, ItemStack carriedItem) {
        if (CommonHooks.onItemStackedOn((ItemStack)clickedItem, (ItemStack)carriedItem, (Slot)slot, (ClickAction)clickAction, (Player)player, (SlotAccess)this.createCarriedSlotAccess())) {
            return true;
        }
        FeatureFlagSet featureflagset = player.level().enabledFeatures();
        return carriedItem.isItemEnabled(featureflagset) && carriedItem.overrideStackedOnOther(slot, clickAction, player) ? true : clickedItem.isItemEnabled(featureflagset) && clickedItem.overrideOtherStackedOnMe(carriedItem, slot, clickAction, player, this.createCarriedSlotAccess());
    }

    private SlotAccess createCarriedSlotAccess() {
        return new SlotAccess(){

            public ItemStack get() {
                return MenuInfinityChest.this.getCarried();
            }

            public boolean set(ItemStack stack) {
                MenuInfinityChest.this.setCarried(stack);
                return true;
            }
        };
    }

    public void clicked(int slotId, int button, ClickType clickType, Player player) {
        Inventory inventory = player.getInventory();
        if (!(clickType != ClickType.PICKUP && clickType != ClickType.QUICK_MOVE || button != 0 && button != 1)) {
            ClickAction clickaction;
            ClickAction clickAction = clickaction = button == 0 ? ClickAction.PRIMARY : ClickAction.SECONDARY;
            if (slotId == -999) {
                if (!this.getCarried().isEmpty()) {
                    if (clickaction == ClickAction.PRIMARY) {
                        player.drop(this.getCarried(), true);
                        this.setCarried(ItemStack.EMPTY);
                    } else {
                        player.drop(this.getCarried().split(1), true);
                    }
                }
            } else if (clickType == ClickType.QUICK_MOVE) {
                if (slotId < 0) {
                    return;
                }
                Slot slot6 = (Slot)this.slots.get(slotId);
                if (!slot6.mayPickup(player)) {
                    return;
                }
                ItemStack itemstack8 = this.quickMoveStack(player, slotId);
                while (!itemstack8.isEmpty() && ItemStack.isSameItem((ItemStack)slot6.getItem(), (ItemStack)itemstack8)) {
                    itemstack8 = this.quickMoveStack(player, slotId);
                }
            } else {
                if (slotId < 0) {
                    return;
                }
                Slot slot7 = (Slot)this.slots.get(slotId);
                ItemStack itemstack9 = slot7.getItem();
                ItemStack itemstack10 = this.getCarried();
                player.updateTutorialInventoryAction(itemstack10, slot7.getItem(), clickaction);
                if (!this.tryItemClickBehaviourOverride(player, clickaction, slot7, itemstack9, itemstack10)) {
                    if (itemstack9.isEmpty()) {
                        if (!itemstack10.isEmpty()) {
                            if (slot7.mayPlace(itemstack10)) {
                                if (slotId >= 300 && slotId < 336) {
                                    if (itemstack10.has((DataComponentType)AvaritiaDataComponents.MAX_STACK_SIZE.get())) {
                                        itemstack10.remove((DataComponentType)AvaritiaDataComponents.MAX_STACK_SIZE.get());
                                    }
                                } else {
                                    itemstack10.update((DataComponentType)AvaritiaDataComponents.MAX_STACK_SIZE.get(), (Object)itemstack10.getMaxStackSize(), size -> Integer.MAX_VALUE);
                                }
                            }
                            int i3 = clickaction == ClickAction.PRIMARY ? itemstack10.getCount() : 1;
                            this.setCarried(slot7.safeInsert(itemstack10, i3));
                        }
                    } else if (slot7.mayPickup(player)) {
                        if (itemstack10.isEmpty()) {
                            int j3 = clickaction == ClickAction.PRIMARY ? Math.min(64, itemstack9.getCount()) : (Math.min(64, itemstack9.getCount()) + 1) / 2;
                            Optional optional1 = slot7.tryRemove(j3, Integer.MAX_VALUE, player);
                            optional1.ifPresent(p_150421_ -> {
                                this.setCarried((ItemStack)p_150421_);
                                slot7.onTake(player, p_150421_);
                            });
                        } else if (slot7.mayPlace(itemstack10)) {
                            if (slotId >= 300 && slotId < 336) {
                                if (itemstack10.has((DataComponentType)AvaritiaDataComponents.MAX_STACK_SIZE.get())) {
                                    itemstack10.remove((DataComponentType)AvaritiaDataComponents.MAX_STACK_SIZE.get());
                                }
                            } else {
                                itemstack10.update((DataComponentType)AvaritiaDataComponents.MAX_STACK_SIZE.get(), (Object)itemstack10.getMaxStackSize(), size -> Integer.MAX_VALUE);
                            }
                            if (ItemStack.isSameItemSameComponents((ItemStack)itemstack9, (ItemStack)itemstack10)) {
                                int k3 = clickaction == ClickAction.PRIMARY ? itemstack10.getCount() : 1;
                                this.setCarried(slot7.safeInsert(itemstack10, k3));
                            } else if (itemstack10.getCount() <= slot7.getMaxStackSize(itemstack10)) {
                                this.setCarried(itemstack9);
                                slot7.setByPlayer(itemstack10);
                            }
                        } else if (ItemStack.isSameItemSameComponents((ItemStack)itemstack9, (ItemStack)itemstack10)) {
                            Optional optional = slot7.tryRemove(itemstack9.getCount(), itemstack10.getMaxStackSize() - itemstack10.getCount(), player);
                            optional.ifPresent(p_150428_ -> {
                                itemstack10.grow(p_150428_.getCount());
                                slot7.onTake(player, p_150428_);
                            });
                        }
                    }
                }
                slot7.setChanged();
            }
        } else if (clickType == ClickType.SWAP && (button >= 0 && button < 9 || button == 40)) {
            ItemStack itemstack2 = inventory.getItem(button);
            Slot slot5 = (Slot)this.slots.get(slotId);
            ItemStack itemstack7 = slot5.getItem();
            if (!itemstack2.isEmpty() || !itemstack7.isEmpty()) {
                if (itemstack2.isEmpty()) {
                    if (slot5.mayPickup(player)) {
                        inventory.setItem(button, itemstack7.split(Math.min(itemstack7.getCount(), Math.min(64, itemstack7.getMaxStackSize()))));
                        if (inventory.getItem(button).has((DataComponentType)AvaritiaDataComponents.MAX_STACK_SIZE.get())) {
                            inventory.getItem(button).remove((DataComponentType)AvaritiaDataComponents.MAX_STACK_SIZE.get());
                        }
                        slot5.onTake(player, itemstack7);
                    }
                } else if (itemstack7.isEmpty()) {
                    if (slot5.mayPlace(itemstack2)) {
                        int j2 = slot5.getMaxStackSize(itemstack2);
                        if (itemstack2.getCount() > j2) {
                            slot5.setByPlayer(itemstack2.split(j2));
                        } else {
                            inventory.setItem(button, ItemStack.EMPTY);
                            if (slotId >= 300 && slotId < 336) {
                                if (itemstack2.has((DataComponentType)AvaritiaDataComponents.MAX_STACK_SIZE.get())) {
                                    itemstack2.remove((DataComponentType)AvaritiaDataComponents.MAX_STACK_SIZE.get());
                                }
                            } else {
                                itemstack2.update((DataComponentType)AvaritiaDataComponents.MAX_STACK_SIZE.get(), (Object)itemstack2.getMaxStackSize(), size -> Integer.MAX_VALUE);
                            }
                            slot5.setByPlayer(itemstack2);
                        }
                    }
                } else if (slot5.mayPickup(player) && slot5.mayPlace(itemstack2) && itemstack7.getCount() <= Math.min(itemstack7.getMaxStackSize(), Math.min(64, slot5.getMaxStackSize()))) {
                    inventory.setItem(button, itemstack7.split(Math.min(itemstack7.getCount(), Math.min(64, itemstack7.getMaxStackSize()))));
                    if (inventory.getItem(button).has((DataComponentType)AvaritiaDataComponents.MAX_STACK_SIZE.get())) {
                        inventory.getItem(button).remove((DataComponentType)AvaritiaDataComponents.MAX_STACK_SIZE.get());
                    }
                    itemstack2.update((DataComponentType)AvaritiaDataComponents.MAX_STACK_SIZE.get(), (Object)itemstack2.getMaxStackSize(), size -> Integer.MAX_VALUE);
                    slot5.setByPlayer(itemstack2);
                    slot5.onTake(player, itemstack7);
                }
            }
        } else if (clickType == ClickType.CLONE && player.hasInfiniteMaterials() && this.getCarried().isEmpty() && slotId >= 0) {
            Slot slot4 = (Slot)this.slots.get(slotId);
            if (slot4.hasItem()) {
                ItemStack itemstack5 = slot4.getItem();
                ItemStack itemstack6 = itemstack5.copyWithCount(Math.min(64, itemstack5.getMaxStackSize()));
                if (itemstack6.has((DataComponentType)AvaritiaDataComponents.MAX_STACK_SIZE.get())) {
                    itemstack6.remove((DataComponentType)AvaritiaDataComponents.MAX_STACK_SIZE.get());
                }
                this.setCarried(itemstack6);
            }
        } else if (clickType == ClickType.THROW && this.getCarried().isEmpty() && slotId >= 0) {
            int j1;
            Slot slot3 = (Slot)this.slots.get(slotId);
            ItemStack itemstack7 = slot3.safeTake(j1 = button == 0 ? 1 : Math.min(64, slot3.getItem().getCount()), Integer.MAX_VALUE, player);
            if (itemstack7.has((DataComponentType)AvaritiaDataComponents.MAX_STACK_SIZE.get())) {
                itemstack7.remove((DataComponentType)AvaritiaDataComponents.MAX_STACK_SIZE.get());
            }
            player.drop(itemstack7, true);
        } else {
            super.clicked(slotId, button, clickType, player);
        }
    }

    protected boolean moveItemStackTo(ItemStack stack, int startIndex, int endIndex, boolean reverseDirection, boolean inventory) {
        boolean flag = false;
        int i = startIndex;
        if (reverseDirection) {
            i = endIndex - 1;
        }
        if (!stack.isEmpty()) {
            while (reverseDirection ? i >= startIndex : i < endIndex) {
                Slot slot = (Slot)this.slots.get(i);
                ItemStack itemStack = slot.getItem();
                if (!itemStack.isEmpty() && ItemStack.isSameItemSameComponents((ItemStack)stack, (ItemStack)itemStack)) {
                    int maxSize;
                    int j = itemStack.getCount() + stack.getCount();
                    int n = maxSize = inventory ? Math.min(Math.min(64, slot.getMaxStackSize()), stack.getMaxStackSize()) : Math.max(slot.getMaxStackSize(), stack.getMaxStackSize());
                    if (j <= maxSize && j > 0) {
                        if (!inventory) {
                            itemStack.update((DataComponentType)AvaritiaDataComponents.MAX_STACK_SIZE.get(), (Object)itemStack.getMaxStackSize(), size -> Integer.MAX_VALUE);
                        }
                        stack.setCount(0);
                        itemStack.setCount(j);
                        slot.setChanged();
                        flag = true;
                    } else if (itemStack.getCount() < maxSize) {
                        if (inventory && itemStack.has((DataComponentType)AvaritiaDataComponents.MAX_STACK_SIZE.get())) {
                            itemStack.remove((DataComponentType)AvaritiaDataComponents.MAX_STACK_SIZE.get());
                        }
                        stack.shrink(maxSize - itemStack.getCount());
                        itemStack.setCount(maxSize);
                        slot.setChanged();
                        flag = true;
                    }
                }
                if (reverseDirection) {
                    --i;
                    continue;
                }
                ++i;
            }
        }
        if (!stack.isEmpty()) {
            i = reverseDirection ? endIndex - 1 : startIndex;
            while (reverseDirection ? i >= startIndex : i < endIndex) {
                Slot slot1 = (Slot)this.slots.get(i);
                ItemStack itemstack1 = slot1.getItem();
                if (itemstack1.isEmpty() && slot1.mayPlace(stack)) {
                    if (!inventory) {
                        stack.update((DataComponentType)AvaritiaDataComponents.MAX_STACK_SIZE.get(), (Object)stack.getMaxStackSize(), size -> Integer.MAX_VALUE);
                    }
                    slot1.setByPlayer(stack.split(Math.min(stack.getCount(), Math.min(64, slot1.getMaxStackSize()))));
                    if (inventory && slot1.getItem().has((DataComponentType)AvaritiaDataComponents.MAX_STACK_SIZE.get())) {
                        slot1.getItem().remove((DataComponentType)AvaritiaDataComponents.MAX_STACK_SIZE.get());
                    }
                    slot1.setChanged();
                    flag = true;
                    break;
                }
                if (reverseDirection) {
                    --i;
                    continue;
                }
                ++i;
            }
        }
        return flag;
    }

    public ItemStack quickMoveStack(Player player, int index) {
        ItemStack resultStack = ItemStack.EMPTY;
        Slot slot = (Slot)this.slots.get(index);
        if (slot != null && slot.hasItem()) {
            ItemStack slotStack = slot.getItem();
            if (index < 300 ? !this.moveItemStackTo(slotStack, 300, 336, true, true) : !this.moveItemStackTo(slotStack, 0, 300, false, false)) {
                return ItemStack.EMPTY;
            }
            if (slotStack.isEmpty()) {
                slot.setByPlayer(ItemStack.EMPTY);
            } else {
                slot.setChanged();
            }
            if (slotStack.getCount() == resultStack.getCount()) {
                return ItemStack.EMPTY;
            }
            slot.onTake(player, slotStack);
        }
        return resultStack;
    }

    public boolean stillValid(Player player) {
        BlockPos pos = this.tile.getBlockPos();
        return this.tile.getLevel().getBlockState(pos).is((Block)AvaritiaBlocks.INFINITY_CHEST.get()) && player.distanceToSqr((double)pos.getX() + 0.5, (double)pos.getY() + 0.5, (double)pos.getZ() + 0.5) <= 64.0;
    }
}

