/*
 * Decompiled with CFR 0.152.
 */
package net.byAqua3.avaritia.inventory;

import net.byAqua3.avaritia.inventory.MenuMachine;
import net.byAqua3.avaritia.inventory.slot.SlotFake;
import net.byAqua3.avaritia.item.ItemJsonSingularity;
import net.byAqua3.avaritia.loader.AvaritiaDataComponents;
import net.byAqua3.avaritia.loader.AvaritiaMenus;
import net.byAqua3.avaritia.loader.AvaritiaSingularities;
import net.byAqua3.avaritia.recipe.RecipeCompressor;
import net.byAqua3.avaritia.singularity.Singularity;
import net.byAqua3.avaritia.tile.TileNeutroniumCompressor;
import net.byAqua3.avaritia.util.AvaritiaRecipeUtils;
import net.minecraft.core.component.DataComponentType;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.world.Container;
import net.minecraft.world.SimpleContainer;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.ContainerData;
import net.minecraft.world.inventory.MenuType;
import net.minecraft.world.inventory.SimpleContainerData;
import net.minecraft.world.inventory.Slot;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;

public class MenuNeutroniumCompressor
extends MenuMachine<TileNeutroniumCompressor> {
    public final ContainerData dataAccess;

    public MenuNeutroniumCompressor(int id, Inventory inventory, FriendlyByteBuf friendlyByteBuf) {
        this(id, inventory, (TileNeutroniumCompressor)inventory.player.level().getBlockEntity(friendlyByteBuf.readBlockPos()), (ContainerData)new SimpleContainerData(6));
    }

    public MenuNeutroniumCompressor(int id, Inventory inventory, TileNeutroniumCompressor machineTile, ContainerData dataAccess) {
        super((MenuType)AvaritiaMenus.COMPRESSOR.get(), id, inventory, machineTile);
        this.addSlot(new Slot((Container)machineTile.matrix, 0, 39, 35));
        this.addSlot(new Slot(this, (Container)machineTile.result, 0, 117, 35){

            public boolean mayPlace(ItemStack stack) {
                return false;
            }
        });
        this.addPlayerInventory(8, 84);
        this.dataAccess = dataAccess;
        this.addDataSlots(this.dataAccess);
        this.addSlot(new SlotFake((Container)new SimpleContainer(1), 0, 13, 35){

            public ItemStack getItem() {
                ItemStack stack = MenuNeutroniumCompressor.this.getMatrixItem().copy();
                stack.setCount(1);
                return stack;
            }
        });
        this.addSlot(new SlotFake((Container)new SimpleContainer(1), 0, 147, 35){

            public ItemStack getItem() {
                ItemStack stack = MenuNeutroniumCompressor.this.getResultItem().copy();
                stack.setCount(1);
                return stack;
            }
        });
    }

    protected boolean canRecipe(Level level, ItemStack stack) {
        RecipeCompressor recipe = AvaritiaRecipeUtils.getCompressorRecipe(level, stack);
        if (recipe != null) {
            return recipe.getCost() > 0;
        }
        return false;
    }

    public int getCompressionTarget() {
        return this.dataAccess.get(0);
    }

    public int getConsumptionProgress() {
        return this.dataAccess.get(1);
    }

    public int getCompressionProgress() {
        return this.dataAccess.get(2);
    }

    public ItemStack getMatrixItem() {
        Item item = (Item)BuiltInRegistries.ITEM.byId(this.dataAccess.get(5));
        if (item != null) {
            return new ItemStack((ItemLike)item);
        }
        return ItemStack.EMPTY;
    }

    public ItemStack getResultItem() {
        Item item = (Item)BuiltInRegistries.ITEM.byId(this.dataAccess.get(3));
        int index = this.dataAccess.get(4);
        if (item != null) {
            Singularity singularity;
            ItemStack itemStack = new ItemStack((ItemLike)item);
            if (item instanceof ItemJsonSingularity && index != -1 && (singularity = AvaritiaSingularities.getInstance().getSingularities().get(index)) != null) {
                itemStack.set((DataComponentType)AvaritiaDataComponents.SINGULARITY_ID.get(), (Object)singularity.getId());
            }
            return itemStack;
        }
        return ItemStack.EMPTY;
    }

    public ItemStack quickMoveStack(Player player, int index) {
        ItemStack resultStack = ItemStack.EMPTY;
        Slot slot = (Slot)this.slots.get(index);
        if (slot != null && slot.hasItem()) {
            ItemStack slotStack = slot.getItem();
            resultStack = slotStack.copy();
            if (index == 1) {
                if (!this.moveItemStackTo(slotStack, 2, 38, true)) {
                    return ItemStack.EMPTY;
                }
                slot.onQuickCraft(slotStack, resultStack);
            } else if (index >= 2 && index < 38 ? (!this.canRecipe(player.level(), slotStack) || !this.moveItemStackTo(slotStack, 0, 1, false)) && (index < 29 ? !this.moveItemStackTo(slotStack, 29, 38, false) : !this.moveItemStackTo(slotStack, 2, 29, false)) : !this.moveItemStackTo(slotStack, 2, 38, false)) {
                return ItemStack.EMPTY;
            }
            if (slotStack.isEmpty()) {
                slot.setByPlayer(ItemStack.EMPTY);
            } else {
                slot.setChanged();
            }
            if (slotStack.getCount() == resultStack.getCount()) {
                return ItemStack.EMPTY;
            }
            slot.onTake(player, slotStack);
        }
        return resultStack;
    }
}

