/*
 * Decompiled with CFR 0.152.
 */
package net.byAqua3.avaritia.inventory.slot;

import net.byAqua3.avaritia.loader.AvaritiaRecipes;
import net.byAqua3.avaritia.recipe.RecipeExtremeCrafting;
import net.minecraft.core.NonNullList;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.Container;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.CraftingContainer;
import net.minecraft.world.inventory.ResultSlot;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.CraftingInput;
import net.minecraft.world.item.crafting.CraftingRecipe;
import net.minecraft.world.item.crafting.Recipe;
import net.minecraft.world.item.crafting.RecipeInput;
import net.minecraft.world.item.crafting.RecipeType;
import net.minecraft.world.level.Level;

public class SlotExtremeResult
extends ResultSlot {
    private final CraftingContainer craftSlots;
    private Recipe<CraftingInput> usedRecipe;

    public SlotExtremeResult(Player player, CraftingContainer craftSlots, Container container, int idx, int xPos, int yPos) {
        super(player, craftSlots, container, idx, xPos, yPos);
        this.craftSlots = craftSlots;
    }

    public void setUsedRecipe(Recipe<CraftingInput> usedRecipe) {
        this.usedRecipe = usedRecipe;
    }

    private NonNullList<ItemStack> copyAllInputItems(CraftingInput craftingInput) {
        NonNullList nonNullList = NonNullList.withSize((int)craftingInput.size(), (Object)ItemStack.EMPTY);
        for (int i = 0; i < nonNullList.size(); ++i) {
            nonNullList.set(i, (Object)craftingInput.getItem(i));
        }
        return nonNullList;
    }

    private NonNullList<ItemStack> getRemainingItems(CraftingInput craftingInput, Level level) {
        NonNullList nonNullList;
        if (level instanceof ServerLevel) {
            ServerLevel serverlevel = (ServerLevel)level;
            nonNullList = serverlevel.getServer().getRecipeManager().getRecipeFor((RecipeType)AvaritiaRecipes.EXTREME_CRAFTING.get(), (RecipeInput)craftingInput, (Level)serverlevel).map(recipeHolder -> ((RecipeExtremeCrafting)recipeHolder.value()).getRemainingItems(craftingInput)).orElseGet(() -> this.copyAllInputItems(craftingInput));
        } else {
            nonNullList = CraftingRecipe.defaultCraftingReminder((CraftingInput)craftingInput);
        }
        return nonNullList;
    }

    public void onTake(Player player, ItemStack stack) {
        if (this.usedRecipe == null) {
            return;
        }
        CraftingInput craftingInput = this.craftSlots.asCraftInput();
        int i = this.craftSlots.asPositionedCraftInput().left();
        int j = this.craftSlots.asPositionedCraftInput().top();
        NonNullList<ItemStack> remainingItems = this.getRemainingItems(craftingInput, player.level());
        for (int k = 0; k < craftingInput.height(); ++k) {
            for (int l = 0; l < craftingInput.width(); ++l) {
                int i1 = l + i + (k + j) * this.craftSlots.getWidth();
                ItemStack slotStack = this.craftSlots.getItem(i1);
                ItemStack remainingStack = (ItemStack)remainingItems.get(l + k * craftingInput.width());
                if (!slotStack.isEmpty()) {
                    this.craftSlots.removeItem(i1, 1);
                    slotStack = this.craftSlots.getItem(i1);
                }
                if (remainingStack.isEmpty()) continue;
                if (slotStack.isEmpty()) {
                    this.craftSlots.setItem(i1, remainingStack);
                    continue;
                }
                if (ItemStack.isSameItemSameComponents((ItemStack)slotStack, (ItemStack)remainingStack)) {
                    remainingStack.grow(slotStack.getCount());
                    this.craftSlots.setItem(i1, remainingStack);
                    continue;
                }
                if (player.getInventory().add(remainingStack)) continue;
                player.drop(remainingStack, false);
            }
        }
    }
}

