/*
 * Decompiled with CFR 0.152.
 */
package net.byAqua3.avaritia.item;

import net.byAqua3.avaritia.entity.EntityEndestPearl;
import net.byAqua3.avaritia.item.ItemHalo;
import net.minecraft.advancements.CriteriaTriggers;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;

public class ItemEndestPearl
extends ItemHalo {
    public ItemEndestPearl(Item.Properties properties) {
        super(properties, 2);
    }

    @Override
    public boolean getPulse() {
        return true;
    }

    public InteractionResult use(Level level, Player player, InteractionHand hand) {
        ItemStack stack = player.getItemInHand(hand);
        level.playSound(null, player.getX(), player.getY(), player.getZ(), SoundEvents.ENDER_PEARL_THROW, SoundSource.NEUTRAL, 0.5f, 0.4f / (level.random.nextFloat() * 0.4f + 0.8f));
        player.getCooldowns().addCooldown(stack, 20);
        if (!level.isClientSide) {
            EntityEndestPearl endestPearl = new EntityEndestPearl(level);
            endestPearl.setItem(stack);
            endestPearl.setOwner((Entity)player);
            endestPearl.setPos(player.getX(), player.getEyeY(), player.getZ());
            endestPearl.shootFromRotation((Entity)player, player.getXRot(), player.getYRot(), 0.0f, 1.5f, 1.0f);
            level.addFreshEntity((Entity)endestPearl);
            CriteriaTriggers.SUMMONED_ENTITY.trigger((ServerPlayer)player, (Entity)endestPearl);
        }
        if (!player.isCreative()) {
            stack.shrink(1);
        }
        return InteractionResult.SUCCESS;
    }
}

