/*
 * Decompiled with CFR 0.152.
 */
package net.byAqua3.avaritia.item;

import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.List;
import net.byAqua3.avaritia.event.AvaritiaClientEvent;
import net.byAqua3.avaritia.loader.AvaritiaConfigs;
import net.byAqua3.avaritia.loader.AvaritiaDataComponents;
import net.byAqua3.avaritia.loader.AvaritiaItems;
import net.byAqua3.avaritia.util.TextComponent;
import net.minecraft.ChatFormatting;
import net.minecraft.core.component.DataComponentType;
import net.minecraft.network.chat.Component;
import net.minecraft.world.effect.MobEffect;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.effect.MobEffects;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.entity.item.ItemEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ArmorItem;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.item.equipment.ArmorMaterial;
import net.minecraft.world.item.equipment.ArmorType;
import net.minecraft.world.level.Level;

public class ItemInfinityArmor
extends ArmorItem {
    public ItemInfinityArmor(ArmorMaterial material, ArmorType type, Item.Properties properties) {
        super(material, type, properties.stacksTo(1));
    }

    public boolean hasCustomEntity(ItemStack stack) {
        return true;
    }

    public boolean onEntityItemUpdate(ItemStack stack, ItemEntity itemEntity) {
        itemEntity.setInvulnerable(true);
        return super.onEntityItemUpdate(stack, itemEntity);
    }

    public int getDamage(ItemStack stack) {
        return 0;
    }

    public void appendHoverText(ItemStack stack, Item.TooltipContext context, List<Component> tooltip, TooltipFlag flag) {
        if (this.getEquipmentSlot(stack) == EquipmentSlot.FEET) {
            tooltip.add((Component)TextComponent.getText(""));
            tooltip.add((Component)TextComponent.getText(ChatFormatting.BLUE.toString() + "+" + AvaritiaClientEvent.makeSANIC("SANIC").getString() + ChatFormatting.BLUE.toString() + "% Speed"));
        }
    }

    public void inventoryTick(ItemStack stack, Level level, Entity entity, int slotId, boolean isSelected) {
        super.inventoryTick(stack, level, entity, slotId, isSelected);
        if (entity instanceof Player) {
            Player player = (Player)entity;
            if (this.getEquipmentSlot(stack) == EquipmentSlot.HEAD && slotId == 39) {
                player.setAirSupply(300);
                player.getFoodData().setFoodLevel(20);
                player.getFoodData().setSaturation(20.0f);
                if (((Boolean)AvaritiaConfigs.nightVision.get()).booleanValue()) {
                    player.addEffect(new MobEffectInstance(MobEffects.NIGHT_VISION, 300, 0, false, false));
                }
            } else if (this.getEquipmentSlot(stack) == EquipmentSlot.CHEST && slotId == 38) {
                player.setArrowCount(0);
                player.getAbilities().mayfly = true;
                player.getAbilities().setFlyingSpeed(0.1f);
                if (((Boolean)AvaritiaConfigs.clearBadEffect.get()).booleanValue()) {
                    ArrayList mobEffects = Lists.newArrayList((Iterable)player.getActiveEffects());
                    for (MobEffectInstance mobEffect : mobEffects) {
                        if (((MobEffect)mobEffect.getEffect().value()).isBeneficial()) continue;
                        player.removeEffect(mobEffect.getEffect());
                    }
                }
                stack.update((DataComponentType)AvaritiaDataComponents.FLY.get(), (Object)false, fly -> player.getAbilities().flying);
            } else if (this.getEquipmentSlot(stack) == EquipmentSlot.LEGS && slotId == 37) {
                player.clearFire();
            } else if (this.getEquipmentSlot(stack) == EquipmentSlot.FEET && slotId == 36) {
                player.getAttribute(Attributes.STEP_HEIGHT).setBaseValue(1.0625);
            }
        }
    }

    public EquipmentSlot getEquipmentSlot(ItemStack stack) {
        if (stack.getItem() == AvaritiaItems.INFINITY_HELMET.get()) {
            return EquipmentSlot.HEAD;
        }
        if (stack.getItem() == AvaritiaItems.INFINITY_CHESTPLATE.get()) {
            return EquipmentSlot.CHEST;
        }
        if (stack.getItem() == AvaritiaItems.INFINITY_LEGGINGS.get()) {
            return EquipmentSlot.LEGS;
        }
        if (stack.getItem() == AvaritiaItems.INFINITY_BOOTS.get()) {
            return EquipmentSlot.FEET;
        }
        return null;
    }
}

