/*
 * Decompiled with CFR 0.152.
 */
package net.byAqua3.avaritia.item;

import java.util.ArrayList;
import java.util.List;
import net.byAqua3.avaritia.item.ItemMatterCluster;
import net.byAqua3.avaritia.loader.AvaritiaBlockTags;
import net.byAqua3.avaritia.loader.AvaritiaToolMaterials;
import net.minecraft.core.BlockPos;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.util.Mth;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.item.ItemEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.AxeItem;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.state.BlockState;

public class ItemInfinityAxe
extends AxeItem {
    public ItemInfinityAxe(Item.Properties properties) {
        super(AvaritiaToolMaterials.INFINITY, 29.0f, -3.0f, properties);
    }

    public boolean hasCustomEntity(ItemStack stack) {
        return true;
    }

    public boolean onEntityItemUpdate(ItemStack stack, ItemEntity itemEntity) {
        itemEntity.setInvulnerable(true);
        return super.onEntityItemUpdate(stack, itemEntity);
    }

    public int getDamage(ItemStack stack) {
        return 0;
    }

    public boolean isFoil(ItemStack stack) {
        return false;
    }

    public boolean mineBlock(ItemStack stack, Level level, BlockState state, BlockPos pos, LivingEntity livingEntity) {
        Player player;
        int blockRange = (int)Math.round(8.0);
        if (livingEntity instanceof Player && !(player = (Player)livingEntity).isShiftKeyDown()) {
            for (int x = -blockRange; x <= blockRange; ++x) {
                for (int y = (int)(-Math.round(32.0)); y <= (int)Math.round(32.0); ++y) {
                    for (int z = -blockRange; z <= blockRange; ++z) {
                        BlockPos rangePos = new BlockPos(Mth.floor((float)(pos.getX() + x)), Mth.floor((float)(pos.getY() + y)), Mth.floor((float)(pos.getZ() + z)));
                        BlockState rangeState = level.getBlockState(rangePos);
                        Block rangeBlock = rangeState.getBlock();
                        List tags = rangeState.getTags().toList();
                        if (rangeState.isAir()) continue;
                        if (rangeBlock == Blocks.GRASS_BLOCK) {
                            level.setBlockAndUpdate(rangePos, Blocks.DIRT.defaultBlockState());
                            continue;
                        }
                        if (!tags.contains(AvaritiaBlockTags.INFINITY_AXE)) continue;
                        if (!player.isCreative()) {
                            level.destroyBlock(rangePos, true);
                            continue;
                        }
                        level.destroyBlock(rangePos, false);
                    }
                }
            }
        }
        return super.mineBlock(stack, level, state, pos, livingEntity);
    }

    public InteractionResult use(Level level, Player player, InteractionHand hand) {
        BlockPos blockPos = player.blockPosition();
        if (player.isShiftKeyDown()) {
            int blockRange = (int)Math.round(8.0);
            ArrayList<ItemStack> drops = new ArrayList<ItemStack>();
            for (int x = -blockRange; x <= blockRange; ++x) {
                for (int y = -blockRange; y <= blockRange; ++y) {
                    for (int z = -blockRange; z <= blockRange; ++z) {
                        BlockPos rangePos = new BlockPos(Mth.floor((float)(blockPos.getX() + x)), Mth.floor((float)(blockPos.getY() + y)), Mth.floor((float)(blockPos.getZ() + z)));
                        BlockState rangeState = level.getBlockState(rangePos);
                        Block rangeBlock = rangeState.getBlock();
                        List tags = rangeState.getTags().toList();
                        if (rangeState.isAir()) continue;
                        if (rangeBlock == Blocks.GRASS_BLOCK) {
                            level.setBlockAndUpdate(rangePos, Blocks.DIRT.defaultBlockState());
                            continue;
                        }
                        if (!tags.contains(AvaritiaBlockTags.INFINITY_AXE)) continue;
                        if (!level.isClientSide() && !player.isCreative()) {
                            List blockDrops = Block.getDrops((BlockState)rangeState, (ServerLevel)((ServerLevel)level), (BlockPos)blockPos, null);
                            if (!blockDrops.isEmpty()) {
                                drops.addAll(blockDrops);
                            } else {
                                ResourceLocation blockKey = BuiltInRegistries.BLOCK.getKey((Object)rangeBlock);
                                Item blockItem = (Item)BuiltInRegistries.ITEM.getValue(blockKey);
                                drops.add(new ItemStack((ItemLike)blockItem));
                            }
                        }
                        level.destroyBlock(rangePos, false);
                    }
                }
            }
            if (!level.isClientSide() && !drops.isEmpty()) {
                ItemEntity itemEntity = new ItemEntity(level, (double)blockPos.getX(), (double)blockPos.getY(), (double)blockPos.getZ(), ItemMatterCluster.makeCluster(drops));
                itemEntity.setDefaultPickUpDelay();
                level.addFreshEntity((Entity)itemEntity);
            }
            return InteractionResult.SUCCESS;
        }
        return InteractionResult.PASS;
    }
}

