/*
 * Decompiled with CFR 0.152.
 */
package net.byAqua3.avaritia.item;

import net.byAqua3.avaritia.damage.InfinityDamageSource;
import net.byAqua3.avaritia.event.AvaritiaEvent;
import net.byAqua3.avaritia.loader.AvaritiaToolMaterials;
import net.minecraft.core.Holder;
import net.minecraft.core.registries.Registries;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.damagesource.DamageType;
import net.minecraft.world.damagesource.DamageTypes;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.item.ItemEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.SwordItem;

public class ItemInfinitySword
extends SwordItem {
    public ItemInfinitySword(Item.Properties properties) {
        super(AvaritiaToolMaterials.INFINITY, 2.0f, -2.4f, properties);
    }

    public boolean hasCustomEntity(ItemStack stack) {
        return true;
    }

    public boolean onEntityItemUpdate(ItemStack stack, ItemEntity itemEntity) {
        itemEntity.setInvulnerable(true);
        return super.onEntityItemUpdate(stack, itemEntity);
    }

    public int getDamage(ItemStack stack) {
        return 0;
    }

    public boolean isFoil(ItemStack stack) {
        return false;
    }

    public boolean hurtEnemy(ItemStack stack, LivingEntity entity, LivingEntity attacker) {
        if (entity != null && entity.level() instanceof ServerLevel) {
            ServerLevel serverlevel = (ServerLevel)entity.level();
            Holder.Reference damageType = entity.level().registryAccess().lookupOrThrow(Registries.DAMAGE_TYPE).getOrThrow(DamageTypes.GENERIC_KILL);
            InfinityDamageSource infinityDamageSource = new InfinityDamageSource((Holder<DamageType>)damageType, (Entity)entity, (Entity)attacker);
            if (entity instanceof Player && AvaritiaEvent.isInfinityArmor((Player)entity)) {
                entity.hurtServer(serverlevel, (DamageSource)infinityDamageSource, 4.0f);
                return true;
            }
            entity.hurtServer(serverlevel, (DamageSource)infinityDamageSource, Float.MAX_VALUE);
            entity.setHealth(0.0f);
            entity.die((DamageSource)infinityDamageSource);
        }
        return super.hurtEnemy(stack, entity, attacker);
    }

    public boolean onLeftClickEntity(ItemStack stack, Player player, Entity entity) {
        if (entity instanceof LivingEntity) {
            LivingEntity livingEntity = (LivingEntity)entity;
            if (livingEntity.getHealth() <= 0.0f) {
                livingEntity.remove(Entity.RemovalReason.KILLED);
            } else if (entity.level() instanceof ServerLevel) {
                ServerLevel serverlevel = (ServerLevel)entity.level();
                Holder.Reference damageType = livingEntity.level().registryAccess().lookupOrThrow(Registries.DAMAGE_TYPE).getOrThrow(DamageTypes.GENERIC_KILL);
                InfinityDamageSource infinityDamageSource = new InfinityDamageSource((Holder<DamageType>)damageType, (Entity)livingEntity, (Entity)player);
                if (entity instanceof Player && AvaritiaEvent.isInfinityArmor((Player)entity)) {
                    entity.hurtServer(serverlevel, (DamageSource)infinityDamageSource, 4.0f);
                    return true;
                }
                livingEntity.hurtServer(serverlevel, (DamageSource)infinityDamageSource, Float.MAX_VALUE);
                livingEntity.setHealth(0.0f);
                livingEntity.die((DamageSource)infinityDamageSource);
            }
        }
        return super.onLeftClickEntity(stack, player, entity);
    }
}

