/*
 * Decompiled with CFR 0.152.
 */
package net.byAqua3.avaritia.item;

import it.unimi.dsi.fastutil.objects.Object2IntOpenHashMap;
import java.util.List;
import net.byAqua3.avaritia.component.ClusterContainerContents;
import net.byAqua3.avaritia.loader.AvaritiaDataComponents;
import net.byAqua3.avaritia.loader.AvaritiaItems;
import net.byAqua3.avaritia.loader.AvaritiaTabs;
import net.byAqua3.avaritia.util.TextComponent;
import net.minecraft.ChatFormatting;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.core.component.DataComponentType;
import net.minecraft.network.chat.Component;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.SimpleContainer;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.item.ItemEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;

public class ItemMatterCluster
extends Item {
    public static final int INTERNAL_INV_SIZE = 512;
    public static final int CAPACITY = 4096;

    public ItemMatterCluster(Item.Properties properties) {
        super(properties.stacksTo(1));
        AvaritiaTabs.BLACK_ITEMS.add(this);
    }

    public boolean hasCustomEntity(ItemStack stack) {
        return true;
    }

    public static ItemStack makeCluster(List<ItemStack> itemStacks) {
        SimpleContainer clusterInventory = new SimpleContainer(512);
        int count = 0;
        for (ItemStack itemStack : itemStacks) {
            if (count >= 4096 || !clusterInventory.canAddItem(itemStack)) continue;
            clusterInventory.addItem(itemStack.copy());
            count += itemStack.getCount();
            itemStack.setCount(0);
        }
        if (count > 0) {
            ItemStack cluster = new ItemStack((ItemLike)AvaritiaItems.MATTER_CLUSTER.get());
            cluster.update((DataComponentType)AvaritiaDataComponents.CLUSTER_CONTAINER.get(), (Object)ClusterContainerContents.EMPTY, clusterContainer -> ClusterContainerContents.fromItems((List<ItemStack>)clusterInventory.getItems()));
            return cluster;
        }
        return ItemStack.EMPTY;
    }

    public static List<ItemStack> getClusterItems(ItemStack cluster) {
        ClusterContainerContents clusterContainer = (ClusterContainerContents)cluster.getOrDefault((DataComponentType)AvaritiaDataComponents.CLUSTER_CONTAINER.get(), (Object)ClusterContainerContents.EMPTY);
        return clusterContainer.getItems();
    }

    public static int getClusterCount(List<ItemStack> itemStacks) {
        int itemCount = 0;
        for (ItemStack itemStack : itemStacks) {
            if (itemStack.isEmpty()) continue;
            itemCount += itemStack.getCount();
        }
        return itemCount;
    }

    public void appendHoverText(ItemStack stack, Item.TooltipContext context, List<Component> tooltip, TooltipFlag flag) {
        if (!stack.has((DataComponentType)AvaritiaDataComponents.CLUSTER_CONTAINER.get())) {
            return;
        }
        List<ItemStack> itemStacks = ItemMatterCluster.getClusterItems(stack);
        if (ItemMatterCluster.getClusterCount(itemStacks) > 0) {
            tooltip.add((Component)Component.translatable((String)"tooltip.matter_cluster.counter", (Object[])new Object[]{ItemMatterCluster.getClusterCount(itemStacks), 4096}));
            tooltip.add((Component)TextComponent.getText(""));
        }
        if (Screen.hasShiftDown()) {
            Object2IntOpenHashMap object2IntMap = new Object2IntOpenHashMap();
            for (ItemStack itemStack : itemStacks) {
                if (itemStack.isEmpty()) continue;
                object2IntMap.put((Object)itemStack.getItem(), itemStack.getCount() + object2IntMap.getOrDefault((Object)itemStack.getItem(), 0));
            }
            object2IntMap.forEach((item, count) -> tooltip.add((Component)TextComponent.getText(item.getName().getString() + ChatFormatting.GRAY.toString() + " \u00d7 " + count)));
        } else {
            tooltip.add((Component)Component.translatable((String)"tooltip.matter_cluster.desc").withStyle(ChatFormatting.DARK_GRAY));
            tooltip.add((Component)Component.translatable((String)"tooltip.matter_cluster.desc2").withStyle(ChatFormatting.ITALIC).withStyle(ChatFormatting.DARK_GRAY));
        }
    }

    public InteractionResult use(Level level, Player player, InteractionHand hand) {
        ItemStack stack = player.getItemInHand(hand);
        List<ItemStack> itemStacks = ItemMatterCluster.getClusterItems(stack);
        if (stack.has((DataComponentType)AvaritiaDataComponents.CLUSTER_CONTAINER.get()) && !itemStacks.isEmpty()) {
            if (!level.isClientSide()) {
                for (ItemStack itemStack : itemStacks) {
                    ItemEntity itemEntity = new ItemEntity(level, player.getX(), player.getY(), player.getZ(), itemStack);
                    itemEntity.setDefaultPickUpDelay();
                    level.addFreshEntity((Entity)itemEntity);
                }
            }
            player.setItemInHand(hand, ItemStack.EMPTY);
        }
        return InteractionResult.SUCCESS;
    }
}

