/*
 * Decompiled with CFR 0.152.
 */
package net.byAqua3.avaritia.loader;

import net.byAqua3.avaritia.entity.EntityEndestPearl;
import net.byAqua3.avaritia.entity.EntityGapingVoid;
import net.byAqua3.avaritia.entity.EntityInfinityArrow;
import net.byAqua3.avaritia.render.RenderGapingVoid;
import net.byAqua3.avaritia.render.RenderInfinityArrow;
import net.byAqua3.avaritia.render.layer.RenderInfinityArmor;
import net.minecraft.client.model.HumanoidModel;
import net.minecraft.client.renderer.entity.EntityRenderer;
import net.minecraft.client.renderer.entity.LivingEntityRenderer;
import net.minecraft.client.renderer.entity.RenderLayerParent;
import net.minecraft.client.renderer.entity.ThrownItemRenderer;
import net.minecraft.client.renderer.entity.layers.RenderLayer;
import net.minecraft.client.renderer.entity.state.HumanoidRenderState;
import net.minecraft.client.resources.PlayerSkin;
import net.minecraft.core.Registry;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.core.registries.Registries;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.MobCategory;
import net.neoforged.api.distmarker.Dist;
import net.neoforged.api.distmarker.OnlyIn;
import net.neoforged.bus.api.IEventBus;
import net.neoforged.bus.api.SubscribeEvent;
import net.neoforged.fml.common.EventBusSubscriber;
import net.neoforged.neoforge.client.event.EntityRenderersEvent;
import net.neoforged.neoforge.registries.DeferredHolder;
import net.neoforged.neoforge.registries.DeferredRegister;

public class AvaritiaEntities {
    public static final DeferredRegister<EntityType<?>> ENTITY_TYPES = DeferredRegister.create((Registry)BuiltInRegistries.ENTITY_TYPE, (String)"avaritia");
    public static final DeferredHolder<EntityType<?>, EntityType<EntityInfinityArrow>> INFINITY_ARROW = ENTITY_TYPES.register("infinity_arrow", id -> EntityType.Builder.of(EntityInfinityArrow::new, (MobCategory)MobCategory.MISC).clientTrackingRange(4).updateInterval(20).sized(0.5f, 0.5f).build(ResourceKey.create((ResourceKey)Registries.ENTITY_TYPE, (ResourceLocation)id)));
    public static final DeferredHolder<EntityType<?>, EntityType<EntityEndestPearl>> ENDEST_PEARL = ENTITY_TYPES.register("endest_pearl", id -> EntityType.Builder.of(EntityEndestPearl::new, (MobCategory)MobCategory.MISC).clientTrackingRange(4).updateInterval(10).sized(0.25f, 0.25f).build(ResourceKey.create((ResourceKey)Registries.ENTITY_TYPE, (ResourceLocation)id)));
    public static final DeferredHolder<EntityType<?>, EntityType<EntityGapingVoid>> GAPING_VOID = ENTITY_TYPES.register("gaping_void", id -> EntityType.Builder.of(EntityGapingVoid::new, (MobCategory)MobCategory.MISC).clientTrackingRange(16).updateInterval(10).sized(0.1f, 0.1f).build(ResourceKey.create((ResourceKey)Registries.ENTITY_TYPE, (ResourceLocation)id)));

    public static void registerEntities(IEventBus modEventBus) {
        ENTITY_TYPES.register(modEventBus);
        modEventBus.addListener(AvaritiaEntities::onRegisterRenderer);
    }

    @SubscribeEvent
    public static void onRegisterRenderer(EntityRenderersEvent.RegisterRenderers event) {
        event.registerEntityRenderer((EntityType)INFINITY_ARROW.get(), RenderInfinityArrow::new);
        event.registerEntityRenderer((EntityType)ENDEST_PEARL.get(), ThrownItemRenderer::new);
        event.registerEntityRenderer((EntityType)GAPING_VOID.get(), RenderGapingVoid::new);
    }

    @EventBusSubscriber(value={Dist.CLIENT}, modid="avaritia", bus=EventBusSubscriber.Bus.MOD)
    public class AvaritiaLayers {
        public AvaritiaLayers(AvaritiaEntities this$0) {
        }

        @OnlyIn(value=Dist.CLIENT)
        @SubscribeEvent
        public static void onAddLayers(EntityRenderersEvent.AddLayers event) {
            EntityRenderer entityRenderer;
            for (EntityType entityType : event.getEntityTypes()) {
                LivingEntityRenderer livingEntityRenderer;
                entityRenderer = event.getRenderer(entityType);
                if (!(entityRenderer instanceof LivingEntityRenderer) || !((livingEntityRenderer = (LivingEntityRenderer)entityRenderer).getModel() instanceof HumanoidModel)) continue;
                livingEntityRenderer.addLayer((RenderLayer)new RenderInfinityArmor((RenderLayerParent<HumanoidRenderState, HumanoidModel<HumanoidRenderState>>)livingEntityRenderer, event.getEntityModels(), false));
            }
            for (PlayerSkin.Model model : event.getSkins()) {
                entityRenderer = (LivingEntityRenderer)event.getSkin(model);
                entityRenderer.addLayer((RenderLayer)new RenderInfinityArmor((RenderLayerParent<HumanoidRenderState, HumanoidModel<HumanoidRenderState>>)entityRenderer, event.getEntityModels(), model == PlayerSkin.Model.SLIM));
            }
        }
    }
}

