/*
 * Decompiled with CFR 0.152.
 */
package net.byAqua3.avaritia.loader;

import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonParser;
import com.mojang.serialization.DataResult;
import com.mojang.serialization.Dynamic;
import com.mojang.serialization.DynamicOps;
import com.mojang.serialization.JsonOps;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.Reader;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import net.byAqua3.avaritia.Avaritia;
import net.byAqua3.avaritia.singularity.Singularity;
import net.minecraft.server.packs.resources.Resource;
import net.minecraft.server.packs.resources.ResourceManager;
import net.neoforged.neoforge.common.conditions.ICondition;

public class AvaritiaSingularities {
    private static final AvaritiaSingularities INSTANCE = new AvaritiaSingularities();
    private final List<Singularity> singularities = new ArrayList<Singularity>();

    public static AvaritiaSingularities getInstance() {
        return INSTANCE;
    }

    public static List<Singularity> loadSingularities(ResourceManager resourceManager) {
        Long lastTime = System.currentTimeMillis();
        ArrayList<Singularity> singularities = new ArrayList<Singularity>();
        Map map = resourceManager.listResourceStacks("singularities", resourceLocation -> resourceLocation.getPath().endsWith(".json"));
        for (List resources : map.values()) {
            for (Resource resource : resources) {
                try {
                    BufferedReader bufferedReader = resource.openAsReader();
                    JsonElement jsonElement = JsonParser.parseReader((Reader)bufferedReader);
                    JsonObject jsonObject = jsonElement.getAsJsonObject();
                    if (jsonObject.has("neoforge:conditions")) {
                        JsonElement conditions = jsonObject.get("neoforge:conditions");
                        DataResult dataResult = ICondition.LIST_CODEC.parse(new Dynamic((DynamicOps)JsonOps.INSTANCE, (Object)conditions));
                        if (!dataResult.isSuccess()) continue;
                        if (dataResult.result().isPresent()) {
                            List iconditions = (List)dataResult.result().get();
                            boolean skip = false;
                            for (ICondition icondition : iconditions) {
                                if (icondition.test(ICondition.IContext.EMPTY)) continue;
                                skip = true;
                            }
                            if (skip) continue;
                        }
                    }
                    String id = jsonObject.get("id").getAsString();
                    int color = jsonObject.getAsJsonArray("color").get(0).getAsInt();
                    int layerColor = jsonObject.getAsJsonArray("color").get(1).getAsInt();
                    Singularity singularity = new Singularity(id, color, layerColor);
                    singularities.add(singularity);
                }
                catch (IOException e) {
                    e.printStackTrace();
                }
            }
        }
        Avaritia.LOGGER.info("Finished loading {} singularities json after {}ms", (Object)singularities.size(), (Object)(System.currentTimeMillis() - lastTime));
        return singularities;
    }

    public List<Singularity> getSingularities() {
        return this.singularities;
    }

    public Singularity getSingularity(String id) {
        for (Singularity singularity : this.singularities) {
            if (!singularity.id.equalsIgnoreCase(id)) continue;
            return singularity;
        }
        return null;
    }
}

