/*
 * Decompiled with CFR 0.152.
 */
package net.byAqua3.avaritia.mixin;

import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.VertexConsumer;
import java.util.List;
import net.byAqua3.avaritia.loader.AvaritiaAtlas;
import net.byAqua3.avaritia.shader.AvaritiaCosmicShaders;
import net.byAqua3.avaritia.shader.AvaritiaRenderType;
import net.byAqua3.avaritia.util.AvaritiaRenderUtils;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.CompiledShaderProgram;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.client.renderer.ShaderManager;
import net.minecraft.client.renderer.block.model.BakedQuad;
import net.minecraft.client.renderer.entity.ItemRenderer;
import net.minecraft.client.renderer.item.ItemStackRenderState;
import net.minecraft.client.renderer.texture.TextureAtlasSprite;
import net.minecraft.client.resources.model.BakedModel;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.ItemDisplayContext;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;

@Mixin(value={ItemRenderer.class})
public class MixinItemRenderer {
    @Inject(method={"renderItem"}, at={@At(value="HEAD")}, cancellable=true)
    private static void renderItem(ItemDisplayContext context, PoseStack poseStack, MultiBufferSource multiBufferSource, int packedLight, int packedOverlay, int[] tintLayers, BakedModel model, RenderType renderType, ItemStackRenderState.FoilType foilType, CallbackInfo callbackInfo) {
        ResourceLocation name = model.getParticleIcon().contents().name;
        if (name.getNamespace().equals("avaritia") && name.getPath().startsWith("item/tools/bow/pull_")) {
            callbackInfo.cancel();
            poseStack.pushPose();
            RenderType COSMIC_RENDER_TYPE = AvaritiaRenderType.COSMIC_RENDER_TYPE;
            Minecraft mc = Minecraft.getInstance();
            VertexConsumer vertexConsumer = multiBufferSource.getBuffer(renderType);
            ItemRenderer.renderModelLists((BakedModel)model, (int[])tintLayers, (int)packedLight, (int)packedOverlay, (PoseStack)poseStack, (VertexConsumer)vertexConsumer);
            if (multiBufferSource instanceof MultiBufferSource.BufferSource) {
                MultiBufferSource.BufferSource bufferSource = (MultiBufferSource.BufferSource)multiBufferSource;
                bufferSource.endBatch();
            }
            float yaw = 0.0f;
            float pitch = 0.0f;
            float scale = 1.0f;
            if (AvaritiaCosmicShaders.cosmicInventoryRender || context == ItemDisplayContext.GUI) {
                scale = 100.0f;
            } else {
                yaw = (float)((double)(mc.player.getYRot() * 2.0f) * Math.PI / 360.0);
                pitch = -((float)((double)(mc.player.getXRot() * 2.0f) * Math.PI / 360.0));
            }
            ShaderManager shaderManager = Minecraft.getInstance().getShaderManager();
            CompiledShaderProgram compiledShaderProgram = shaderManager.getProgram(AvaritiaCosmicShaders.cosmicShader);
            compiledShaderProgram.getUniform("time").set((float)(mc.level.getGameTime() % Integer.MAX_VALUE));
            compiledShaderProgram.getUniform("yaw").set(yaw);
            compiledShaderProgram.getUniform("pitch").set(pitch);
            compiledShaderProgram.getUniform("externalScale").set(scale);
            compiledShaderProgram.getUniform("opacity").set(1.0f);
            compiledShaderProgram.getUniform("cosmicuvs").set(AvaritiaCosmicShaders.COSMIC_UVS);
            TextureAtlasSprite[] textureAtlasSprites = null;
            if (name.equals((Object)ResourceLocation.tryBuild((String)"avaritia", (String)"item/tools/bow/pull_0"))) {
                textureAtlasSprites = new TextureAtlasSprite[]{Minecraft.getInstance().getModelManager().getAtlas(AvaritiaAtlas.BLOCK_ATLAS).getSprite(ResourceLocation.tryBuild((String)"avaritia", (String)"item/tools/bow/pull_0_mask"))};
            } else if (name.equals((Object)ResourceLocation.tryBuild((String)"avaritia", (String)"item/tools/bow/pull_1"))) {
                textureAtlasSprites = new TextureAtlasSprite[]{Minecraft.getInstance().getModelManager().getAtlas(AvaritiaAtlas.BLOCK_ATLAS).getSprite(ResourceLocation.tryBuild((String)"avaritia", (String)"item/tools/bow/pull_1_mask"))};
            } else if (name.equals((Object)ResourceLocation.tryBuild((String)"avaritia", (String)"item/tools/bow/pull_2"))) {
                textureAtlasSprites = new TextureAtlasSprite[]{Minecraft.getInstance().getModelManager().getAtlas(AvaritiaAtlas.BLOCK_ATLAS).getSprite(ResourceLocation.tryBuild((String)"avaritia", (String)"item/tools/bow/pull_2_mask"))};
            }
            if (textureAtlasSprites != null) {
                List<BakedQuad> quads = AvaritiaRenderUtils.bakeItem(textureAtlasSprites);
                for (BakedQuad quad : quads) {
                    multiBufferSource.getBuffer(COSMIC_RENDER_TYPE).putBulkData(poseStack.last(), quad, 1.0f, 1.0f, 1.0f, 1.0f, packedLight, packedOverlay, true);
                }
            }
            poseStack.popPose();
        }
    }
}

