/*
 * Decompiled with CFR 0.152.
 */
package net.byAqua3.avaritia.mixin;

import java.util.Objects;
import net.byAqua3.avaritia.loader.AvaritiaDataComponents;
import net.minecraft.core.component.DataComponentType;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Shadow;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfoReturnable;

@Mixin(value={ItemStack.class})
public class MixinItemStack {
    @Shadow
    private Item item;
    @Shadow
    private int count;

    @Inject(method={"getMaxStackSize"}, at={@At(value="HEAD")}, cancellable=true)
    public void getMaxStackSize(CallbackInfoReturnable<Integer> callbackInfo) {
        ItemStack itemStack;
        if (this.item != null && (itemStack = (ItemStack)this).has((DataComponentType)AvaritiaDataComponents.MAX_STACK_SIZE.get())) {
            callbackInfo.setReturnValue((Object)((Integer)itemStack.get((DataComponentType)AvaritiaDataComponents.MAX_STACK_SIZE.get())));
            callbackInfo.cancel();
        }
    }

    @Inject(method={"isSameItemSameComponents"}, at={@At(value="HEAD")}, cancellable=true)
    private static void isSameItemSameComponents(ItemStack stack, ItemStack other, CallbackInfoReturnable<Boolean> callbackInfo) {
        ItemStack copy1 = stack.copy();
        ItemStack copy2 = other.copy();
        if (copy1.has((DataComponentType)AvaritiaDataComponents.MAX_STACK_SIZE.get()) || copy2.has((DataComponentType)AvaritiaDataComponents.MAX_STACK_SIZE.get())) {
            if (copy1.has((DataComponentType)AvaritiaDataComponents.MAX_STACK_SIZE.get())) {
                copy1.remove((DataComponentType)AvaritiaDataComponents.MAX_STACK_SIZE.get());
            }
            if (copy2.has((DataComponentType)AvaritiaDataComponents.MAX_STACK_SIZE.get())) {
                copy2.remove((DataComponentType)AvaritiaDataComponents.MAX_STACK_SIZE.get());
            }
            callbackInfo.setReturnValue((Object)Objects.equals(copy1.getComponents(), copy2.getComponents()));
            callbackInfo.cancel();
        }
    }
}

