/*
 * Decompiled with CFR 0.152.
 */
package net.byAqua3.avaritia.model;

import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.VertexConsumer;
import java.awt.Color;
import net.byAqua3.avaritia.event.AvaritiaClientEvent;
import net.byAqua3.avaritia.loader.AvaritiaAtlas;
import net.byAqua3.avaritia.loader.AvaritiaDataComponents;
import net.byAqua3.avaritia.loader.AvaritiaItems;
import net.byAqua3.avaritia.shader.AvaritiaCosmicShaders;
import net.byAqua3.avaritia.shader.AvaritiaRenderType;
import net.minecraft.client.Minecraft;
import net.minecraft.client.model.AnimationUtils;
import net.minecraft.client.model.HumanoidModel;
import net.minecraft.client.model.geom.ModelPart;
import net.minecraft.client.model.geom.PartPose;
import net.minecraft.client.model.geom.builders.CubeDeformation;
import net.minecraft.client.model.geom.builders.CubeListBuilder;
import net.minecraft.client.model.geom.builders.LayerDefinition;
import net.minecraft.client.model.geom.builders.MeshDefinition;
import net.minecraft.client.model.geom.builders.PartDefinition;
import net.minecraft.client.renderer.CompiledShaderProgram;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.client.renderer.ShaderManager;
import net.minecraft.client.renderer.entity.state.ArmorStandRenderState;
import net.minecraft.client.renderer.entity.state.HumanoidRenderState;
import net.minecraft.client.renderer.entity.state.PlayerRenderState;
import net.minecraft.client.renderer.entity.state.ZombieRenderState;
import net.minecraft.client.renderer.texture.TextureAtlasSprite;
import net.minecraft.core.component.DataComponentType;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;

public class ModelInfinityArmor
extends HumanoidModel<HumanoidRenderState> {
    public static final ResourceLocation EYE = ResourceLocation.tryBuild((String)"avaritia", (String)"textures/entity/equipment/infinity/infinity_armor_eyes.png");
    public static final ResourceLocation WING = ResourceLocation.tryBuild((String)"avaritia", (String)"textures/entity/equipment/infinity/infinity_armor_wing.png");
    public static final ResourceLocation WING_GLOW = ResourceLocation.tryBuild((String)"avaritia", (String)"textures/entity/equipment/infinity/infinity_armor_wingglow.png");
    public static final TextureAtlasSprite MASK = Minecraft.getInstance().getModelManager().getAtlas(AvaritiaAtlas.BLOCK_ATLAS).getSprite(ResourceLocation.tryBuild((String)"avaritia", (String)"entity/equipment/infinity/infinity_armor_mask"));
    public static final TextureAtlasSprite MASK_INV = Minecraft.getInstance().getModelManager().getAtlas(AvaritiaAtlas.BLOCK_ATLAS).getSprite(ResourceLocation.tryBuild((String)"avaritia", (String)"entity/equipment/infinity/infinity_armor_mask_inv"));
    public static final TextureAtlasSprite WING_MASK = Minecraft.getInstance().getModelManager().getAtlas(AvaritiaAtlas.BLOCK_ATLAS).getSprite(ResourceLocation.tryBuild((String)"avaritia", (String)"entity/equipment/infinity/infinity_armor_mask_wings"));
    public final ModelPart root = ModelInfinityArmor.createLayer().bakeRoot();
    public final ModelPart bodyRoot = ModelInfinityArmor.createBodyLayer(new CubeDeformation(1.0f)).bakeRoot();
    private boolean isSilm;

    public ModelInfinityArmor(ModelPart root, boolean isSilm) {
        super(root);
        this.isSilm = isSilm;
    }

    public static LayerDefinition createLayer() {
        MeshDefinition meshDefinition = new MeshDefinition();
        PartDefinition partDefinition = meshDefinition.getRoot();
        CubeDeformation cubeDeformation = new CubeDeformation(0.0f);
        partDefinition.addOrReplaceChild("left_wing", CubeListBuilder.create().texOffs(0, 0).addBox(0.0f, -11.6f, 0.0f, 0.0f, 32.0f, 32.0f, cubeDeformation), PartPose.offsetAndRotation((float)-1.5f, (float)0.0f, (float)2.0f, (float)0.0f, (float)1.2566371f, (float)0.0f));
        partDefinition.addOrReplaceChild("right_wing", CubeListBuilder.create().texOffs(0, 0).mirror().addBox(0.0f, -11.6f, 0.0f, 0.0f, 32.0f, 32.0f, cubeDeformation), PartPose.offsetAndRotation((float)1.5f, (float)0.0f, (float)2.0f, (float)0.0f, (float)-1.2566371f, (float)0.0f));
        return LayerDefinition.create((MeshDefinition)meshDefinition, (int)64, (int)64);
    }

    public static LayerDefinition createBodyLayer(CubeDeformation cubDeformation) {
        MeshDefinition meshDefinition = HumanoidModel.createMesh((CubeDeformation)cubDeformation, (float)0.0f);
        PartDefinition partDefinition = meshDefinition.getRoot();
        partDefinition.addOrReplaceChild("hat", CubeListBuilder.create().texOffs(32, 0).addBox(-4.0f, -8.0f, -4.0f, 8.0f, 8.0f, 8.0f, cubDeformation.extend(-0.1f)), PartPose.offset((float)0.0f, (float)0.0f, (float)0.0f));
        partDefinition.addOrReplaceChild("left_leg", CubeListBuilder.create().texOffs(0, 48).mirror().addBox(-2.0f, 0.0f, -2.0f, 4.0f, 12.0f, 4.0f, cubDeformation.extend(-0.6f)), PartPose.offset((float)1.9f, (float)12.0f, (float)0.0f));
        partDefinition.addOrReplaceChild("right_leg", CubeListBuilder.create().texOffs(0, 48).addBox(-2.0f, 0.0f, -2.0f, 4.0f, 12.0f, 4.0f, cubDeformation.extend(-0.6f)), PartPose.offset((float)-1.9f, (float)12.0f, (float)0.0f));
        partDefinition.addOrReplaceChild("left_boot", CubeListBuilder.create().texOffs(0, 16).mirror().addBox(-2.0f, 0.0f, -2.0f, 4.0f, 12.0f, 4.0f, cubDeformation.extend(-0.1f)), PartPose.offset((float)1.9f, (float)12.0f, (float)0.0f));
        partDefinition.addOrReplaceChild("right_boot", CubeListBuilder.create().texOffs(0, 16).addBox(-2.0f, 0.0f, -2.0f, 4.0f, 12.0f, 4.0f, cubDeformation.extend(-0.1f)), PartPose.offset((float)-1.9f, (float)12.0f, (float)0.0f));
        return LayerDefinition.create((MeshDefinition)meshDefinition, (int)64, (int)64);
    }

    public void setScale(ModelPart modelPart, float scale) {
        modelPart.xScale = scale;
        modelPart.yScale = scale;
        modelPart.zScale = scale;
    }

    public void setupAnim(HumanoidRenderState humanoidRenderState) {
        super.setupAnim(humanoidRenderState);
        ModelPart leftWing = this.root.getChild("left_wing");
        leftWing.xRot = this.body.xRot;
        leftWing.yRot = this.body.yRot + 1.2566371f;
        leftWing.zRot = this.body.zRot;
        ModelPart rightWing = this.root.getChild("right_wing");
        rightWing.xRot = this.body.xRot;
        rightWing.yRot = this.body.yRot + -1.2566371f;
        rightWing.zRot = this.body.zRot;
        if (humanoidRenderState instanceof ArmorStandRenderState) {
            ArmorStandRenderState armorStandRenderState = (ArmorStandRenderState)humanoidRenderState;
            this.head.y = 1.0f;
            this.head.xRot = (float)Math.PI / 180 * armorStandRenderState.headPose.getX();
            this.head.yRot = (float)Math.PI / 180 * armorStandRenderState.headPose.getY();
            this.head.zRot = (float)Math.PI / 180 * armorStandRenderState.headPose.getZ();
            this.leftArm.xRot = (float)Math.PI / 180 * armorStandRenderState.leftArmPose.getX();
            this.leftArm.yRot = (float)Math.PI / 180 * armorStandRenderState.leftArmPose.getY();
            this.leftArm.zRot = (float)Math.PI / 180 * armorStandRenderState.leftArmPose.getZ();
            this.rightArm.xRot = (float)Math.PI / 180 * armorStandRenderState.rightArmPose.getX();
            this.rightArm.yRot = (float)Math.PI / 180 * armorStandRenderState.rightArmPose.getY();
            this.rightArm.zRot = (float)Math.PI / 180 * armorStandRenderState.rightArmPose.getZ();
            this.leftLeg.xRot = (float)Math.PI / 180 * armorStandRenderState.leftLegPose.getX();
            this.leftLeg.yRot = (float)Math.PI / 180 * armorStandRenderState.leftLegPose.getY();
            this.leftLeg.zRot = (float)Math.PI / 180 * armorStandRenderState.leftLegPose.getZ();
            this.rightLeg.xRot = (float)Math.PI / 180 * armorStandRenderState.rightLegPose.getX();
            this.rightLeg.yRot = (float)Math.PI / 180 * armorStandRenderState.rightLegPose.getY();
            this.rightLeg.zRot = (float)Math.PI / 180 * armorStandRenderState.rightLegPose.getZ();
        }
        ModelPart head = this.bodyRoot.getChild("head");
        head.getChild((String)"hat").visible = false;
        head.copyFrom(this.head);
        ModelPart hat = this.bodyRoot.getChild("hat");
        hat.copyFrom(this.head);
        ModelPart body = this.bodyRoot.getChild("body");
        body.copyFrom(this.body);
        if (humanoidRenderState instanceof ZombieRenderState) {
            ZombieRenderState zombieRenderState = (ZombieRenderState)humanoidRenderState;
            AnimationUtils.animateZombieArms((ModelPart)this.leftArm, (ModelPart)this.rightArm, (boolean)zombieRenderState.isAggressive, (float)zombieRenderState.attackTime, (float)zombieRenderState.ageInTicks);
        }
        ModelPart leftArm = this.bodyRoot.getChild("left_arm");
        leftArm.copyFrom(this.leftArm);
        if (!this.isSilm) {
            this.setScale(this.leftArm, 1.01f);
        } else {
            this.leftArm.x -= 0.3f;
            this.leftArm.xScale = 0.8f;
            this.leftArm.yScale = 1.01f;
        }
        this.setScale(leftArm, 1.0f);
        ModelPart rightArm = this.bodyRoot.getChild("right_arm");
        rightArm.copyFrom(this.rightArm);
        if (!this.isSilm) {
            this.setScale(this.rightArm, 1.01f);
        } else {
            this.rightArm.x += 0.3f;
            this.rightArm.xScale = 0.8f;
            this.rightArm.yScale = 1.01f;
        }
        this.setScale(rightArm, 1.0f);
        ModelPart leftLeg = this.bodyRoot.getChild("left_leg");
        leftLeg.copyFrom(this.leftLeg);
        ModelPart rightLeg = this.bodyRoot.getChild("right_leg");
        rightLeg.copyFrom(this.rightLeg);
        ModelPart leftBoot = this.bodyRoot.getChild("left_boot");
        leftBoot.copyFrom(this.leftLeg);
        ModelPart rightBoot = this.bodyRoot.getChild("right_boot");
        rightBoot.copyFrom(this.rightLeg);
    }

    public void render(HumanoidRenderState humanoidRenderState, PoseStack poseStack, MultiBufferSource multiBufferSource, VertexConsumer vertexConsumer, int packedLight, int packedOverlay, float red, float green, float blue, float alpha) {
        RenderType COSMIC_ARMOR_RENDER_TYPE = AvaritiaRenderType.COSMIC_ARMOR_RENDER_TYPE;
        Minecraft mc = Minecraft.getInstance();
        Item headItem = humanoidRenderState.headEquipment.getItem();
        Item chestItem = humanoidRenderState.chestEquipment.getItem();
        Item legsItem = humanoidRenderState.legsEquipment.getItem();
        Item feetItem = humanoidRenderState.feetEquipment.getItem();
        long time = mc.level.getGameTime();
        double pulse = Math.sin((double)time / 10.0) * 0.5 + 0.5;
        double pulse_mag_sqr = pulse * pulse * pulse * pulse * pulse * pulse;
        float yaw = 0.0f;
        float pitch = 0.0f;
        float scale = 1.0f;
        if (AvaritiaCosmicShaders.cosmicInventoryRender) {
            scale = 100.0f;
        } else {
            yaw = (float)((double)(humanoidRenderState.yRot * 2.0f) * Math.PI / 360.0);
            pitch = -((float)((double)(humanoidRenderState.xRot * 2.0f) * Math.PI / 360.0));
        }
        ShaderManager shaderManager = Minecraft.getInstance().getShaderManager();
        CompiledShaderProgram compiledShaderProgram = shaderManager.getProgram(AvaritiaCosmicShaders.cosmicArmorShader);
        compiledShaderProgram.getUniform("time").set((float)(mc.level.getGameTime() % Integer.MAX_VALUE));
        compiledShaderProgram.getUniform("yaw").set(yaw);
        compiledShaderProgram.getUniform("pitch").set(pitch);
        compiledShaderProgram.getUniform("externalScale").set(scale);
        compiledShaderProgram.getUniform("opacity").set(1.0f);
        compiledShaderProgram.getUniform("cosmicuvs").set(AvaritiaCosmicShaders.COSMIC_UVS);
        if (humanoidRenderState instanceof PlayerRenderState) {
            PlayerRenderState playerRenderState = (PlayerRenderState)humanoidRenderState;
            ItemStack itemStack = playerRenderState.chestEquipment;
            if (chestItem == AvaritiaItems.INFINITY_CHESTPLATE.get() && itemStack.has((DataComponentType)AvaritiaDataComponents.FLY.get()) && ((Boolean)itemStack.getOrDefault((DataComponentType)AvaritiaDataComponents.FLY.get(), (Object)false)).booleanValue()) {
                poseStack.pushPose();
                ModelPart leftWing = this.root.getChild("left_wing");
                ModelPart rightWing = this.root.getChild("right_wing");
                leftWing.render(poseStack, vertexConsumer, packedLight, packedOverlay);
                rightWing.render(poseStack, vertexConsumer, packedLight, packedOverlay);
                leftWing.render(poseStack, WING_MASK.wrap(multiBufferSource.getBuffer(COSMIC_ARMOR_RENDER_TYPE)), packedLight, packedOverlay, new Color(red, green, blue, alpha).getRGB());
                rightWing.render(poseStack, WING_MASK.wrap(multiBufferSource.getBuffer(COSMIC_ARMOR_RENDER_TYPE)), packedLight, packedOverlay, new Color(red, green, blue, alpha).getRGB());
                leftWing.render(poseStack, multiBufferSource.getBuffer(AvaritiaRenderType.WingGlow(WING_GLOW)), packedLight, packedOverlay, new Color(0.84f, 1.0f, 0.95f, (float)(pulse_mag_sqr * 0.5)).getRGB());
                rightWing.render(poseStack, multiBufferSource.getBuffer(AvaritiaRenderType.WingGlow(WING_GLOW)), packedLight, packedOverlay, new Color(0.84f, 1.0f, 0.95f, (float)(pulse_mag_sqr * 0.5)).getRGB());
                poseStack.popPose();
            }
        }
        if (headItem == AvaritiaItems.INFINITY_HELMET.get()) {
            poseStack.pushPose();
            ModelPart head = this.bodyRoot.getChild("head");
            head.render(poseStack, MASK.wrap(multiBufferSource.getBuffer(COSMIC_ARMOR_RENDER_TYPE)), packedLight, packedOverlay, new Color(red, green, blue, alpha).getRGB());
            ModelPart hat = this.bodyRoot.getChild("hat");
            hat.render(poseStack, MASK.wrap(multiBufferSource.getBuffer(COSMIC_ARMOR_RENDER_TYPE)), packedLight, packedOverlay, new Color(red, green, blue, alpha).getRGB());
            poseStack.popPose();
        }
        if (chestItem == AvaritiaItems.INFINITY_CHESTPLATE.get()) {
            poseStack.pushPose();
            ModelPart body = this.bodyRoot.getChild("body");
            body.render(poseStack, MASK.wrap(multiBufferSource.getBuffer(COSMIC_ARMOR_RENDER_TYPE)), packedLight, packedOverlay, new Color(red, green, blue, alpha).getRGB());
            body.render(poseStack, multiBufferSource.getBuffer(AvaritiaRenderType.WingGlow(EYE)), packedLight, packedOverlay, new Color(0.84f, 1.0f, 0.95f, (float)(pulse_mag_sqr * 0.5)).getRGB());
            ModelPart leftArm = this.bodyRoot.getChild("left_arm");
            leftArm.render(poseStack, MASK.wrap(multiBufferSource.getBuffer(COSMIC_ARMOR_RENDER_TYPE)), packedLight, packedOverlay, new Color(red, green, blue, alpha).getRGB());
            leftArm.render(poseStack, multiBufferSource.getBuffer(AvaritiaRenderType.WingGlow(EYE)), packedLight, packedOverlay, new Color(0.84f, 1.0f, 0.95f, (float)(pulse_mag_sqr * 0.5)).getRGB());
            ModelPart rightArm = this.bodyRoot.getChild("right_arm");
            rightArm.render(poseStack, MASK.wrap(multiBufferSource.getBuffer(COSMIC_ARMOR_RENDER_TYPE)), packedLight, packedOverlay, new Color(red, green, blue, alpha).getRGB());
            rightArm.render(poseStack, multiBufferSource.getBuffer(AvaritiaRenderType.WingGlow(EYE)), packedLight, packedOverlay, new Color(0.84f, 1.0f, 0.95f, (float)(pulse_mag_sqr * 0.5)).getRGB());
            poseStack.popPose();
        }
        if (legsItem == AvaritiaItems.INFINITY_LEGGINGS.get()) {
            poseStack.pushPose();
            ModelPart leftLeg = this.bodyRoot.getChild("left_leg");
            leftLeg.render(poseStack, MASK.wrap(multiBufferSource.getBuffer(COSMIC_ARMOR_RENDER_TYPE)), packedLight, packedOverlay, new Color(red, green, blue, alpha).getRGB());
            leftLeg.render(poseStack, multiBufferSource.getBuffer(AvaritiaRenderType.WingGlow(EYE)), packedLight, packedOverlay, new Color(0.84f, 1.0f, 0.95f, (float)(pulse_mag_sqr * 0.5)).getRGB());
            ModelPart rightLeg = this.bodyRoot.getChild("right_leg");
            rightLeg.render(poseStack, MASK.wrap(multiBufferSource.getBuffer(COSMIC_ARMOR_RENDER_TYPE)), packedLight, packedOverlay, new Color(red, green, blue, alpha).getRGB());
            rightLeg.render(poseStack, multiBufferSource.getBuffer(AvaritiaRenderType.WingGlow(EYE)), packedLight, packedOverlay, new Color(0.84f, 1.0f, 0.95f, (float)(pulse_mag_sqr * 0.5)).getRGB());
            poseStack.popPose();
        }
        if (feetItem == AvaritiaItems.INFINITY_BOOTS.get()) {
            poseStack.pushPose();
            ModelPart leftBoot = this.bodyRoot.getChild("left_boot");
            leftBoot.render(poseStack, MASK.wrap(multiBufferSource.getBuffer(COSMIC_ARMOR_RENDER_TYPE)), packedLight, packedOverlay, new Color(red, green, blue, alpha).getRGB());
            ModelPart rightBoot = this.bodyRoot.getChild("right_boot");
            rightBoot.render(poseStack, MASK.wrap(multiBufferSource.getBuffer(COSMIC_ARMOR_RENDER_TYPE)), packedLight, packedOverlay, new Color(red, green, blue, alpha).getRGB());
            poseStack.popPose();
        }
        if (headItem == AvaritiaItems.INFINITY_HELMET.get() && chestItem == AvaritiaItems.INFINITY_CHESTPLATE.get() && legsItem == AvaritiaItems.INFINITY_LEGGINGS.get() && feetItem == AvaritiaItems.INFINITY_BOOTS.get()) {
            poseStack.pushPose();
            ModelPart hat = this.bodyRoot.getChild("hat");
            float hue = (float)(System.currentTimeMillis() - AvaritiaClientEvent.lastTime) / 2000.0f;
            int rgb = Color.HSBtoRGB(hue, 1.0f, 1.0f);
            float r = (float)(rgb >> 16 & 0xFF) / 255.0f;
            float g = (float)(rgb >> 8 & 0xFF) / 255.0f;
            float b = (float)(rgb >> 0 & 0xFF) / 255.0f;
            hat.render(poseStack, multiBufferSource.getBuffer(AvaritiaRenderType.Glow(EYE)), packedLight, packedOverlay, new Color(r, g, b, alpha).getRGB());
            super.renderToBuffer(poseStack, MASK_INV.wrap(multiBufferSource.getBuffer(COSMIC_ARMOR_RENDER_TYPE)), packedLight, packedOverlay, new Color(red, green, blue, alpha).getRGB());
            poseStack.popPose();
        }
    }
}

