/*
 * Decompiled with CFR 0.152.
 */
package net.byAqua3.avaritia.network;

import io.netty.buffer.ByteBuf;
import io.netty.buffer.ByteBufUtil;
import io.netty.buffer.Unpooled;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import java.util.function.UnaryOperator;
import net.byAqua3.avaritia.Avaritia;
import net.byAqua3.avaritia.loader.AvaritiaSingularities;
import net.byAqua3.avaritia.singularity.Singularity;
import net.minecraft.network.RegistryFriendlyByteBuf;
import net.minecraft.network.codec.ByteBufCodecs;
import net.minecraft.network.codec.StreamCodec;
import net.minecraft.network.protocol.common.custom.CustomPacketPayload;
import net.minecraft.resources.ResourceLocation;
import net.neoforged.neoforge.network.handling.IPayloadContext;
import net.neoforged.neoforge.network.handling.IPayloadHandler;

public record PacketSingularitySync(List<Singularity> singularities) implements CustomPacketPayload
{
    public static final CustomPacketPayload.Type<PacketSingularitySync> TYPE = new CustomPacketPayload.Type(ResourceLocation.tryBuild((String)"avaritia", (String)"singularity_sync"));
    public static final StreamCodec<RegistryFriendlyByteBuf, PacketSingularitySync> STREAM_CODEC = StreamCodec.composite((StreamCodec)new StreamCodec<RegistryFriendlyByteBuf, Singularity>(){

        public void encode(RegistryFriendlyByteBuf buf, Singularity singularity) {
            RegistryFriendlyByteBuf tmpBuf = new RegistryFriendlyByteBuf(Unpooled.buffer(), buf.registryAccess());
            try {
                Singularity.streamCodec().encode((Object)tmpBuf, (Object)singularity);
            }
            catch (Throwable throwable) {
                tmpBuf.release();
                buf.writeBoolean(false);
                Avaritia.LOGGER.debug("Failed to encode singularity: %s".formatted(singularity), throwable);
                return;
            }
            buf.writeBoolean(true);
            RegistryFriendlyByteBuf.writeByteArray((ByteBuf)buf, (byte[])ByteBufUtil.getBytes((ByteBuf)tmpBuf));
            tmpBuf.release();
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public Singularity decode(RegistryFriendlyByteBuf buf) {
            boolean success = buf.readBoolean();
            if (!success) {
                return null;
            }
            RegistryFriendlyByteBuf tmpBuf = new RegistryFriendlyByteBuf(Unpooled.wrappedBuffer((byte[])RegistryFriendlyByteBuf.readByteArray((ByteBuf)buf)), buf.registryAccess());
            try {
                Singularity singularity = (Singularity)Singularity.streamCodec().decode((Object)tmpBuf);
                return singularity;
            }
            catch (Throwable throwable) {
                Singularity singularity = null;
                return singularity;
            }
            finally {
                tmpBuf.release();
            }
        }
    }.apply(ByteBufCodecs.collection(ArrayList::new)).map(list -> list.stream().filter(Objects::nonNull).toList(), UnaryOperator.identity()), PacketSingularitySync::singularities, PacketSingularitySync::new);

    public CustomPacketPayload.Type<? extends CustomPacketPayload> type() {
        return TYPE;
    }

    public static class Handler
    implements IPayloadHandler<PacketSingularitySync> {
        public void handle(PacketSingularitySync packet, IPayloadContext context) {
            context.enqueueWork(() -> {
                AvaritiaSingularities.getInstance().getSingularities().clear();
                AvaritiaSingularities.getInstance().getSingularities().addAll(packet.singularities);
            });
        }
    }
}

