/*
 * Decompiled with CFR 0.152.
 */
package net.byAqua3.avaritia.recipe;

import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.MapCodec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import java.util.ArrayList;
import java.util.List;
import javax.annotation.Nullable;
import net.byAqua3.avaritia.item.ItemInfinitySingularity;
import net.byAqua3.avaritia.item.ItemJsonSingularity;
import net.byAqua3.avaritia.item.ItemSingularity;
import net.byAqua3.avaritia.loader.AvaritiaDataComponents;
import net.byAqua3.avaritia.loader.AvaritiaRecipes;
import net.byAqua3.avaritia.loader.AvaritiaSingularities;
import net.byAqua3.avaritia.recipe.RecipeExtremeCrafting;
import net.byAqua3.avaritia.singularity.Singularity;
import net.minecraft.core.HolderLookup;
import net.minecraft.core.NonNullList;
import net.minecraft.core.component.DataComponentType;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.network.RegistryFriendlyByteBuf;
import net.minecraft.network.codec.ByteBufCodecs;
import net.minecraft.network.codec.StreamCodec;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.CraftingInput;
import net.minecraft.world.item.crafting.Ingredient;
import net.minecraft.world.item.crafting.PlacementInfo;
import net.minecraft.world.item.crafting.Recipe;
import net.minecraft.world.item.crafting.RecipeBookCategory;
import net.minecraft.world.item.crafting.RecipeSerializer;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.neoforged.neoforge.common.crafting.DataComponentIngredient;
import net.neoforged.neoforge.common.util.RecipeMatcher;

public class RecipeExtremeShapeless
implements RecipeExtremeCrafting {
    public final String group;
    public final ItemStack result;
    public final List<Ingredient> ingredients;
    public final boolean hasSingularities;
    @Nullable
    private PlacementInfo placementInfo;
    private final boolean isSimple;

    public RecipeExtremeShapeless(String group, ItemStack result, List<Ingredient> ingredients, boolean hasSingularities) {
        this.group = group;
        this.result = result;
        this.ingredients = NonNullList.copyOf(ingredients);
        this.hasSingularities = hasSingularities;
        this.isSimple = hasSingularities ? false : this.getIngredients().stream().allMatch(Ingredient::isSimple);
    }

    public boolean matches(CraftingInput container, Level level) {
        if (container.ingredientCount() != this.getIngredients().size()) {
            return false;
        }
        if (!this.isSimple) {
            ArrayList<ItemStack> nonEmptyItems = new ArrayList<ItemStack>(container.ingredientCount());
            for (ItemStack item : container.items()) {
                if (item.isEmpty()) continue;
                nonEmptyItems.add(item);
            }
            return RecipeMatcher.findMatches(nonEmptyItems, this.getIngredients()) != null;
        }
        return container.size() == 1 && this.getIngredients().size() == 1 ? this.getIngredients().getFirst().test(container.getItem(0)) : container.stackedContents().canCraft((Recipe)this, null);
    }

    public boolean showNotification() {
        return false;
    }

    public ItemStack assemble(CraftingInput container, HolderLookup.Provider registryAccess) {
        return this.getResultItem(registryAccess).copy();
    }

    @Override
    public ItemStack getResultItem(HolderLookup.Provider registryAccess) {
        return this.result;
    }

    public List<Ingredient> getIngredients() {
        if (this.hasSingularities) {
            ArrayList<Ingredient> ingredients = new ArrayList<Ingredient>();
            ingredients.addAll(this.ingredients);
            for (int i = 0; i < BuiltInRegistries.ITEM.size(); ++i) {
                Item item = (Item)BuiltInRegistries.ITEM.byId(i);
                if (!(item instanceof ItemSingularity) || item instanceof ItemInfinitySingularity) continue;
                if (!(item instanceof ItemJsonSingularity)) {
                    ingredients.add(DataComponentIngredient.of((boolean)false, (ItemStack)new ItemStack((ItemLike)item)));
                    continue;
                }
                for (Singularity singularity : AvaritiaSingularities.getInstance().getSingularities()) {
                    ingredients.add(DataComponentIngredient.of((boolean)true, (DataComponentType)((DataComponentType)AvaritiaDataComponents.SINGULARITY_ID.get()), (Object)singularity.getId(), (ItemLike[])new ItemLike[]{item}));
                }
            }
            return NonNullList.copyOf(ingredients);
        }
        return this.ingredients;
    }

    public RecipeBookCategory recipeBookCategory() {
        return null;
    }

    public PlacementInfo placementInfo() {
        if (this.placementInfo == null) {
            this.placementInfo = PlacementInfo.create(this.getIngredients());
        }
        return this.placementInfo;
    }

    public RecipeSerializer<? extends Recipe<CraftingInput>> getSerializer() {
        return (RecipeSerializer)AvaritiaRecipes.EXTREME_SHAPELESS_RECIPE.get();
    }

    public static class Serializer
    implements RecipeSerializer<RecipeExtremeShapeless> {
        public static final MapCodec<RecipeExtremeShapeless> CODEC = RecordCodecBuilder.mapCodec(instance -> instance.group((App)Codec.STRING.optionalFieldOf("group", (Object)"").forGetter(recipe -> recipe.group), (App)ItemStack.STRICT_CODEC.fieldOf("result").forGetter(recipe -> recipe.result), (App)Ingredient.CODEC.listOf().fieldOf("ingredients").forGetter(recipe -> recipe.ingredients), (App)Codec.BOOL.optionalFieldOf("singularities", (Object)false).forGetter(recipe -> recipe.hasSingularities)).apply((Applicative)instance, RecipeExtremeShapeless::new));
        public static final StreamCodec<RegistryFriendlyByteBuf, RecipeExtremeShapeless> STREAM_CODEC = StreamCodec.composite((StreamCodec)ByteBufCodecs.STRING_UTF8, recipe -> recipe.group, (StreamCodec)ItemStack.STREAM_CODEC, recipe -> recipe.result, (StreamCodec)Ingredient.CONTENTS_STREAM_CODEC.apply(ByteBufCodecs.list()), recipe -> recipe.ingredients, (StreamCodec)ByteBufCodecs.BOOL, recipe -> recipe.hasSingularities, RecipeExtremeShapeless::new);

        public MapCodec<RecipeExtremeShapeless> codec() {
            return CODEC;
        }

        public StreamCodec<RegistryFriendlyByteBuf, RecipeExtremeShapeless> streamCodec() {
            return STREAM_CODEC;
        }
    }
}

