/*
 * Decompiled with CFR 0.152.
 */
package net.byAqua3.avaritia.render.blockentity;

import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.VertexConsumer;
import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.MapCodec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import net.byAqua3.avaritia.render.blockentity.RenderInfinityChest;
import net.minecraft.client.model.ChestModel;
import net.minecraft.client.model.geom.EntityModelSet;
import net.minecraft.client.model.geom.ModelLayers;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.client.renderer.special.NoDataSpecialModelRenderer;
import net.minecraft.client.renderer.special.SpecialModelRenderer;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.ItemDisplayContext;
import net.neoforged.api.distmarker.Dist;
import net.neoforged.api.distmarker.OnlyIn;

@OnlyIn(value=Dist.CLIENT)
public class RenderItemInfinityChest
implements NoDataSpecialModelRenderer {
    private final ChestModel model;

    public RenderItemInfinityChest(ChestModel model) {
        this.model = model;
    }

    public void render(ItemDisplayContext context, PoseStack poseStack, MultiBufferSource multiBufferSource, int packedLight, int packedOverlay, boolean hasFoilType) {
        VertexConsumer vertexconsumer = RenderInfinityChest.getMaterial().buffer(multiBufferSource, RenderType::entitySolid);
        this.model.setupAnim(0.0f);
        this.model.renderToBuffer(poseStack, vertexconsumer, packedLight, packedOverlay);
    }

    @OnlyIn(value=Dist.CLIENT)
    public record Unbaked(ResourceLocation texture) implements SpecialModelRenderer.Unbaked
    {
        public static final MapCodec<Unbaked> MAP_CODEC = RecordCodecBuilder.mapCodec(p_388545_ -> p_388545_.group((App)ResourceLocation.CODEC.fieldOf("texture").forGetter(Unbaked::texture)).apply((Applicative)p_388545_, Unbaked::new));

        public MapCodec<Unbaked> type() {
            return MAP_CODEC;
        }

        public SpecialModelRenderer<?> bake(EntityModelSet entityModelSet) {
            ChestModel chestModel = new ChestModel(entityModelSet.bakeLayer(ModelLayers.CHEST));
            return new RenderItemInfinityChest(chestModel);
        }
    }
}

