/*
 * Decompiled with CFR 0.152.
 */
package net.byAqua3.avaritia.render.special;

import com.mojang.blaze3d.platform.GlStateManager;
import com.mojang.blaze3d.systems.RenderSystem;
import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.VertexConsumer;
import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.MapCodec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import java.util.List;
import java.util.Random;
import net.byAqua3.avaritia.item.ItemHalo;
import net.byAqua3.avaritia.item.ItemSingularity;
import net.byAqua3.avaritia.loader.AvaritiaAtlas;
import net.byAqua3.avaritia.util.AvaritiaRenderUtils;
import net.minecraft.client.Minecraft;
import net.minecraft.client.model.geom.EntityModelSet;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.client.renderer.block.model.BakedQuad;
import net.minecraft.client.renderer.item.ItemStackRenderState;
import net.minecraft.client.renderer.special.SpecialModelRenderer;
import net.minecraft.client.resources.model.BakedModel;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.RandomSource;
import net.minecraft.world.item.ItemDisplayContext;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.neoforged.api.distmarker.Dist;
import net.neoforged.api.distmarker.OnlyIn;

@OnlyIn(value=Dist.CLIENT)
public class SpecialRenderHalo
implements SpecialModelRenderer<ItemHalo> {
    private final ItemStackRenderState scratchItemStackRenderState = new ItemStackRenderState();

    public void render(ItemHalo halo, ItemDisplayContext context, PoseStack poseStack, MultiBufferSource multiBufferSource, int packedLight, int packedOverlay, boolean hasFoilType) {
        poseStack.pushPose();
        Minecraft mc = Minecraft.getInstance();
        ItemStack itemStack = new ItemStack((ItemLike)halo);
        int type = halo.getType();
        float alpha = halo.getAlpha();
        VertexConsumer vertexConsumer = multiBufferSource.getBuffer(RenderType.itemEntityTranslucentCull((ResourceLocation)AvaritiaAtlas.BLOCK_ATLAS));
        if (context == ItemDisplayContext.GUI) {
            List<BakedQuad> quads;
            PoseStack.Pose posestack$pose;
            if (type == 0) {
                poseStack.pushPose();
                posestack$pose = poseStack.last();
                RenderSystem.enableBlend();
                RenderSystem.blendFunc((GlStateManager.SourceFactor)GlStateManager.SourceFactor.SRC_ALPHA, (GlStateManager.DestFactor)GlStateManager.DestFactor.ONE_MINUS_SRC_ALPHA);
                RenderSystem.disableDepthTest();
                poseStack.scale(2.25f, 2.25f, 1.0f);
                poseStack.translate(-0.295f, -0.265f, 0.0f);
                quads = AvaritiaRenderUtils.bakeItem(Minecraft.getInstance().getModelManager().getAtlas(AvaritiaAtlas.BLOCK_ATLAS).getSprite(ResourceLocation.tryBuild((String)"avaritia", (String)"item/halo")));
                for (BakedQuad quad : quads) {
                    vertexConsumer.putBulkData(posestack$pose, quad, 0.0f, 0.0f, 0.0f, alpha, packedLight, packedOverlay, true);
                }
                poseStack.popPose();
            } else if (type == 1) {
                poseStack.pushPose();
                posestack$pose = poseStack.last();
                poseStack.scale(2.0f, 2.0f, 1.0f);
                poseStack.translate(-0.25f, -0.255f, 0.0f);
                quads = AvaritiaRenderUtils.bakeItem(Minecraft.getInstance().getModelManager().getAtlas(AvaritiaAtlas.BLOCK_ATLAS).getSprite(ResourceLocation.tryBuild((String)"avaritia", (String)"item/halo_noise")));
                for (BakedQuad quad : quads) {
                    vertexConsumer.putBulkData(posestack$pose, quad, 1.0f, 1.0f, 1.0f, alpha, packedLight, packedOverlay, true);
                }
                poseStack.popPose();
            }
            if (type == 2) {
                poseStack.pushPose();
                posestack$pose = poseStack.last();
                poseStack.scale(1.5f, 1.5f, 1.0f);
                poseStack.translate(-0.17f, -0.155f, 0.0f);
                quads = AvaritiaRenderUtils.bakeItem(Minecraft.getInstance().getModelManager().getAtlas(AvaritiaAtlas.BLOCK_ATLAS).getSprite(ResourceLocation.tryBuild((String)"avaritia", (String)"item/halo")));
                for (BakedQuad quad : quads) {
                    vertexConsumer.putBulkData(posestack$pose, quad, 0.0f, 0.0f, 0.0f, alpha, packedLight, packedOverlay, true);
                }
                poseStack.popPose();
            }
            if (type == 0 || halo.getPulse()) {
                float scale = new Random().nextFloat() * 0.1f + 0.95f;
                double translate = (1.0 - (double)scale) / 2.0;
                poseStack.scale(scale, scale, 1.0001f);
                poseStack.translate(translate, translate, 0.0);
            }
        }
        if (halo instanceof ItemSingularity) {
            poseStack.pushPose();
            PoseStack.Pose posestack$pose = poseStack.last();
            ItemSingularity singularity = (ItemSingularity)halo;
            for (int i = 0; i < 2; ++i) {
                quads = AvaritiaRenderUtils.bakeItem(Minecraft.getInstance().getModelManager().getAtlas(AvaritiaAtlas.BLOCK_ATLAS).getSprite(ResourceLocation.tryBuild((String)"avaritia", (String)("item/singularity/singularity_layer_" + i))));
                float r = (float)(i == 0 ? singularity.getColor(itemStack).getRed() : singularity.getLayerColor(itemStack).getRed()) / 255.0f;
                float g = (float)(i == 0 ? singularity.getColor(itemStack).getGreen() : singularity.getLayerColor(itemStack).getGreen()) / 255.0f;
                float b = (float)(i == 0 ? singularity.getColor(itemStack).getBlue() : singularity.getLayerColor(itemStack).getBlue()) / 255.0f;
                float a = (float)(i == 0 ? singularity.getColor(itemStack).getAlpha() : singularity.getLayerColor(itemStack).getAlpha()) / 255.0f;
                for (BakedQuad quad : quads) {
                    vertexConsumer.putBulkData(posestack$pose, quad, r, g, b, a, packedLight, packedOverlay, true);
                }
            }
            poseStack.popPose();
        } else {
            Minecraft.getInstance().getItemModelResolver().updateForTopItem(this.scratchItemStackRenderState, itemStack, context, false, (Level)mc.level, null, 42);
            for (int i = 0; i < this.scratchItemStackRenderState.activeLayerCount; ++i) {
                BakedModel bakedModel = this.scratchItemStackRenderState.layers[i].model;
                RandomSource randomSource = RandomSource.create();
                randomSource.setSeed(42L);
                quads = bakedModel.getQuads(null, null, randomSource);
                for (BakedQuad quad : quads) {
                    vertexConsumer.putBulkData(poseStack.last(), quad, 1.0f, 1.0f, 1.0f, 1.0f, packedLight, packedOverlay, true);
                }
            }
        }
        poseStack.popPose();
    }

    public ItemHalo extractArgument(ItemStack stack) {
        if (stack.getItem() instanceof ItemHalo) {
            return (ItemHalo)stack.getItem();
        }
        return null;
    }

    @OnlyIn(value=Dist.CLIENT)
    public record Unbaked(ResourceLocation texture) implements SpecialModelRenderer.Unbaked
    {
        public static final MapCodec<Unbaked> MAP_CODEC = RecordCodecBuilder.mapCodec(instance -> instance.group((App)ResourceLocation.CODEC.fieldOf("texture").forGetter(Unbaked::texture)).apply((Applicative)instance, Unbaked::new));

        public MapCodec<Unbaked> type() {
            return MAP_CODEC;
        }

        public SpecialModelRenderer<?> bake(EntityModelSet entityModelSet) {
            return new SpecialRenderHalo();
        }
    }
}

