/*
 * Decompiled with CFR 0.152.
 */
package net.byAqua3.avaritia.render.special;

import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.VertexConsumer;
import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.MapCodec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import java.util.List;
import net.byAqua3.avaritia.item.ItemMatterCluster;
import net.byAqua3.avaritia.loader.AvaritiaAtlas;
import net.byAqua3.avaritia.loader.AvaritiaDataComponents;
import net.byAqua3.avaritia.shader.AvaritiaCosmicShaders;
import net.byAqua3.avaritia.shader.AvaritiaRenderType;
import net.byAqua3.avaritia.util.AvaritiaRenderUtils;
import net.minecraft.client.Minecraft;
import net.minecraft.client.model.geom.EntityModelSet;
import net.minecraft.client.renderer.CompiledShaderProgram;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.client.renderer.ShaderManager;
import net.minecraft.client.renderer.block.model.BakedQuad;
import net.minecraft.client.renderer.item.ItemStackRenderState;
import net.minecraft.client.renderer.special.SpecialModelRenderer;
import net.minecraft.client.renderer.texture.TextureAtlasSprite;
import net.minecraft.client.resources.model.BakedModel;
import net.minecraft.core.component.DataComponentType;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.RandomSource;
import net.minecraft.world.item.ItemDisplayContext;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.neoforged.api.distmarker.Dist;
import net.neoforged.api.distmarker.OnlyIn;

@OnlyIn(value=Dist.CLIENT)
public class SpecialRenderMatterCluster
implements SpecialModelRenderer<ItemStack> {
    private final ItemStackRenderState scratchItemStackRenderState = new ItemStackRenderState();
    private final boolean full;

    public SpecialRenderMatterCluster(boolean full) {
        this.full = full;
    }

    public void render(ItemStack stack, ItemDisplayContext context, PoseStack poseStack, MultiBufferSource multiBufferSource, int packedLight, int packedOverlay, boolean hasFoilType) {
        poseStack.pushPose();
        RenderType COSMIC_RENDER_TYPE = AvaritiaRenderType.COSMIC_RENDER_TYPE;
        Minecraft mc = Minecraft.getInstance();
        VertexConsumer vertexConsumer = multiBufferSource.getBuffer(RenderType.itemEntityTranslucentCull((ResourceLocation)AvaritiaAtlas.BLOCK_ATLAS));
        Minecraft.getInstance().getItemModelResolver().updateForTopItem(this.scratchItemStackRenderState, stack, context, false, (Level)mc.level, null, 42);
        for (int i = 0; i < this.scratchItemStackRenderState.activeLayerCount; ++i) {
            BakedModel bakedModel = this.scratchItemStackRenderState.layers[i].model;
            RandomSource randomSource = RandomSource.create();
            randomSource.setSeed(42L);
            List quads = bakedModel.getQuads(null, null, randomSource);
            for (BakedQuad quad : quads) {
                vertexConsumer.putBulkData(poseStack.last(), quad, 1.0f, 1.0f, 1.0f, 1.0f, packedLight, packedOverlay, true);
            }
        }
        if (multiBufferSource instanceof MultiBufferSource.BufferSource) {
            MultiBufferSource.BufferSource bufferSource = (MultiBufferSource.BufferSource)multiBufferSource;
            bufferSource.endBatch();
        }
        float yaw = 0.0f;
        float pitch = 0.0f;
        float scale = 1.0f;
        if (AvaritiaCosmicShaders.cosmicInventoryRender || context == ItemDisplayContext.GUI) {
            scale = 100.0f;
        } else {
            yaw = (float)((double)(mc.player.getYRot() * 2.0f) * Math.PI / 360.0);
            pitch = -((float)((double)(mc.player.getXRot() * 2.0f) * Math.PI / 360.0));
        }
        ShaderManager shaderManager = Minecraft.getInstance().getShaderManager();
        CompiledShaderProgram compiledShaderProgram = shaderManager.getProgram(AvaritiaCosmicShaders.cosmicShader);
        compiledShaderProgram.getUniform("time").set((float)(mc.level.getGameTime() % Integer.MAX_VALUE));
        compiledShaderProgram.getUniform("yaw").set(yaw);
        compiledShaderProgram.getUniform("pitch").set(pitch);
        compiledShaderProgram.getUniform("externalScale").set(scale);
        compiledShaderProgram.getUniform("opacity").set(1.0f);
        compiledShaderProgram.getUniform("cosmicuvs").set(AvaritiaCosmicShaders.COSMIC_UVS);
        TextureAtlasSprite[] textureAtlasSprites = null;
        if (stack.getItem() instanceof ItemMatterCluster) {
            if (this.full) {
                textureAtlasSprites = new TextureAtlasSprite[]{Minecraft.getInstance().getModelManager().getAtlas(AvaritiaAtlas.BLOCK_ATLAS).getSprite(ResourceLocation.tryBuild((String)"avaritia", (String)"item/matter_cluster_full_mask"))};
            } else {
                if (stack.has((DataComponentType)AvaritiaDataComponents.CLUSTER_CONTAINER.get())) {
                    compiledShaderProgram.getUniform("opacity").set(Float.valueOf(ItemMatterCluster.getClusterCount(ItemMatterCluster.getClusterItems(stack))).floatValue() / Float.valueOf(4096.0f).floatValue());
                }
                textureAtlasSprites = new TextureAtlasSprite[]{Minecraft.getInstance().getModelManager().getAtlas(AvaritiaAtlas.BLOCK_ATLAS).getSprite(ResourceLocation.tryBuild((String)"avaritia", (String)"item/matter_cluster_empty_mask"))};
            }
        }
        if (textureAtlasSprites != null) {
            List<BakedQuad> quads = AvaritiaRenderUtils.bakeItem(textureAtlasSprites);
            for (BakedQuad quad : quads) {
                multiBufferSource.getBuffer(COSMIC_RENDER_TYPE).putBulkData(poseStack.last(), quad, 1.0f, 1.0f, 1.0f, 1.0f, packedLight, packedOverlay, true);
            }
        }
        poseStack.popPose();
    }

    public ItemStack extractArgument(ItemStack stack) {
        if (stack.getItem() instanceof ItemMatterCluster) {
            return stack;
        }
        return ItemStack.EMPTY;
    }

    @OnlyIn(value=Dist.CLIENT)
    public record Unbaked(ResourceLocation texture, boolean full) implements SpecialModelRenderer.Unbaked
    {
        public static final MapCodec<Unbaked> MAP_CODEC = RecordCodecBuilder.mapCodec(instance -> instance.group((App)ResourceLocation.CODEC.fieldOf("texture").forGetter(Unbaked::texture), (App)Codec.BOOL.optionalFieldOf("full", (Object)false).forGetter(Unbaked::full)).apply((Applicative)instance, Unbaked::new));

        public MapCodec<Unbaked> type() {
            return MAP_CODEC;
        }

        public SpecialModelRenderer<?> bake(EntityModelSet entityModelSet) {
            return new SpecialRenderMatterCluster(this.full);
        }
    }
}

