/*
 * Decompiled with CFR 0.152.
 */
package net.byAqua3.avaritia.util;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Comparator;
import java.util.List;
import net.byAqua3.avaritia.inventory.ContainerExtremeCrafting;
import net.byAqua3.avaritia.recipe.RecipeCompressor;
import net.byAqua3.avaritia.recipe.RecipeExtremeCrafting;
import net.byAqua3.avaritia.recipe.RecipeExtremeShaped;
import net.byAqua3.avaritia.recipe.RecipeExtremeShapeless;
import net.minecraft.core.HolderLookup;
import net.minecraft.core.RegistryAccess;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.world.SimpleContainer;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.RecipeHolder;
import net.minecraft.world.item.crafting.RecipeManager;
import net.minecraft.world.level.Level;

public class AvaritiaRecipeUtils {
    public static List<RecipeExtremeCrafting> getExtremeCraftingRecipes(RecipeManager recipeManager) {
        Collection recipes = recipeManager.getRecipes();
        ArrayList<RecipeExtremeCrafting> recipeList = new ArrayList<RecipeExtremeCrafting>();
        for (RecipeHolder recipe : recipes) {
            if (!(recipe.value() instanceof RecipeExtremeShaped) && !(recipe.value() instanceof RecipeExtremeShapeless)) continue;
            recipeList.add((RecipeExtremeCrafting)recipe.value());
        }
        recipeList.sort(new Comparator<RecipeExtremeCrafting>(){

            @Override
            public int compare(RecipeExtremeCrafting recipe1, RecipeExtremeCrafting recipe2) {
                int itemId1 = BuiltInRegistries.ITEM.getId((Object)recipe1.getResultItem((HolderLookup.Provider)RegistryAccess.EMPTY).getItem());
                int itemId2 = BuiltInRegistries.ITEM.getId((Object)recipe2.getResultItem((HolderLookup.Provider)RegistryAccess.EMPTY).getItem());
                return Integer.valueOf(itemId1).compareTo(itemId2);
            }
        });
        return recipeList;
    }

    public static List<RecipeExtremeCrafting> getExtremeCraftingRecipes(Level level) {
        if (level.getServer() == null) {
            return new ArrayList<RecipeExtremeCrafting>();
        }
        return AvaritiaRecipeUtils.getExtremeCraftingRecipes(level.getServer().getRecipeManager());
    }

    public static List<RecipeCompressor> getCompressorRecipes(RecipeManager recipeManager) {
        Collection recipes = recipeManager.getRecipes();
        ArrayList<RecipeCompressor> recipeList = new ArrayList<RecipeCompressor>();
        for (RecipeHolder recipe : recipes) {
            if (!(recipe.value() instanceof RecipeCompressor)) continue;
            RecipeCompressor recipeCompressor = (RecipeCompressor)recipe.value();
            if (recipeCompressor.ingredients.isEmpty()) continue;
            recipeList.add(recipeCompressor);
        }
        recipeList.sort(new Comparator<RecipeCompressor>(){

            @Override
            public int compare(RecipeCompressor recipe1, RecipeCompressor recipe2) {
                int itemId1 = BuiltInRegistries.ITEM.getId((Object)recipe1.getResultItem((HolderLookup.Provider)RegistryAccess.EMPTY).getItem());
                int itemId2 = BuiltInRegistries.ITEM.getId((Object)recipe2.getResultItem((HolderLookup.Provider)RegistryAccess.EMPTY).getItem());
                return Integer.valueOf(itemId1).compareTo(itemId2);
            }
        });
        return recipeList;
    }

    public static List<RecipeCompressor> getCompressorRecipes(Level level) {
        if (level.getServer() == null) {
            return new ArrayList<RecipeCompressor>();
        }
        return AvaritiaRecipeUtils.getCompressorRecipes(level.getServer().getRecipeManager());
    }

    public static RecipeCompressor getCompressorRecipe(RecipeManager recipeManager, ItemStack input) {
        Collection recipes = recipeManager.getRecipes();
        SimpleContainer matrix = new SimpleContainer(1);
        matrix.addItem(input);
        ContainerExtremeCrafting crafting = new ContainerExtremeCrafting(null, 1, 1, matrix);
        for (RecipeHolder recipe : recipes) {
            RecipeCompressor recipeCompressor;
            if (!(recipe.value() instanceof RecipeCompressor) || !(recipeCompressor = (RecipeCompressor)recipe.value()).matches(crafting.asCraftInput(), null)) continue;
            return recipeCompressor;
        }
        return null;
    }

    public static RecipeCompressor getCompressorRecipe(Level level, ItemStack input) {
        if (level.getServer() == null) {
            return null;
        }
        return AvaritiaRecipeUtils.getCompressorRecipe(level.getServer().getRecipeManager(), input);
    }

    public static RecipeCompressor getCompressorRecipeFromResult(RecipeManager recipeManager, ItemStack result) {
        Collection recipes = recipeManager.getRecipes();
        for (RecipeHolder recipe : recipes) {
            RecipeCompressor recipeCompressor;
            if (!(recipe.value() instanceof RecipeCompressor) || !ItemStack.isSameItemSameComponents((ItemStack)(recipeCompressor = (RecipeCompressor)recipe.value()).getResultItem((HolderLookup.Provider)RegistryAccess.EMPTY), (ItemStack)result)) continue;
            return recipeCompressor;
        }
        return null;
    }

    public static RecipeCompressor getCompressorRecipeFromResult(Level level, ItemStack result) {
        if (level.getServer() == null) {
            return null;
        }
        return AvaritiaRecipeUtils.getCompressorRecipeFromResult(level.getServer().getRecipeManager(), result);
    }
}

